<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        baselineSettingRepeating.jsp
  -- Controller:  db/adm/inst/BaselineController.java
  --
  -- Description: Page for the repeating baseline setting, the second step of
  --              creating a baseline.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.instance.baseline.BaselineConst" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="DBObjectMsg"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    
    <%-- HTML Page Title --%>
  
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="bslnC2RForm"
               method="post"              
               destination="awrBaseline"
               copyParams="target,type,cancelURL">
      <uix:formValue name="pageName" value="<%= BaselineConst.BSLN_SETTING_REPEATING_PG %>"/>
        <uix:pageLayout titleBinding="creatingStep2Header@baselineBean@servletRequest">
        
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>
        
          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- START: Specify baseline setting contents starts here --%>   
          <%-- baseline name prefix --%>
          <uix:stackLayout>
            <uix:spacer height="5"/>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="BSLN_INTVL_REPEATING_TIP@DBMsg" />
            <uix:spacer height="5"/>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right"> 
                <uix:messagePrompt  promptBinding="BSLN_NAME_PREFIX@DBMsg" 
                                    labeledNodeId="baselineNameId" 
                                    required="yes"/>
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="left">
                <uix:textInput name="baselineName" 
                               id="baselineNameId"
                               textBinding="baselineName@settingBean@baselineBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:stackLayout>

          <%-- baseline start time --%>
          <uix:header textBinding="BSLN_REPEAT_START_TIME@DBMsg">
            <uix:spacer height="5"/>
            <uix:rowLayout >
              <uix:cellFormat > 
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right"> 
                    <uix:messagePrompt  promptBinding="BSLN_TIME_IN_DAY@DBMsg"/>
                  </uix:cellFormat>
                  <uix:spacer width="5"/>

                  <uix:flowLayout>
                    <oem:choice
                                 name="repeatHourSB"
                                 optionsBinding="hoursSB@settingBean@baselineBean@servletRequest" 
                                 selectedValueBinding="repeatHourSB@settingBean@baselineBean@servletRequest"
                    />
                    <oem:choice
                                 name="repeatAMPM"
                                 optionsBinding="AMPMSB@settingBean@baselineBean@servletRequest" 
                                 selectedValueBinding="repeatAMPM@settingBean@baselineBean@servletRequest"
                    />
                  </uix:flowLayout>
                </uix:rowLayout>
              </uix:cellFormat > 
              <uix:spacer width="30"/>
              <uix:cellFormat > 
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right"> 
                    <uix:styledText labeledNodeId="durationHourId"
                                    styleClass="OraPromptText" 
                                    textBinding="BSLN_DURATION@DBMsg"/>
                  </uix:cellFormat>
                  <uix:spacer width="5"/>
                  <uix:cellFormat hAlign="left">
                    <uix:textInput name="durationHourSB" 
                                   id="durationHourId" 
                                   columns="2"
                                   textBinding="durationHourSB@settingBean@baselineBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:cellFormat > 
            </uix:rowLayout>
          </uix:header>

          <%-- baseline frequency --%>
          <uix:header textBinding="BSLN_FREQUENCY@DBMsg">
            <uix:stackLayout>
            
               <oem:radioButton name="frequencyType"
                                textBinding="BSLN_DAILY@DBMsg"
                                value="<%= BaselineConst.FREQUENCY_DAILY %>"
                                selectedValueBinding="frequencyType@settingBean@baselineBean@servletRequest" />
              
               <oem:radioButton name="frequencyType"
                                textBinding="BSLN_WEEKLY@DBMsg"
                                value="<%= BaselineConst.FREQUENCY_WEEKLY %>"
                                selectedValueBinding="frequencyType@settingBean@baselineBean@servletRequest" />
         
            </uix:stackLayout>
 
            <uix:rowLayout>
              <uix:spacer width="20"/>

              <oem:radioButton name="frequencyDay"
                               textBinding="BSLN_MONDAY@DBMsg"
                               value="<%= BaselineConst.FREQUENCY_MONDAY %>"
                               selectedValueBinding="frequencyDay@settingBean@baselineBean@servletRequest" />
              <oem:radioButton name="frequencyDay"
                               textBinding="BSLN_TUESDAY@DBMsg"
                               value="<%= BaselineConst.FREQUENCY_TUESDAY %>"
                               selectedValueBinding="frequencyDay@settingBean@baselineBean@servletRequest" />
              <oem:radioButton name="frequencyDay"
                               textBinding="BSLN_WEDNESDAY@DBMsg"
                               value="<%= BaselineConst.FREQUENCY_WEDNESDAY %>"
                               selectedValueBinding="frequencyDay@settingBean@baselineBean@servletRequest" />
              <oem:radioButton name="frequencyDay"
                               textBinding="BSLN_THURSDAY@DBMsg"
                               value="<%= BaselineConst.FREQUENCY_THURSDAY %>"
                               selectedValueBinding="frequencyDay@settingBean@baselineBean@servletRequest" />
              <oem:radioButton name="frequencyDay"
                               textBinding="BSLN_FRIDAY@DBMsg"
                               value="<%= BaselineConst.FREQUENCY_FRIDAY %>"
                               selectedValueBinding="frequencyDay@settingBean@baselineBean@servletRequest" />
             <oem:radioButton name="frequencyDay"
                               textBinding="BSLN_SATURDAY@DBMsg"
                               value="<%= BaselineConst.FREQUENCY_SATURDAY %>"
                               selectedValueBinding="frequencyDay@settingBean@baselineBean@servletRequest" />
              <oem:radioButton name="frequencyDay"
                               textBinding="BSLN_SUNDAY@DBMsg"
                               value="<%= BaselineConst.FREQUENCY_SUNDAY %>"
                               selectedValueBinding="frequencyDay@settingBean@baselineBean@servletRequest" />
 
            </uix:rowLayout>

          </uix:header>

          <%-- baseline repeating start and end time--%>
          <uix:header textBinding="BSLN_R_SAE@DBMsg">
            <uix:rowLayout >
              <uix:spacer width="20"/>
              <uix:cellFormat > 
               <uix:messagePrompt  promptBinding="BSLN_START_TIME@DBMsg" 
                                    labeledNodeId="startTimeId"/> 
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <%@ include file="startTS.jspf" %>

              <uix:spacer width="35"/>

              <uix:cellFormat > 
                <uix:messagePrompt  promptBinding="BSLN_END_TIME@DBMsg" 
                                    labeledNodeId="endTimeId"/> 
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <%@ include file="endTS.jspf" %>
            </uix:rowLayout >
<%--
            <uix:rowLayout >

              <uix:cellFormat > 
                <uix:header textBinding="BSLN_START_TIME@DBMsg">
                  <uix:rowLayout >
                    <oem:radioButton name="startTimeType"
                                     textBinding="BSLN_NOW@DBMsg"
                                     value="<%= BaselineConst.REPEATING_NOW %>"
                                     selectedValueBinding="startTimeType@settingBean@baselineBean@servletRequest" />
                  </uix:rowLayout >
                  <uix:spacer width="10"/>
                  <uix:rowLayout >
                    <oem:radioButton name="startTimeType"
                                     value="<%= BaselineConst.REPEATING_CUSTOM %>"
                                     selectedValueBinding="startTimeType@settingBean@baselineBean@servletRequest" />
                    <uix:cellFormat >
                      <uix:messageDateField id="startDateId" shortDescBinding="DATE@BaselineBundle"
                           name="startDateSB"
                           promptBinding="DATE@BaselineBundle"
                           tipBinding="dateTip@settingBean@baselineBean@servletRequest"
                           valueBinding="startDateSB@settingBean@baselineBean@pageContext"
                           columns="24">
                        <uix:onSubmitValidater>
                          <uix:date dateStyle="medium" />
                        </uix:onSubmitValidater>
                      </uix:messageDateField>
                    </uix:cellFormat>
                  </uix:rowLayout >
                </uix:header>
              </uix:cellFormat > 
              <uix:spacer width="20"/>
              <uix:cellFormat > 
                <uix:header textBinding="BSLN_END_TIME@DBMsg">
                  <uix:rowLayout >
                    <oem:radioButton name="endTimeType"
                                     textBinding="BSLN_INFINITE@DBMsg"
                                     value="<%= BaselineConst.REPEATING_INDEFINITE %>"
                                     selectedValueBinding="endTimeType@settingBean@baselineBean@servletRequest" />
                  </uix:rowLayout >
                  <uix:spacer width="10"/>
                  <uix:rowLayout >
                    <oem:radioButton name="endType"
                                     value="<%= BaselineConst.REPEATING_CUSTOM %>"
                                     selectedValueBinding="endTimeType@settingBean@baselineBean@servletRequest" />
                    <uix:cellFormat >
                      <uix:messageDateField id="endDate" shortDescBinding="DATE@BaselineBundle"
                             name="endDateSB"
                             promptBinding="DATE@BaselineBundle"
                             tipBinding="dateTip@settingBean@baselineBean@servletRequest"
                             valueBinding="endDateSB@settingBean@baselineBean@pageContext"
                             columns="24">
                        <uix:onSubmitValidater>
                          <uix:date dateStyle="medium" />
                        </uix:onSubmitValidater>
                      </uix:messageDateField>
                    </uix:cellFormat>
                  </uix:rowLayout >
                </uix:header >

              </uix:cellFormat > 

            </uix:rowLayout>
--%>
          </uix:header> 

          <%-- baseline retention --%>
          <uix:header textBinding="BSLN_RETENTION@DBMsg">
            <uix:spacer height="5"/>
            <uix:rowLayout >
              <uix:cellFormat > 
                <uix:styledText labeledNodeId="retentionHourId"
                                styleClass="OraPromptText" 
                                textBinding="BSLN_RETENTION_TIME@DBMsg"/>
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat >
                <uix:textInput name="retentionHourSB" 
                               id="retentionHourId"
                               columns="2"
                               textBinding="retentionHourSB@settingBean@baselineBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:spacer height="10"/>
          </uix:header>

          <uix:tip>
            <uix:contents>
              <uix:styledText styleClass="OraTipText" 
                              textBinding="BSLN_INTVL_REPEATING_TIP2@DBMsg"/>
            </uix:contents>
          </uix:tip>
 
          <%-- END: Specify baseline setting contents ends here --%>   
                
          <%-- Cancel/Back/Finish Button --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
          
              <%-- Cancel BUTTON --%>
              <uix:submitButton textBinding="CANCEL@DBMsg" 
                                shortDescBinding="CANCEL@DBMsg" 
                                name="event" 
                                value="<%= BaselineConst.CANCEL %>" />
              
              <%-- Back BUTTON --%>
              <uix:submitButton textBinding="BACK@DBMsg" 
                                shortDescBinding="BACK@DBMsg" 
                                name="event" 
                                value="<%= BaselineConst.INTVL_BACK %>" />
           
              <%-- OK BUTTON --%>
              <uix:submitButton textBinding="FINISH@DBMsg" 
                                shortDescBinding="FINISH@DBMsg" 
                                name="event" 
                                value="<%= BaselineConst.APPLY %>" />
          
            </uix:pageButtonBar>
          </uix:pageButtons>
        
        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
