<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        baselineSettingSingle.jsp
  -- Controller:  db/adm/inst/BaselineController.java
  --
  -- Description: Page for the single baseline setting, the second step of
  --              creating a baseline.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.instance.baseline.BaselineConst" %>
<db:script src="/database/instance/timePicker.js"/>


<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="DBObjectMsg"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    
    <%-- HTML Page Title  --%>
  
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="bslnC2SForm"     
               method="post"
               destination="awrBaseline"
               copyParams="target,type,cancelURL">
      <uix:formValue name="pageName" value="<%= BaselineConst.BSLN_SETTING_SINGLE_PG %>"/>
      <uix:formValue name="t1" value=""/>
      <uix:formValue name="t2" value=""/>
      <uix:formValue name="event" value=""/>
      <uix:formValue name="direction" value=""/> 
      <uix:formValue name="iconIndex" value=""/>

        <uix:pageLayout titleBinding="creatingStep2Header@baselineBean@servletRequest">
        
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>
        
          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- START: Specify baseline setting contents starts here --%>   
          <%-- baseline name --%>

          <uix:stackLayout>
            <uix:spacer height="5"/>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="BSLN_INTVL_SINGLE_TIP@DBMsg" />
            <uix:spacer height="5"/>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right"> 
                <uix:messagePrompt  promptBinding="BSLN_NAME@DBMsg" 
                                    labeledNodeId="baselineNameId" 
                                    required="yes"/>
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat hAlign="left">
                <uix:textInput name="baselineName" 
                               id="baselineNameId"
                               textBinding="baselineName@settingBean@baselineBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:stackLayout>

                                
          <%-- Baseline Interval--%>
          <uix:header textBinding="BSLN_INTERVAL@DBMsg">
            <uix:spacer height="5"/>
            <uix:rowLayout >
               <oem:radioButton name="rangeType"
                                textBinding="BSLN_RANGE_SS@DBMsg"
                                value="<%= BaselineConst.RANGE_SS %>"
                                selectedValueBinding="rangeType@settingBean@baselineBean@servletRequest" />
            </uix:rowLayout >
            <uix:rowLayout >
              <uix:stackLayout>
                <%-- include the time picker page segment. --%>
                <uix:ref refID="TIMEPICKER_SEGMENT" />
              </uix:stackLayout>
            </uix:rowLayout >
            <uix:rowLayout >
              
               <oem:radioButton name="rangeType"
                                textBinding="BSLN_RANGE_TIME@DBMsg"
                                value="<%= BaselineConst.RANGE_TIME %>"
                                selectedValueBinding="rangeType@settingBean@baselineBean@servletRequest" />
            </uix:rowLayout >
            <uix:spacer height="5"/>
            <uix:rowLayout >
              <uix:spacer width="20"/>
              <uix:cellFormat > 
               <uix:messagePrompt  promptBinding="BSLN_START_TIME@DBMsg" 
                                    labeledNodeId="startTimeId"/> 
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <%@ include file="startTS.jspf" %>

              <uix:spacer width="35"/>

              <uix:cellFormat > 
                <uix:messagePrompt  promptBinding="BSLN_END_TIME@DBMsg" 
                                    labeledNodeId="endTimeId"/> 
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <%@ include file="endTS.jspf" %>
            </uix:rowLayout >
            <uix:spacer height="10"/>

          </uix:header>
          <%-- END: Specify baseline setting contents ends here --%>   
          <uix:tip>
            <uix:contents>
              <uix:styledText styleClass="OraTipText" 
                              textBinding="BSLN_INTVL_SINGLE_TIP2@DBMsg"/>
            </uix:contents>
          </uix:tip>
                
          <%-- Cancel/Back/Finish Button --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
          
              <%-- Cancel BUTTON --%>
              
              <uix:submitButton textBinding="CANCEL@DBMsg" 
                                shortDescBinding="CANCEL@DBMsg" 
                                name="event" 
                                value="<%= BaselineConst.CANCEL %>" />
            
              <%-- Back BUTTON --%>
             
              <uix:submitButton textBinding="BACK@DBMsg" 
                                shortDescBinding="BACK@DBMsg" 
                                name="event" 
                                value="<%= BaselineConst.INTVL_BACK %>" />
          
              <%-- OK BUTTON --%>              
              <uix:submitButton textBinding="FINISH@DBMsg" 
                                shortDescBinding="FINISH@DBMsg" 
                                name="event" 
                                value="<%= BaselineConst.APPLY %>" />
         
            </uix:pageButtonBar>
          </uix:pageButtons>
        
        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
