<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        baselineEdit.jsp
  -- Controller:  db/adm/inst/BaselineController.java
  --
  -- Description: Page for editing the baselines
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.instance.baseline.BaselineConst" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsg"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    
    <%-- HTML Page Title --%>
  
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="bslnViewForm"
               method="post"              
               destination="awrBaseline"
               copyParams="target,type,cancelURL,oid">
      <uix:formValue name="pageName" value="<%= BaselineConst.BSLN_VIEW_PG %>"/>
        <uix:pageLayout titleBinding="header@baselineDetailsBean@servletRequest">
        
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>
        
          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>


          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <uix:link textBinding="DETAILS@DBMsg" />
                <uix:link textBinding="REPORT@DBMsg"
                          destinationBinding="reportLink@servletRequest" />
              </uix:subTabBar>
            </uix:subTabs>
            <uix:rowLayout width = "100%">
              <%-- General --%>
              <uix:cellFormat vAlign="top"> 
                <uix:header textBinding="GENERAL@DBMsg">
                  <uix:spacer height="5"/>
                  <uix:tableLayout>
                    <uix:rowLayout >
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText
                                        styleClass="OraPromptText" 
                                        textBinding="BSLN_EDIT_NAME@DBMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="baselineName@baselineDetailsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout >
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText
                                        styleClass="OraPromptText" 
                                        textBinding="BSLN_ID@DBMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="baselineID@baselineDetailsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout >
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText
                                        styleClass="OraPromptText" 
                                        textBinding="BSLN_TYPE@DBMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="baselineType@baselineDetailsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:switcher childNameBinding="baselineTypeID@baselineDetailsBean@servletRequest">
                      <uix:case name="<%= BaselineConst.BSLN_TYPE_STATIC %>">
                        <uix:rowLayout >
                          <uix:cellFormat hAlign="right"> 
                            <uix:styledText
                                            styleClass="OraPromptText" 
                                            textBinding="BSLN_CREATE_TIME@DBMsg"/>
                          </uix:cellFormat>
                          <uix:spacer width="5"/>
    
                          <uix:cellFormat hAlign="left">
                            <uix:styledText styleClass="OraDataText" 
                                            textBinding="creationTimeSB@baselineDetailsBean@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="baselineTypeID@baselineDetailsBean@servletRequest">
                      <uix:case name="<%= BaselineConst.BSLN_TYPE_MW %>">
                        <uix:rowLayout >
                          <uix:cellFormat hAlign="right"> 
                            <uix:styledText
                                            styleClass="OraPromptText" 
                                            textBinding="BSLN_AT_ENABLE@DBMsg"/>
                          </uix:cellFormat>
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText styleClass="OraDataText" 
                                            textBinding="ATEnableSB@baselineDetailsBean@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="baselineTypeID@baselineDetailsBean@servletRequest">
                      <uix:case name="<%= BaselineConst.BSLN_TYPE_MW %>">
                        <uix:rowLayout >
                          <uix:cellFormat hAlign="right"> 
                            <uix:styledText
                                            styleClass="OraPromptText" 
                                            textBinding="BSLN_WINDOW_SIZE@DBMsg"/>
                          </uix:cellFormat>
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText styleClass="OraDataText" 
                                           textBinding="MWSize@baselineDetailsBean@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="baselineTypeID@baselineDetailsBean@servletRequest">
                      <uix:case name="<%= BaselineConst.BSLN_TYPE_GENERATED %>">
                        <uix:rowLayout >
                          <uix:cellFormat hAlign="right"> 
                            <uix:styledText
                                            styleClass="OraPromptText" 
                                            textBinding="BSLN_TEMPLATE@DBMsg"/>
                          </uix:cellFormat>
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText styleClass="OraDataText" 
                                            textBinding="template@baselineDetailsBean@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:case>
                    </uix:switcher>
                  </uix:tableLayout>
                </uix:header>
              </uix:cellFormat > 
              <uix:spacer width="20"/>

              <%-- Validity --%>
              <uix:cellFormat vAlign="top"> 
                <uix:header textBinding="BSLN_VALIDITY@DBMsg">
                  <uix:spacer height="5"/>
                  <uix:tableLayout>
                    <uix:rowLayout >
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText
                                        styleClass="OraPromptText" 
                                        textBinding="BSLN_SHUTDOWN@DBMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="shutDown@baselineDetailsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout >
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText
                                        styleClass="OraPromptText" 
                                        textBinding="BSLN_PCT_TOTAL_TIME@DBMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="pctTotalTime@baselineDetailsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout >
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText
                                        styleClass="OraPromptText" 
                                        textBinding="BSLN_ERROR_COUNT@DBMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="errorCount@baselineDetailsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:header>
              </uix:cellFormat > 
              <uix:spacer width="20"/>

              <%-- Time Interval --%>
              <uix:cellFormat vAlign="top"> 
                <uix:header textBinding="BSLN_TIME_INTERVAL@DBMsg">
                  <uix:spacer height="5"/>
                  <uix:tableLayout>
                    <uix:rowLayout >
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText
                                        styleClass="OraPromptText" 
                                        textBinding="BSLN_START_SNAP_TIME@DBMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="startSnapTimeSB@baselineDetailsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout >
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText
                                        styleClass="OraPromptText" 
                                        textBinding="BSLN_END_SNAP_TIME@DBMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="endSnapTimeSB@baselineDetailsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout >
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText
                                        styleClass="OraPromptText" 
                                        textBinding="BSLN_START_SNAP_ID@DBMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="startSnapID@baselineDetailsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout >
                      <uix:cellFormat hAlign="right"> 
                        <uix:styledText
                                        styleClass="OraPromptText" 
                                        textBinding="BSLN_END_SNAP_ID@DBMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="endSnapID@baselineDetailsBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:header>
              </uix:cellFormat > 

            <uix:cellFormat renderedBinding="hasError@baselineDetailsBean@servletRequest">
           
            <%-- Error Table --%>
            <uix:header textBinding="ERROR_DETAILS@DBMsg">
            <uix:spacer height="5"/>
            <uix:tableLayout width="100%" >
              <uix:rowLayout vAlign="top">
		<uix:table 
			blockSize ="5"
			partialRenderMode="self"
			formSubmitted="true"
			valueBinding="startErrorDetails@baselineDetailsBean@servletRequest"
			maxValueBinding="maxErrorDetailsCount@baselineDetailsBean@servletRequest"
			tableDataBinding="errorDetailsTable@baselineDetailsBean@servletRequest">
		    <uix:column>
			<uix:columnFormat columnDataFormat="numberFormat" />
			<uix:columnHeader>
			    <uix:styledText textBinding="SNAP_ID@DBMsg"/>
			</uix:columnHeader>
			<uix:contents>
			     <uix:styledText styleClass="OraText" textBinding="SNAP_ID"/>
			</uix:contents>
		    </uix:column>
		    <uix:column>
			<uix:columnHeader>
			    <uix:styledText textBinding="TABLE_NAME@DBMsg"/>
			</uix:columnHeader>
			<uix:contents>
			     <uix:styledText styleClass="OraText" textBinding="TABLE_NAME"/>
			</uix:contents>
		    </uix:column>
		    <uix:column>
			<uix:columnFormat columnDataFormat="numberFormat" />
			<uix:columnHeader>
			    <uix:styledText textBinding="ERROR_NUMBER@DBMsg"/>
			</uix:columnHeader>
			<uix:contents>
			     <uix:styledText styleClass="OraText" textBinding="ERROR_NUMBER"/>
			</uix:contents>
		    </uix:column>
		</uix:table>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
            </uix:cellFormat>
	    </uix:rowLayout>

            <%-- Statistic Table --%>
            <uix:header textBinding="BSLN_STATISTICS@DBMsg">
            <uix:spacer height="5"/>
            <uix:tableLayout width="100%" renderedBinding="noErrors@baselineDetailsBean@servletRequest">
              <uix:rowLayout vAlign="top">
                <oem:table name="baselineDetailsUIDataSource"
                           partialRenderMode="self"
                           id="baselineDetailsTable"
                           alternateTextBinding="TABLE_NO_DATA@DBMsg" 
                           width="100%"
                           dataSourceProp="baselineDetailsUIDataSource"
                           summaryBinding="header@baselineDetailsBean@servletRequest"
                           beanKey="baselineDetailsBean"
                           formSubmitted="true">
                </oem:table>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
          </uix:subTabLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <%-- Edit Button --%>
              <uix:submitButton textBinding="EDIT@DBObjectMsg" 
                                shortDescBinding="EDIT@DBObjectMsg"
                                name="event" 
                                value="<%= BaselineConst.EDIT %>" />
            
              <%-- OK Button --%>
              <uix:submitButton textBinding="OK@DBObjectMsg" 
                                shortDescBinding="OK@DBObjectMsg"
                                name="event" 
                                value="<%= BaselineConst.CANCEL %>" />
            
                    
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>	
    </uix:body>
  </uix:document>
</uix:renderingContext>

