<%@ include file="/sdk/oemTop.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.instance.baseline.BaselineConst" %>

<%
    response.setHeader("Pragma", "No-cache");
    response.setHeader("Cache-Control", "no-store, no-cache");
%>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsg"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="awrBaselines" method="post" destination="/console/database/instance/awrBaselines"
         copyParams="target,type">
      <uix:pageLayout> 

        <%@ include file="/database/global.jspf" %>

        <%-- Warning/Error display --%>
        <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

        <%--                                                          --%>
        <%-- Support pageMsgBox for any apps that return to this page --%>
        <%-- and support it.  This include must be positioned AFTER   --%>
        <%-- any other uix:messages or messageBox tags.               --%>
        <%--                                                          --%>
        <%@ include file="/sdk/page/pageMsgBox.jspf" %>

        <uix:header textBinding="header@baselinesBean@servletRequest">
    
        <%@ include file="../refreshTime.jspf" %>
        <uix:spacer height="20"/>

              <uix:tableLayout width="100%">
                <uix:rowLayout vAlign="top">
                  <uix:cellFormat hAlign="left">
                    <uix:spacer width="4"/>
                    <uix:styledText labeledNodeId="baselineNameLikeId"
                                    styleClass="OraPromptText" 
                                    textBinding="SEARCH@DBObjectMsg"/>
                    <uix:spacer width="4"/>
                    <uix:textInput name="baselineNameLike" 
                                   id="baselineNameLikeId" 
                                   textBinding="baselineNameLike@baselinesBean@servletRequest"/>
                    <uix:spacer width="8"/> 
                    <uix:submitButton textBinding="GO@DBObjectMsg" 
                                       shortDescBinding="GO@DBObjectMsg"
                                       onFocus="true" selected="true" name="event" value="search"/>

                    <uix:cellFormat hAlign="right">
                      <uix:submitButton textBinding="CREATE@DBObjectMsg" 
                                      shortDescBinding="CREATE@DBObjectMsg" 
                                      name="event" 
                                      value="create"/>
                    </uix:cellFormat>
                  </uix:cellFormat>
                </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:spacer height="8" />
                  </uix:rowLayout>

              <oem:table name="baselinesUIDataSource"
                         id="baselinesTable"
                         alternateTextBinding="NO_AWR_BASELINES_ALT@DBMsg" 
                         width="100%"
                         dataSourceProp="baselinesUIDataSource"
                         beanKey="baselinesBean"
                         formSubmitted="true"
                         summaryBinding="BASELINES_11G@DBMsg" 
                         blockSize="25">

                <uix:tableSelection>
                  <uix:singleSelection shortDescBinding="SELECT@DBObjectMsg"
                                         selectedIndex="0">
                        <uix:submitButton textBinding="EDIT@DBObjectMsg" 
                                          shortDescBinding="EDIT@DBObjectMsg"
                                          name="event" 
                                          value="<%= BaselineConst.EDIT %>"/>
                        <uix:submitButton textBinding="VIEW_BUTTON@DBObjectMsg" 
                                          shortDescBinding="VIEW_BUTTON@DBObjectMsg"
                                          name="event" 
                                          value="<%= BaselineConst.VIEW %>"/>
                        <uix:submitButton textBinding="DELETE@DBObjectMsg" 
                                          shortDescBinding="DELETE@DBObjectMsg"
                                          name="event" 
                                          value="<%= BaselineConst.DELETE %>"/>
                            <uix:flowLayout >
                              <uix:contents>
                                <uix:spacer width="2"/>
                                <uix:styledText styleClass="OraPromptText" textBinding="ACTIONS@DBObjectMsg"/>
                                <uix:spacer width="2"/>
                                <uix:choice name="selectedAction" 
                                            shortDescBinding="ACTIONS@DBObjectMsg" >
                                  <uix:option textBinding="SCHEDULE_STATISTICS_COMPUTATION@DBMsg"
                                              value="SCHEDULE_STATISTICS_COMPUTATION"
                                              renderedBinding="packLicensed@servletRequest"/>
                                  <uix:option textBinding="BASELINE_GO_PERF@DBMsg"
                                              renderedBinding="isNotRac@baselinesBean@servletRequest"
                                              value="BASELINE_GO_PERF"/>
                                  <uix:option textBinding="CREATE_STS@DBMsg"
                                              value="CREATE_STS"/>
                                  <uix:option textBinding="AWR_REPORT@DBMsg"
                                              value="AWR_REPORT" /> 
                                  <uix:option textBinding="CREATE_ADDM_TASK@DBMsg"
                                              value="CREATE_ADDM_TASK" />   
                                  <uix:option textBinding="COMPARE@DBMsg"
                                              value="COMPARE" />
                                </uix:choice>
                                <uix:submitButton textBinding="GO@DBObjectMsg" 
                                                  shortDescBinding="GO@DBObjectMsg"
                                                  name="event" 
                                                  value="chooseAction"/>
                              </uix:contents>
                            </uix:flowLayout>
                        </uix:singleSelection>
                      </uix:tableSelection>
                    </oem:table>

              </uix:tableLayout>

            <oem:relatedLinks/>
          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




