<%@ include file="/sdk/oemTop.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.instance.baseline.BaselineConst" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsg"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    
    <%-- HTML Page Title --%>
  
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="bslnTmpltViewForm"
               method="post"              
               destination="/console/database/instance/awrBslnTmplt"
               copyParams="target,type,oid">
        <uix:pageLayout titleBinding="header@bslnTmpltBean@servletRequest">
        
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>
        
          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- START: View baseline template contents starts here --%>   

            <uix:tableLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_TMPLT_NAME@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="templateName@bslnTmpltBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_TMPLT_ID@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="ID@bslnTmpltBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_TMPLT_TYPE@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="type@bslnTmpltBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_TMPLT_EXPIRED@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="expired@bslnTmpltBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:switcher childNameBinding="type@bslnTmpltBean@servletRequest">
                <uix:case name="<%= BaselineConst.TEMPLATE_TYPE_REPEATING %>">
                  <uix:rowLayout >
                    <uix:cellFormat hAlign="right"> 
                      <uix:styledText
                                      styleClass="OraPromptText" 
                                      textBinding="BSLN_TMPLT_DAY@DBMsg"/>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="day@bslnTmpltBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="type@bslnTmpltBean@servletRequest">
                <uix:case name="<%= BaselineConst.TEMPLATE_TYPE_REPEATING %>">
                  <uix:rowLayout >
                    <uix:cellFormat hAlign="right"> 
                      <uix:styledText
                                      styleClass="OraPromptText" 
                                      textBinding="BSLN_TMPLT_TIME@DBMsg"/>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="hourSB@bslnTmpltBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="type@bslnTmpltBean@servletRequest">
                <uix:case name="<%= BaselineConst.TEMPLATE_TYPE_REPEATING %>">
                  <uix:rowLayout >
                    <uix:cellFormat hAlign="right"> 
                      <uix:styledText
                                      styleClass="OraPromptText" 
                                      textBinding="BSLN_TMPLT_DURATION@DBMsg"/>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="duration@bslnTmpltBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_TMPLT_SGL_START_TIME@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="startTimeSB@bslnTmpltBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout >
                <uix:cellFormat hAlign="right"> 
                  <uix:styledText
                                  styleClass="OraPromptText" 
                                  textBinding="BSLN_TMPLT_SGL_END_TIME@DBMsg"/>
                </uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="endTimeSB@bslnTmpltBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:switcher childNameBinding="type@bslnTmpltBean@servletRequest">
                <uix:case name="<%= BaselineConst.TEMPLATE_TYPE_REPEATING %>">
                  <uix:rowLayout >
                    <uix:cellFormat hAlign="right"> 
                      <uix:styledText
                                      styleClass="OraPromptText" 
                                      textBinding="BSLN_TMPLT_KEEP@DBMsg"/>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" 
                                      textBinding="keep@bslnTmpltBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
            </uix:tableLayout>
 
          <%-- END: View baseline template contents ends here --%>   
                
          <%-- OK Button --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
          
              <%-- OK Button --%>
              <uix:button textBinding="OK@DBObjectMsg" 
                                shortDescBinding="OK@DBObjectMsg"
                                destinationBinding="returnLink@servletRequest"/>
          
            </uix:pageButtonBar>
          </uix:pageButtons>
        
        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
