<%@ include file="/sdk/oemTop.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.instance.baseline.BaselineConst" %>


<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsg"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="awrBslnTmplts" method="post" 
              destination="/console/database/instance/awrBslnTmplts"
              copyParams="target,type">
        <uix:pageLayout> 
  
          <%@ include file="/database/global.jspf" %>
  
          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
  
          <%--                                                          --%>
          <%-- Support pageMsgBox for any apps that return to this page --%>
          <%-- and support it.  This include must be positioned AFTER   --%>
          <%-- any other uix:messages or messageBox tags.               --%>
          <%--                                                          --%>
          <%@ include file="/sdk/page/pageMsgBox.jspf" %>
  
          <uix:header textBinding="header@bslnTmpltsBean@servletRequest">
      
          <%@ include file="../refreshTime.jspf" %>
  
            <uix:rowLayout>
              <uix:contents>
                <uix:styledText styleClass="OraPromptText" 
                                textBinding="BSLN_TMPLTS_DESC@DBMsg"/>
              </uix:contents>
            </uix:rowLayout>
  
            <uix:header textBinding="BSLN_TMPLTS_RPT@DBMsg">
              <uix:tableLayout cellSpacing="5" width = "100%" > 
  
                <uix:rowLayout>
                  <uix:contents>
                    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="BSLN_TMPLTS_RPT_DESC@DBMsg"/>
                  </uix:contents>
                </uix:rowLayout>
  
                <oem:table name="bslnTmpltsRptUIDataSource"
                           id="bslnTmpltsRptTable"
                           alternateTextBinding="NO_AWR_BSLN_TMPLTS_RPT_ALT@DBMsg" 
                           width="100%"
                           dataSourceProp="bslnTmpltsRptUIDataSource"
                           beanKey="bslnTmpltsBean"
                           formSubmitted="true"
                           summaryBinding="BSLNS_TMPLTS_RPT@DBMsg" 
                           blockSize="25">
  
                  <uix:tableSelection>
                    <uix:singleSelection shortDescBinding="SELECT@DBObjectMsg"
                                           selectedIndex="0">
                          <uix:submitButton textBinding="VIEW_BUTTON@DBObjectMsg" 
                                            shortDescBinding="VIEW_BUTTON@DBObjectMsg"
                                            name="event" 
                                            value="<%= BaselineConst.VIEW_RPT %>"/>
                          <uix:submitButton textBinding="DELETE@DBObjectMsg" 
                                            shortDescBinding="DELETE@DBObjectMsg"
                                            name="event" 
                                            value="<%= BaselineConst.DELETE_RPT %>"/>
                    </uix:singleSelection>
                  </uix:tableSelection>
                </oem:table>

              </uix:tableLayout>

            </uix:header>
            <uix:header textBinding="BSLN_TMPLTS_SGL@DBMsg">
              <uix:tableLayout cellSpacing="5" width = "100%" > 
  
                <uix:rowLayout>
                  <uix:contents>
                    <uix:styledText styleClass="OraPromptText" 
                                    textBinding="BSLN_TMPLTS_SGL_DESC@DBMsg"/>
                  </uix:contents>
                </uix:rowLayout>
  
                <oem:table name="bslnTmpltsSglUIDataSource"
                           id="bslnTmpltsSglTable"
                           alternateTextBinding="NO_AWR_BSLN_TMPLTS_SGL_ALT@DBMsg" 
                           width="100%"
                           dataSourceProp="bslnTmpltsSglUIDataSource"
                           beanKey="bslnTmpltsBean"
                           formSubmitted="true"
                           summaryBinding="BSLNS_TMPLTS_SGL@DBMsg" 
                           blockSize="25">
  
                  <uix:tableSelection>
                    <uix:singleSelection shortDescBinding="SELECT@DBObjectMsg"
                                           selectedIndex="0">
                          <uix:submitButton textBinding="VIEW_BUTTON@DBObjectMsg" 
                                            shortDescBinding="VIEW_BUTTON@DBObjectMsg"
                                            name="event" 
                                            value="<%= BaselineConst.VIEW_SGL %>"/>
                          <uix:submitButton textBinding="DELETE@DBObjectMsg" 
                                            shortDescBinding="DELETE@DBObjectMsg"
                                            name="event" 
                                            value="<%= BaselineConst.DELETE_SGL %>"/>
                    </uix:singleSelection>
                  </uix:tableSelection>
                </oem:table>

              </uix:tableLayout>

            </uix:header>
            <oem:relatedLinks/>
          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




