<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.sysman.emo.adm.instance.baseline.BaselineConst" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsg"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <oem:setURLEncoder id="renderingContext"/>  
  <uix:document>
    <uix:metaContainer>      
      <uix:head titleBinding="CONFIRMATION@DBObjectMsg"/>    
    </uix:metaContainer>    
    
    <uix:body>      
      <db:form name="tmpltDelForm" method="post" destination="/console/database/instance/awrBslnTmplts" 
               copyParams="target,type">        
        <uix:formValue name="event"/>
        <uix:formValue name="oid" valueBinding="oid@servletRequest"/>
        <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>        
        
        <uix:pageLayout>                  
          <%@ include file="/database/global.jspf" %>            
          
          <oem:messageBox messageType="error"                   
            errorTableBinding="errors@servletRequest"                  
            titleTextKey="titleText" mainTextKey="mainText"/>          
            
          <uix:header textBinding="CONFIRMATION@DBObjectMsg" icon="/em/images/confirmation.gif">            
            <uix:tableLayout>              
              <uix:rowLayout>              
                <uix:styledText styleClass="OraDataText"                                
                    textBinding="deleteMsg@servletRequest"/>              
              </uix:rowLayout>              
              <uix:rowLayout>                
                <uix:spacer height="10"/>              
              </uix:rowLayout>              
            </uix:tableLayout>          
          </uix:header>          
            
          <uix:pageButtons>            
            <uix:pageButtonBar>              
              <uix:submitButton textBinding="NO@DBObjectMsg"
                    shortDescBinding="NO@DBObjectMsg"
                    name="event" value="<%= BaselineConst.NO_DELETE %>"/>             
              <uix:submitButton textBinding="YES@DBObjectMsg"
                    shortDescBinding="YES@DBObjectMsg"
                    name="event" value="<%= BaselineConst.DO_DELETE %>"/>             
            </uix:pageButtonBar>          
          </uix:pageButtons>        
        </uix:pageLayout>        
      </db:form>                
    </uix:body>  
  </uix:document>
</uix:renderingContext> 
