<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"> 
<oem:setURLEncoder id="renderingContext"/>
  <uix:document> 

    
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="foo" method="POST" destinationBinding="defaultControllerURL@dbChangeStateObject@pageContext" copyParams="target,type">
	<uix:pageLayout>
	  <%@ include file="/database/global.jspf" %>
	  <oem:messageBox messageType="error" 
			  errorTableBinding="errors@servletRequest"
			  titleTextKey="titleText" mainTextKey="mainText"/>
	  
	  <uix:stackLayout>
	    <uix:contents>

	      <uix:formValue name="pageName" value="/database/instance/changeState/changeState"/>
	      <uix:header textBinding="specifyCredentialsHeader@dbChangeStateObject@pageContext">

	        <%-- use bean property instead of 2 switchers --%>
		<uix:styledText styleClass="OraInstructionText" textBinding="specifyCredentialsDescription@dbChangeStateObject@pageContext" />

		<uix:header textBinding="SPECIFY_HOST_CREDENTIALS@ChangeStateMsgBundle@servletRequest" >

		<uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
	         <uix:case name="false">
		  <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_HOST_CREDENTIALS_DESC@ChangeStateMsgBundle@servletRequest" />   
		 </uix:case>
		 <uix:case name="true">
		  <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_HOST_CREDENTIALS_DESC@OsmChangeStateMsgBundle@servletRequest" />   
		 </uix:case>
		</uix:switcher>

		  <uix:spacer height="5"/>

         <%@ include file="/dbhostcreds.jspf" %> 
	 	</uix:header>
			 
		<uix:header textBinding="specifyInstanceCredentialsHeader@dbChangeStateObject@servletRequest" >
		  <uix:stackLayout>

    <uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
     <uix:case name="false">
 		  <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_DB_CREDENTIALS_DESC@ChangeStateMsgBundle@servletRequest" /> 
		 
		 </uix:case>
		 <uix:case name="true">
 		  <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_OSM_CREDENTIALS_DESC@OsmChangeStateMsgBundle@servletRequest" /> 
		 </uix:case>
		</uix:switcher>

		    <uix:styledText textBinding="SPECIFY_DATABASE_CREDENTIALS_OSAUTHENT_HINT@ChangeStateMsgBundle@servletRequest" styleClass="OraInlineInfoText" />
		  </uix:stackLayout>

     		 <uix:labeledFieldLayout labelWidthBinding="credsLabelWidth@credsBean@servletRequest">
 			<uix:contents>
			<uix:messageTextInput name="sid" 
                         promptBinding="DB_SID@ChangeStateMsgBundle@servletRequest"
                         textBinding="sid@dbChangeStateObject@servletRequest" 
                         renderedBinding="isPromptSid@dbChangeStateObject@servletRequest"
			 messageBinding="sidNameError@dbChangeStateObject@servletRequest"
                         messageTypeBinding="sidNameErrorType@dbChangeStateObject@servletRequest"
                         noAutoComplete="true"           
                         columns="40"
                         required="uiOnly" />
			</uix:contents>
			</uix:labeledFieldLayout>   
				
       <%@ include file="/credentials.jspf" %> 

  
		 <%-- use change state object property instead of 2 switchers --%>
		 <uix:messagePrompt messageType="info" promptBinding="sysdbaInstanceCredentialsLabel@dbChangeStateObject@pageContext"/>	

		</uix:header>
	      </uix:header>
	    </uix:contents>              
	  </uix:stackLayout> 

	  <uix:pageButtons>
	    <uix:pageButtonBar>
              <uix:spacer width="10"/>
              <uix:submitButton textBinding="CANCEL@ChangeStateMsgBundle@servletRequest" name="event" value="cancel" />
              <uix:submitButton textBinding="OK@ChangeStateMsgBundle@servletRequest"  name="event" valueBinding="okEventValue@servletRequest" /> 
            </uix:pageButtonBar>
	  </uix:pageButtons>
	</uix:pageLayout>  
      </db:form>
      
    </uix:body>
  </uix:document> 
</uix:renderingContext> 
