<%@ include file="/sdk/oemTop.jspf" %>
 <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="foo" method="POST" destinationBinding="defaultControllerURL@dbChangeStateObject@pageContext" copyParams="target,type">
	
	<uix:pageLayout>
	  <%@ include file="/database/global.jspf" %> 
	  
	  <uix:formValue name="pageName" value="/database/instance/changeState/changeState"/>
	  <oem:messageBox messageType="error" 
			  errorTableBinding="errors@servletRequest"
			  titleTextKey="titleText" mainTextKey="mainText"/>     
	  <uix:header textBinding="specifyOperationHeader@dbChangeStateObject@pageContext">
	    
	    <uix:tableLayout cellSpacing="5">
	      <uix:rowLayout>
                
		<uix:cellFormat>
		  
		  <uix:styledText styleClass="OraPromptText" 
                                  textBinding="currentStateStr@dbChangeStateObject@pageContext"/>
		</uix:cellFormat>
	      </uix:rowLayout>
	      <uix:spacer height="5"/>
	    </uix:tableLayout>
	    <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_OPERATION_DESC@ChangeStateMsgBundle@servletRequest" />
	    
	    <uix:tableLayout cellSpacing="5">

	      <uix:rowLayout>
                <uix:cellFormat hAlign="left">
		  <oem:radioButton name="toState" value="shutdown"
				   selectedValueBinding="toState@dbChangeStateObject@pageContext"
				   textBinding="SHUTDOWN@ChangeStateMsgBundle@servletRequest" 
				   styleClass="OraInstructionText"
				   disabledBinding="shutdownState@dbChangeStateObject@pageContext"/>
                </uix:cellFormat>
	      </uix:rowLayout>
	      
	      <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                  <uix:switcher childNameBinding="openResetlogsRequired@dbChangeStateObject@pageContext">
                    <uix:case name="false">
                      <oem:radioButton name="toState" value="open"
				   selectedValueBinding="toState@dbChangeStateObject@pageContext"
				   textBinding="OPEN@ChangeStateMsgBundle@servletRequest" 
				   styleClass="OraInstructionText" disabledBinding="openState@dbChangeStateObject@pageContext"/>
                    </uix:case>
                    <uix:case name="true">
                      <oem:radioButton name="toState" value="open"
				   selectedValueBinding="toState@dbChangeStateObject@pageContext"
				   textBinding="OPEN_RESETLOGS@ChangeStateMsgBundle@servletRequest" 
				   styleClass="OraInstructionText" disabledBinding="openState@dbChangeStateObject@pageContext"/>
                    </uix:case>
                  </uix:switcher>
                </uix:cellFormat>
	      </uix:rowLayout>
	      <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                  <uix:spacer width="10"/>
                  <uix:switcher childNameBinding="openResetlogsRequired@dbChangeStateObject@pageContext">
                    <uix:case name="false">
                      <uix:styledText styleClass="OraInstructionText" textBinding="OPEN_DESC@ChangeStateMsgBundle@servletRequest" /> 
                    </uix:case>
                    <uix:case name="true">
                      <uix:styledText styleClass="OraInstructionText" textBinding="OPEN_RESETLOGS_DESC@ChangeStateMsgBundle@servletRequest" /> 
                    </uix:case>
                  </uix:switcher>
                </uix:cellFormat>
	      </uix:rowLayout>

	    </uix:tableLayout>
	  </uix:header>

	  <uix:contentFooter>
	    <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@ChangeStateMsgBundle@servletRequest" name="event" value="cancel" />
              <uix:submitButton textBinding="CONTINUE@ChangeStateMsgBundle@servletRequest" name="event" value="specifyOperationOk" />
	      
            </uix:pageButtonBar>
	    
	  </uix:contentFooter>
	</uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext> 

