<%@ include file="/sdk/oemTop.jspf" %>
 <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext" > 
<oem:setURLEncoder id="renderingContext"/>
  <uix:document> 
    <%@ include file="/oemTitle.jspf" %> 
    <uix:body>
      <db:form name="foo" method="POST" destinationBinding="defaultControllerURL@dbChangeStateObject@pageContext" copyParams="target,type">
	<uix:formValue name="pageName" value="/database/instance/changeState/changeState"/>
	<uix:pageLayout>

	  <%@ include file="/database/global.jspf" %>

	  <uix:stackLayout>
	    <uix:contents> 

	      
	      <uix:header textBinding="shutdownOptionsHeader@dbChangeStateObject@pageContext"/> 

	      <uix:switcher childNameBinding="implicitShutdown@dbChangeStateObject@pageContext">
		<uix:case name="false">
		  
		  <uix:styledText styleClass="OraInstructionText" textBinding="SHUTDOWN_MODE_DESC@ChangeStateMsgBundle@servletRequest" />
		</uix:case>
		<uix:case name="true"> 
		  
		  <uix:styledText styleClass="OraInstructionText" textBinding="BOUNCE_DB_SHUTDOWN_MODE_DESC@ChangeStateMsgBundle@servletRequest" />
		</uix:case>
	      </uix:switcher>

	      <uix:tableLayout cellSpacing="5">
		<uix:rowLayout>
		  <uix:cellFormat hAlign="left">
		    <uix:flowLayout>
		    <oem:radioButton name="shutdownMode" value="normal"
					selectedValueBinding="shutdownMode@dbChangeStateObject@pageContext"
					textBinding="SHUTDOWN_NORMAL@ChangeStateMsgBundle@servletRequest" styleClass="OraInstructionText"/>
		    <uix:spacer width="10"/>  

		    <%-- only browse sessions if not osm instance --%>
		    <uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		     <uix:case name="false">	
		      <db:link textBinding="BROWSE_SESSIONS@DBMsgBundle@servletRequest"
                                destinationBinding="browseSessionsUrl@servletRequest" copyParams="target,type"/>  
		     </uix:case>
		     </uix:switcher>
			
		    </uix:flowLayout>
		  </uix:cellFormat>
		</uix:rowLayout>
		<uix:rowLayout>
		  <uix:cellFormat hAlign="left">
		    <uix:spacer width="10"/>

		    <uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		     <uix:case name="false">	
		      <uix:messagePrompt messageType="warning" promptBinding="SHUTDOWN_NORMAL_DESC@ChangeStateMsgBundle@servletRequest" /> 
		     </uix:case>
		     <uix:case name="true">
		      <uix:styledText styleClass="OraInlineInfoText" textBinding="SHUTDOWN_NORMAL_DESC@OsmChangeStateMsgBundle@servletRequest" /> 
		     </uix:case>
		    </uix:switcher>

		  </uix:cellFormat>
		</uix:rowLayout>
		<uix:rowLayout>
		  <uix:cellFormat hAlign="left">
		    <oem:radioButton name="shutdownMode" value="transactional"
					selectedValueBinding="shutdownMode@dbChangeStateObject@pageContext"
					textBinding="SHUTDOWN_TRANSACTIONAL@ChangeStateMsgBundle@servletRequest" styleClass="OraInstructionText"/>
		  </uix:cellFormat>
		</uix:rowLayout>
		<uix:rowLayout>
		  <uix:cellFormat hAlign="left">
		    <uix:spacer width="10"/>

		    <uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		     <uix:case name="false">	
		      <uix:styledText styleClass="OraInstructionText" textBinding="SHUTDOWN_TRANSACTIONAL_DESC@ChangeStateMsgBundle@servletRequest" /> 
		     </uix:case>
		     <uix:case name="true">
		      <uix:styledText styleClass="OraInlineInfoText" textBinding="SHUTDOWN_TRANSACTIONAL_DESC@OsmChangeStateMsgBundle@servletRequest" /> 
		     </uix:case>
		    </uix:switcher>

		  </uix:cellFormat>
		</uix:rowLayout>

		<uix:rowLayout>
		  <uix:cellFormat hAlign="left">
		    <oem:radioButton name="shutdownMode" value="immediate"
					selectedValueBinding="shutdownMode@dbChangeStateObject@pageContext"
					textBinding="SHUTDOWN_IMMEDIATE@ChangeStateMsgBundle@servletRequest" styleClass="OraInstructionText"/>
		  </uix:cellFormat>
		</uix:rowLayout>
		<uix:rowLayout>
		  <uix:cellFormat hAlign="left">
		    <uix:spacer width="10"/>

		    <uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		     <uix:case name="false">	
		      <uix:styledText styleClass="OraInstructionText" textBinding="SHUTDOWN_IMMEDIATE_DESC@ChangeStateMsgBundle@servletRequest" /> 
		     </uix:case>
		     <uix:case name="true">
		      <uix:styledText styleClass="OraInlineInfoText" textBinding="SHUTDOWN_IMMEDIATE_DESC@OsmChangeStateMsgBundle@servletRequest" /> 
		     </uix:case>
		    </uix:switcher>

		  </uix:cellFormat>
		</uix:rowLayout>

		<uix:rowLayout>
		  <uix:cellFormat hAlign="left">
		    <oem:radioButton name="shutdownMode" value="abort"
					selectedValueBinding="shutdownMode@dbChangeStateObject@pageContext"
					textBinding="SHUTDOWN_ABORT@ChangeStateMsgBundle@servletRequest" styleClass="OraInstructionText"/>
		  </uix:cellFormat>
		</uix:rowLayout>
		<uix:rowLayout>
		  <uix:cellFormat hAlign="left">
		    <uix:spacer width="10"/>

		    <uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		     <uix:case name="false">	
		      <uix:styledText styleClass="OraInstructionText" textBinding="SHUTDOWN_ABORT_DESC@ChangeStateMsgBundle@servletRequest" /> 
		     </uix:case>
		     <uix:case name="true">
		      <uix:styledText styleClass="OraInlineInfoText" textBinding="SHUTDOWN_ABORT_DESC@OsmChangeStateMsgBundle@servletRequest" /> 
		     </uix:case>
		    </uix:switcher>

		  </uix:cellFormat>
		</uix:rowLayout>
	      </uix:tableLayout> 

	    </uix:contents>              
	  </uix:stackLayout> 
	  <uix:contentFooter> 
	    <uix:pageButtonBar>

              <uix:submitButton textBinding="CANCEL@ChangeStateMsgBundle@servletRequest" name="event" value="advancedCancelled" />
	      <uix:submitButton textBinding="OK@ChangeStateMsgBundle@servletRequest" name="event" value="operationSpecified" />
	    </uix:pageButtonBar>
	  </uix:contentFooter> 
	
	
	</uix:pageLayout>
      </db:form>
    </uix:body> 
  </uix:document> 
</uix:renderingContext> 
