<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="ChangeStateMsgBundle" class="oracle.sysman.db.rsc.inst.ChangeStateMsg"/>

    <uix:header textBinding="STARTUP_MODE_DESC@ChangeStateMsgBundle">  
      <uix:styledText styleClass="OraInstructionText" textBinding="STARTUP_MODE_DESC@ChangeStateMsgBundle" />
      <uix:tableLayout cellSpacing="5">
	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">

	    <uix:radioButton name="mode" value="start"
			     selectedValueBinding="mode@"
			     textBinding="START@ChangeStateMsgBundle" 
			     styleClass="OraInstructionText" disabledBinding="viewMode@"/>
	  </uix:cellFormat>
	</uix:rowLayout>
	

	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">
	    
	    <uix:radioButton name="mode" value="mount"
			     selectedValueBinding="mode@"
			     textBinding="MOUNT@ChangeStateMsgBundle" 
			     styleClass="OraInstructionText" disabledBinding="viewMode@"/>
	  </uix:cellFormat>
	</uix:rowLayout>


	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">
	    <uix:radioButton name="mode" value="open"
			     selectedValueBinding="mode@"
			     textBinding="OPEN@ChangeStateMsgBundle" 
			     styleClass="OraInstructionText" disabledBinding="viewMode@"/>

	  </uix:cellFormat>
	</uix:rowLayout>
	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">
	    <uix:flowLayout>
	      <uix:spacer width="10"/>

	      <uix:checkBox name="readOnly" textBinding="STARTUP_OPTIONS_READ_ONLY@ChangeStateMsgBundle" value = "true" 
                            selectedValueBinding="readOnly@" disabledBinding="viewMode@"/>
	    </uix:flowLayout>
	  </uix:cellFormat>
	</uix:rowLayout> 	

	
      </uix:tableLayout>
    </uix:header>

    <uix:header textBinding="STARTUP_OPTIONS_INIT_PAPAM_HEADER@ChangeStateMsgBundle" >
      <uix:spacer height="5"/>
      <uix:tableLayout cellSpacing="5">
	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">
	    <uix:radioButton name="useDefaultConfiguration"  value="true"
			     selectedValueBinding="useDefaultConfiguration@"
			     textBinding="STARTUP_OPTIONS_USE_DEFAULT@ChangeStateMsgBundle"  disabledBinding="viewMode@"/>
	  </uix:cellFormat>
	</uix:rowLayout>

	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">
	    <uix:radioButton name="useDefaultConfiguration"  value="false"
			     selectedValueBinding="useDefaultConfiguration@"
			     textBinding="STARTUP_OPTIONS_SPECIFY_PFILE@ChangeStateMsgBundle"   disabledBinding="viewMode@"/>
	  </uix:cellFormat>
	</uix:rowLayout>
	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">
	    <uix:stackLayout>
	      <uix:flowLayout>
		<uix:spacer width="10"/>
		<uix:textInput name="pfile" columns="60"					 
			       textBinding="pfile@" shortDescBinding="STARTUP_OPTIONS_SPECIFY_PFILE@ChangeStateMsgBundle"  disabledBinding="viewMode@"/> 
	      </uix:flowLayout>

	      <uix:styledText textBinding="COMMON_STARTUP_PFILE_TIP@ChangeStateMsgBundle" styleClass="OraInlineInfoText"/>


	    </uix:stackLayout>
	  </uix:cellFormat>
	</uix:rowLayout>
      </uix:tableLayout>
    </uix:header> 
    <uix:header textBinding="STARTUP_OPTIONS_OTHERS@ChangeStateMsgBundle">
      <uix:tableLayout cellSpacing="5">
	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">


	    <uix:checkBox name="restricted" textBinding="STARTUP_OPTIONS_RESTRICT@ChangeStateMsgBundle" value = "true" 
			  selectedValueBinding="restricted@"  disabledBinding="viewMode@"/>

	  </uix:cellFormat>
	</uix:rowLayout>

	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">
	    <uix:spacer width="10"/>

	    <uix:styledText styleClass="OraInstructionText" textBinding="STARTUP_OPTIONS_RESTRICT_DESC@ChangeStateMsgBundle" /> 
	  </uix:cellFormat>
	</uix:rowLayout>

	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">

	    <uix:checkBox name="force" textBinding="STARTUP_OPTIONS_FORCE@ChangeStateMsgBundle" value = "true" 
			  selectedValueBinding="force@"  disabledBinding="viewMode@"/>
	  </uix:cellFormat>
	</uix:rowLayout>
	<uix:rowLayout>
	  <uix:cellFormat hAlign="left">
	    <uix:spacer width="10"/>

	    <uix:messagePrompt messageType="warning" promptBinding="STARTUP_OPTIONS_FORCE_DESC@ChangeStateMsgBundle"/>
	  </uix:cellFormat>
	</uix:rowLayout>
      </uix:tableLayout>
    </uix:header> 
    
  </uix:dataScope>
</oem:pageSegment>
