<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"> 
	<oem:setURLEncoder id="renderingContext"/>	  
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <uix:body> 
      <db:form name="foo" method="POST" destinationBinding="defaultControllerURL@dbChangeStateObject@pageContext" copyParams="target,type">
 <uix:formValue name="pageName" value="/database/instance/changeState/startupPage"/>
	<uix:pageLayout titleBinding="startupOptionsHeader@dbChangeStateObject@pageContext" >
	  <%@ include file="/database/global.jspf" %> 
	  
	  <uix:stackLayout>
	    <uix:contents> 

	     
	      <oem:messageBox messageType="error" 
			      errorTableBinding="errors@servletRequest"
			      titleTextKey="titleText" mainTextKey="mainText"/>  
		<uix:header textBinding="STARTUP_MODE_DESC@ChangeStateMsgBundle@servletRequest">     

 		<uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		 <uix:case name="false">

		  <uix:tableLayout cellSpacing="5">		    
		    <uix:rowLayout>
		      <uix:cellFormat hAlign="left">
			<oem:radioButton name="toState" value="start"
					 selectedValueBinding="toState@dbChangeStateObject@pageContext"
					 textBinding="START@ChangeStateMsgBundle@servletRequest" 
					 styleClass="OraInstructionText" disabledBinding="startedState@dbChangeStateObject@pageContext"/>
		      </uix:cellFormat>
		    </uix:rowLayout>
		    
		    <uix:rowLayout>
		      <uix:cellFormat hAlign="left">
			<oem:radioButton name="toState" value="mount"
					 selectedValueBinding="toState@dbChangeStateObject@pageContext"
					 textBinding="MOUNT@ChangeStateMsgBundle@servletRequest" 
					 styleClass="OraInstructionText" disabledBinding="mountedState@dbChangeStateObject@pageContext"/>
		      </uix:cellFormat>
		    </uix:rowLayout>
		    
		    <uix:rowLayout>
		      <uix:cellFormat hAlign="left">
			<oem:radioButton name="toState" value="open"
					 selectedValueBinding="toState@dbChangeStateObject@pageContext"
					 textBinding="OPEN@ChangeStateMsgBundle@servletRequest" 
					 styleClass="OraInstructionText" disabledBinding="openState@dbChangeStateObject@pageContext"/>
		      </uix:cellFormat>
		    </uix:rowLayout>

		    <uix:rowLayout renderedBinding="isGridControl@servletRequest">
		      <uix:cellFormat hAlign="left">
			<uix:flowLayout>
			  <uix:spacer width="10"/>
			  <uix:checkBox name="readOnly" 
					checkedBinding="readOnly@dbChangeStateObject@pageContext"
					textBinding="STARTUP_OPTIONS_READ_ONLY@ChangeStateMsgBundle@servletRequest" />
			</uix:flowLayout>
		      </uix:cellFormat>
		    </uix:rowLayout>		    
		  </uix:tableLayout>
		 </uix:case>
		</uix:switcher>

		 <%-- osm instance open is not a valid option --%>
 		<uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		 <uix:case name="true">

		  <uix:tableLayout cellSpacing="5">		    
		    <uix:rowLayout>
		      <uix:cellFormat hAlign="left">
			<oem:radioButton name="toState" value="start"
					 selectedValueBinding="toState@dbChangeStateObject@pageContext"
					 textBinding="START@OsmChangeStateMsgBundle@servletRequest" 
					 styleClass="OraInstructionText" disabledBinding="startedState@dbChangeStateObject@pageContext"/>
		      </uix:cellFormat>
		    </uix:rowLayout>
		    
		    <uix:rowLayout>
		      <uix:cellFormat hAlign="left">
			<oem:radioButton name="toState" value="mount"
					 selectedValueBinding="toState@dbChangeStateObject@pageContext"
					 textBinding="MOUNT_DISKGROUP@OsmChangeStateMsgBundle@servletRequest" 
					 styleClass="OraInstructionText" disabledBinding="mountedState@dbChangeStateObject@pageContext"/>
		      </uix:cellFormat>
		    </uix:rowLayout>
		  </uix:tableLayout>
		 </uix:case>
		</uix:switcher>

		</uix:header>

		<uix:header textBinding="STARTUP_OPTIONS_INIT_PAPAM_HEADER@ChangeStateMsgBundle@servletRequest" >
		  <uix:spacer height="5"/>
		  <uix:tableLayout cellSpacing="5">
		    <uix:rowLayout>
		      <uix:cellFormat hAlign="left">
			<uix:radioButton name="useDefaultConfiguration"  value="true"
					 selectedBinding="useDefaultConfiguration@dbChangeStateObject@pageContext"
					 textBinding="STARTUP_OPTIONS_USE_DEFAULT@ChangeStateMsgBundle@servletRequest" />
		      </uix:cellFormat>
		    </uix:rowLayout>

		    <uix:rowLayout>
		      <uix:cellFormat hAlign="left">
			<uix:radioButton name="useDefaultConfiguration"  value="false"
					 selectedBinding="donotUseDefaultConfiguration@dbChangeStateObject@pageContext"
					 textBinding="STARTUP_OPTIONS_SPECIFY_PFILE@ChangeStateMsgBundle@servletRequest"  />
		      </uix:cellFormat>
		    </uix:rowLayout>

		    <uix:cellFormat hAlign="left">
		      <uix:stackLayout>
			<uix:flowLayout>
			  <uix:spacer width="10"/>
			  <uix:textInput name="pfile" columns="60"					 
					 textBinding="pfile@dbChangeStateObject@pageContext" shortDescBinding="STARTUP_OPTIONS_SPECIFY_PFILE@ChangeStateMsgBundle@servletRequest" /> 
			</uix:flowLayout>
			<uix:messageText messageType="error" messageBinding="pfile@errors@servletRequest" />

			<uix:styledText textBinding="STARTUP_PFILE_TIP@ChangeStateMsgBundle@servletRequest" styleClass="OraInlineInfoText"/>

		      </uix:stackLayout>
		    </uix:cellFormat>
		</uix:tableLayout>
	      </uix:header>
	      <uix:header textBinding="STARTUP_OPTIONS_OTHERS@ChangeStateMsgBundle@servletRequest">
		<uix:tableLayout cellSpacing="5">
		  <uix:rowLayout>
		    <uix:cellFormat hAlign="left">

 		    <uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		     <uix:case name="false">
		      <uix:checkBox name="restricted" 
				    checkedBinding="restricted@dbChangeStateObject@pageContext"
				    textBinding="STARTUP_OPTIONS_RESTRICT@ChangeStateMsgBundle@servletRequest" />
		     </uix:case>
		     <uix:case name="true">
		      <uix:checkBox name="restricted" 
				    checkedBinding="restricted@dbChangeStateObject@pageContext"
				    textBinding="STARTUP_OPTIONS_RESTRICT@OsmChangeStateMsgBundle@servletRequest" />
		     </uix:case>
		    </uix:switcher>

		    </uix:cellFormat>
		  </uix:rowLayout>
		  <uix:rowLayout>
		    <uix:cellFormat hAlign="left">
		      <uix:spacer width="10"/>

 		    <uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		     <uix:case name="false">
		      <uix:styledText styleClass="OraInstructionText" textBinding="STARTUP_OPTIONS_RESTRICT_DESC@ChangeStateMsgBundle@servletRequest" /> 
		     </uix:case>
		     <uix:case name="true">
		      <uix:styledText styleClass="OraInstructionText" textBinding="STARTUP_OPTIONS_RESTRICT_DESC@OsmChangeStateMsgBundle@servletRequest" /> 
		     </uix:case>
		    </uix:switcher>

		    </uix:cellFormat>
		  </uix:rowLayout>
		  

		  <uix:rowLayout>
		    <uix:cellFormat hAlign="left">

 		    <uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		     <uix:case name="false">
		      <uix:checkBox name="force" 
				    checkedBinding="force@dbChangeStateObject@pageContext"
				    textBinding="STARTUP_OPTIONS_FORCE@ChangeStateMsgBundle@servletRequest" />
		     </uix:case>
		     <uix:case name="true">
		      <uix:checkBox name="force" 
				    checkedBinding="force@dbChangeStateObject@pageContext"
				    textBinding="STARTUP_OPTIONS_FORCE@OsmChangeStateMsgBundle@servletRequest" />
		     </uix:case>
		    </uix:switcher>

		    </uix:cellFormat>
		  </uix:rowLayout>
		  <uix:rowLayout>
		    <uix:cellFormat hAlign="left">
		      <uix:spacer width="10"/>

 		    <uix:switcher childNameBinding="isOsmInstance@dbChangeStateObject@pageContext">
		     <uix:case name="false">
		      <uix:messagePrompt messageType="warning" promptBinding="STARTUP_OPTIONS_FORCE_DESC@ChangeStateMsgBundle@servletRequest"/>
		     </uix:case>
		     <uix:case name="true">
		      <uix:messagePrompt messageType="warning" promptBinding="STARTUP_OPTIONS_FORCE_DESC@OsmChangeStateMsgBundle@servletRequest"/>
		     </uix:case>
		    </uix:switcher>

		    </uix:cellFormat>
		  </uix:rowLayout>

		</uix:tableLayout>
		<uix:spacer height="10"/>
	      </uix:header> 
	  </uix:contents>              
	</uix:stackLayout> 
	

	  <uix:pageButtons>
	  <uix:pageButtonBar>

	    <uix:submitButton textBinding="CANCEL@ChangeStateMsgBundle@servletRequest" name="event" value="advancedCancelled" />
	    <uix:submitButton textBinding="OK@ChangeStateMsgBundle@servletRequest" name="event" value="operationSpecified" />

	  </uix:pageButtonBar>

	  </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
  </uix:body> 
</uix:document> 
</uix:renderingContext> 
