<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  SM Detail General tab =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
	<%@ include file="/oemTitle.jspf" %>

    <uix:body>
	  <uix:pageLayout>

	    <%@ include file="/database/global.jspf" %>

		<uix:switcher childNameBinding="refreshChoice@servletRequest">
		  <uix:case name="RT_15">
		    <uix:rawText>
			  <meta http-equiv="Refresh" content="15" >
			</uix:rawText>
		  </uix:case>
		</uix:switcher>

		<db:form name="SMGenForm" destinationBinding="consumerDetailsDest@servletRequest" copyParams="target,type">
		  <uix:formValue name="service" valueBinding="service@SMDetailsBean@servletRequest"/>
		  <uix:formValue name="module" valueBinding="module@SMDetailsBean@servletRequest"/>
		  <uix:formValue name="pageNum" value="1"/>

		  <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
						msgBundleBinding="DBMsgBundle"
						titleTextKey="titleText" mainTextKey="mainText"/>
		  <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
						msgBundleBinding="DBMsgBundle"
						titleTextKey="titleText" mainTextKey="mainText"/>

		  <uix:tableLayout width="100%">
		    <uix:rowLayout hAlign="right">
			  <uix:spacer height="10"/>
			</uix:rowLayout>
			<uix:rowLayout hAlign="right">
			  <uix:cellFormat>
			    <uix:styledText labeledNodeId="view_choice" styleClass="OraInstructionText"
					textBinding="VIEW_DATA@DBMsgBundle@servletRequest" />
				<uix:spacer width="5"/>
				<uix:choice name="refreshChoice" id="view_choice" onChange="submitForm('SMGenForm', true, {'event':'changeRefreshChoice'})"
					selectedValueBinding="refreshChoice@SMDetailsBean@servletRequest">
				  <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
						value="RT_15"/>
				  <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
						value="RT_MAN"/>
				</uix:choice>
			  </uix:cellFormat>
			</uix:rowLayout>
			<uix:rowLayout>
			  <uix:stackLayout>
			    <uix:header textBinding="header@SMDetailsBean@servletRequest" >
				  <uix:tableLayout width="100%">
				    <uix:rowLayout hAlign="right">
					  <uix:cellFormat>
					    <uix:switcher childNameBinding="showTime@SMDetailsBean@servletRequest">
						  <uix:case name="true">
						    <uix:rowLayout hAlign="right">
							  <uix:cellFormat>
							    <%@ include file="../../../rac/refreshTime.jspf" %>
							  </uix:cellFormat>
							</uix:rowLayout>
						  </uix:case>
						</uix:switcher>
					  </uix:cellFormat>
					</uix:rowLayout>
					<uix:rowLayout>
					  <uix:spacer height="5"/>
					</uix:rowLayout>
				  </uix:tableLayout>
				  <uix:subTabLayout>
				    <uix:subTabs>
                      <uix:switcher childNameBinding="showActivity@SMDetailsBean@servletRequest">
                        <uix:case name="true">
                          <uix:subTabBar selectedIndex="0">
                            <%@ include file="SMTab10g.jspf" %>
                          </uix:subTabBar>
                        </uix:case>
                        <uix:case name="false">
                          <uix:subTabBar selectedIndex="0">
                            <%@ include file="SMTabPre10g.jspf" %>
                          </uix:subTabBar>
                        </uix:case>
                       </uix:switcher>
					</uix:subTabs>

	<oem:chart titleBinding="TOP_ACTIONS@TopConsumersMsgBundle@servletRequest"
        chartType="pieChart"
        width="200"
        height="150"
        pieValuesInLegend="percent"
        legendPosition="east"
        showSlicePercentLabels="true"
        hideZeroSlices="true"
		legendVisible="external"
        externalLegendOrientation="vertical">
        <oem:boundChartDataSource
            chartDataSourceBinding="pieDataSource@topActionsPie@SMDetailsBean@servletRequest"/>
        <oem:imageMap
                imageMapDataSourceBinding="imageMap@topActionsPie@SMDetailsBean@servletRequest"/>
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabel="Label 2"
            itemColor="blue"
            sourceIndex="1"/>
    </oem:chart>

                <uix:switcher childNameBinding="viewChoice@dataSourceBean@servletRequest">
                  <uix:case name="1">
                    <uix:header textBinding="ACTIVE_SMA@TopConsumersMsgBundle@servletRequest">
					  <uix:tableLayout width="100%">
						<uix:rowLayout>
						  <uix:spacer height="10"/>
						</uix:rowLayout>
						<uix:rowLayout>
						  <uix:cellFormat hAlign="left">
                            <uix:styledText labeledNodeId="view_choice2" styleClass="OraInstructionText"
                                textBinding="VIEW_DETAIL@DBMsgBundle@servletRequest" />
                            <uix:choice name="viewChoice" id="view_choice2" onChange="submitForm('SMGenForm', true, {'event':'changeViewChoice'})"
                                selectedValueBinding="viewChoice@dataSourceBean@servletRequest">
                            <uix:option textBinding="ACTIVE_SMA@TopConsumersMsgBundle@servletRequest"
                                value="1"/>
                            <uix:option textBinding="ENABLED_SMA@TopConsumersMsgBundle@servletRequest"
                                value="2"/>
                            </uix:choice>
						  </uix:cellFormat>
						  <uix:cellFormat hAlign="right">
						  <%--
						    <uix:submitButton textBinding="SQL_TRACE_ADMIN@TopConsumersMsgBundle@servletRequest"
								name="event" value="SQLTraceAdmin"/>
							<uix:submitButton textBinding="STAT_AGGR_ADMIN@TopConsumersMsgBundle@servletRequest"
								name="event" value="statAggrAdmin"/>
								--%>
	        <uix:switcher childNameBinding="isRac@servletRequest">
 		   <uix:case name="false">
							<uix:submitButton textBinding="ADD_ACTION@TopConsumersMsgBundle@servletRequest"
								name="event" value="statAggrAdmin"
					                  renderedBinding="showAddButton@dataSourceBean@servletRequest"/>
		  </uix:case>
		 </uix:switcher>
						  </uix:cellFormat>
						</uix:rowLayout>
					  </uix:tableLayout>
						<uix:rowLayout width="100%">
						  <uix:switcher childNameBinding="node@dataSourceBean@servletRequest">
						    <uix:case name="okNode">
							  <oem:table name="actionsTable" beanKey="dataSourceBean"
									summaryBinding="ACTIVE_SMA@TopConsumersMsgBundle@servletRequest"
									formSubmitted="true"
									dataSourceProp="twoDUIDataSource" width="100%"
									alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
									blockSize="25" partialRenderMode="self">

								<uix:tableSelection>

								  <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectionBinding="selection@dataSourceBean@servletRequest" selectedBinding="selected"
								    disabledBinding="selectionDisabled"
	                                                            renderedBinding="isNonRac@servletRequest">
								  <%--
								    <uix:messagePrompt promptBinding="ACTIONS@TopConsumersMsgBundle@servletRequest"/>
                              <uix:choice name="actionChoice" selectedValueBinding="actionChoice@dataSourceBean@servletRequest">
                                <uix:option textBinding="ENABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
                                    value="enableStatAggr"/>
                                <uix:option textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
                                    value="disableStatAggr"/>
                                <uix:option textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                    value="enableSQLTrace"/>
                                <uix:option textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                    value="disableSQLTrace"/>
                                <uix:option textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
                                    value="viewSQLTraceFile"/>
                              </uix:choice>
									<uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
											name="event" value="changeAction"/>
											--%>
                              <uix:submitButton textBinding="ENABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="enableStatAggr"/>
                              <uix:submitButton textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableStatAggr"/>
                              <uix:submitButton textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="enableSQLTrace"/>
                              <uix:submitButton textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableSQLTrace"/>
                              <uix:submitButton textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="viewSQLTraceFile"/>
								  </uix:multipleSelection>

								</uix:tableSelection>
							  </oem:table>
							</uix:case>
							<uix:case name="emptyNode">
							<%--
							  <uix:styledText textBinding="noData@topSessionsBean@servletRequest"/>
							--%>
							</uix:case>
							<!-- Error message -->
							<uix:case name="errNode">
							  <!-- <include baja:node="errMessage" /> -->
							</uix:case>
						  </uix:switcher>
						</uix:rowLayout>
					</uix:header>
                  </uix:case>
                  <uix:case name="2">
                    <uix:header textBinding="ENABLED_SMA@TopConsumersMsgBundle@servletRequest">
					  <uix:tableLayout width="100%">
						<uix:rowLayout>
						  <uix:spacer height="10"/>
						</uix:rowLayout>
						<uix:rowLayout>
						  <uix:cellFormat hAlign="left">
                            <uix:styledText labeledNodeId="view_choice3" styleClass="OraInstructionText"
                                textBinding="VIEW_DETAIL@DBMsgBundle@servletRequest" />
                            <uix:choice name="viewChoice" id="view_choice3"  onChange="submitForm('SMGenForm', true, {'event':'changeViewChoice'})"
                                selectedValueBinding="viewChoice@dataSourceBean@servletRequest">
                            <uix:option textBinding="ACTIVE_SMA@TopConsumersMsgBundle@servletRequest"
                                value="1"/>
                            <uix:option textBinding="ENABLED_SMA@TopConsumersMsgBundle@servletRequest"
                                value="2"/>
                            </uix:choice>
						  </uix:cellFormat>
						  <uix:cellFormat hAlign="right">
						  <%--
						    <uix:submitButton textBinding="SQL_TRACE_ADMIN@TopConsumersMsgBundle@servletRequest"
								name="event" value="SQLTraceAdmin"/>
							<uix:submitButton textBinding="STAT_AGGR_ADMIN@TopConsumersMsgBundle@servletRequest"
								name="event" value="statAggrAdmin"/>
								--%>
	        <uix:switcher childNameBinding="isRac@servletRequest">
 		   <uix:case name="false">
                    <uix:submitButton textBinding="ADD_ACTION@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="statAggrAdmin"
					                  renderedBinding="showAddButton@dataSourceBean@servletRequest"/>
		  </uix:case>
		 </uix:switcher>
						  </uix:cellFormat>
						</uix:rowLayout>
					  </uix:tableLayout>
						<uix:rowLayout width="100%">
						  <uix:switcher childNameBinding="node@dataSourceBean@servletRequest">
						    <uix:case name="okNode">
							  <oem:table name="actionsTable" beanKey="dataSourceBean"
									summaryBinding="ENABLED_SMA@TopConsumersMsgBundle@servletRequest"
									formSubmitted="true"
									dataSourceProp="twoDUIDataSource" width="100%"
									alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
									blockSize="25" partialRenderMode="self">
								<uix:tableSelection>
								  <uix:multipleSelection selectionBinding="selection@dataSourceBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedBinding="selected"
								    disabledBinding="selectionDisabled"
	                                                            renderedBinding="isNonRac@servletRequest">
								  <%--
								    <uix:messagePrompt promptBinding="ACTIONS@TopConsumersMsgBundle@servletRequest"/>
                              <uix:choice name="actionChoice" selectedValueBinding="actionChoice@dataSourceBean@servletRequest">
                                <uix:option textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                            value="enableSQLTrace"/>
                                <uix:option textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                            value="disableSQLTrace"/>
                                <uix:option textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
                                            value="viewSQLTraceFile"/>
                                <uix:option textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
                                            value="disableStatAggr"/>
                              </uix:choice>
									<uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
											name="event" value="changeAction"/>
											--%>
                              <uix:submitButton textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="enableSQLTrace"/>
                              <uix:submitButton textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableSQLTrace"/>
                              <uix:submitButton textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="viewSQLTraceFile"/>
                              <uix:submitButton textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableStatAggr"/>
								  </uix:multipleSelection>
								</uix:tableSelection>
							  </oem:table>
							</uix:case>
							<%--
							<uix:case name="emptyNode">
							  <uix:styledText textBinding="noData@topSessionsBean@servletRequest"/>
							</uix:case>
							--%>
							<!-- Error message -->
							  <!-- <include baja:node="errMessage" /> -->
						  </uix:switcher>
						</uix:rowLayout>
					</uix:header>
                  </uix:case>
                </uix:switcher>
					<uix:spacer height="10"/>
				  </uix:subTabLayout>
				</uix:header>
			  </uix:stackLayout>
			</uix:rowLayout>
		  </uix:tableLayout>
		</db:form>
	  </uix:pageLayout>
	</uix:body>
  </uix:document>
</uix:renderingContext>
