<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Aggregation Enable Actions Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:document>

  <%@ include file="/enablePPR.jspf" %>
  <%@ include file="/oemTitle.jspf" %>

  <uix:body>

    <db:form name="aggrEnableAForm" destinationBinding="actionDest@servletRequest" copyParams="target,type">
      <uix:formValue name="refreshChoice" valueBinding="refreshChoice@ActionAdminBean@servletRequest"/>
      <uix:formValue name="source" valueBinding="source@ActionAdminBean@servletRequest"/>
      <uix:formValue name="service" valueBinding="service@ActionAdminBean@servletRequest"/>
      <uix:formValue name="module" valueBinding="module@ActionAdminBean@servletRequest"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        msgBundleBinding="DBMsgBundle"
                        titleTextKey="titleText"
                        mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        msgBundleBinding="DBMsgBundle"
                        titleTextKey="titleText"
                        mainTextKey="mainText"/>

        <uix:tableLayout width="100%">
          <uix:rowLayout>
            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:header textBinding="header@ActionAdminBean@servletRequest" >
                <uix:rowLayout hAlign="right">
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@DBObjectMsgBundle@servletRequest"
                                name="event" value="cancel"/>
                    <uix:submitButton textBinding="OK@DBObjectMsgBundle@servletRequest"
                                name="event" value="ok"/>
                  </uix:pageButtonBar>
                </uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="ADD_ACTION_TEXT@TopConsumersMsgBundle@servletRequest" />
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="left">
		            <uix:cellFormat>
		              <uix:labeledFieldLayout labelWidth="5%">
		     	      <uix:styledText styleClass="OraPromptText"
			                textBinding="SERVICE@TopConsumersMsgBundle@servletRequest"/>
		      	      <uix:styledText styleClass="OraDataText"
			                textBinding="service@ActionAdminBean@servletRequest"/>
			                </uix:labeledFieldLayout>
		            </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="left">
		            <uix:cellFormat>
		              <uix:labeledFieldLayout labelWidth="5%">
		     	      <uix:styledText styleClass="OraPromptText"
			                textBinding="MODULE@TopConsumersMsgBundle@servletRequest"/>
		      	      <uix:styledText styleClass="OraDataText"
			                textBinding="module@ActionAdminBean@servletRequest"/>
			                </uix:labeledFieldLayout>
		            </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>
                  <uix:rowLayout width="100%">
                    <oem:table name="twoDUIDataSource"
				summaryBinding="header@ActionAdminBean@servletRequest"
                                beanKey="dataSourceBean"
                                formSubmitted="true"
                                dataSourceProp="twoDUIDataSource"
                                width="100%"
                                alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
                                showAll="yes" 
                                blockSize="25"
                                partialRenderMode="self">
                       <uix:tableSelection>
                         <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                              selectedIndexBinding="selectedIndex@ActionAdminBean@servletRequest">
                           <uix:submitButton textBinding="DELETE@DBObjectMsgBundle@servletRequest"
                                            name="event" value="remove"/>
                         </uix:singleSelection>
                       </uix:tableSelection>
                     </oem:table>
                   </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="left">
                    <uix:submitButton textBinding="ADD_ANOTHER_ROW@TopConsumersMsgBundle@servletRequest"
                                        name="event" value="add"/>
                  </uix:rowLayout>
                 </uix:tableLayout>
                 <uix:spacer height="10"/>
               </uix:header>
               <%--
               </uix:subTabLayout>
               --%>
             </uix:stackLayout>
           </uix:rowLayout>
         </uix:tableLayout>

         <uix:pageButtons>
           <uix:pageButtonBar>
             <uix:submitButton textBinding="CANCEL@DBObjectMsgBundle@servletRequest"
                                name="event" value="cancel"/>
             <uix:submitButton textBinding="OK@DBObjectMsgBundle@servletRequest"
                                name="event" value="ok"/>
           </uix:pageButtonBar>
         </uix:pageButtons>

       </uix:pageLayout>
     </db:form>
   </uix:body>
 </uix:document>

 </uix:renderingContext>
