<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Aggregation Enable client Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:document>

  <%@ include file="/enablePPR.jspf" %>
  <%@ include file="/oemTitle.jspf" %>

  <uix:body>

    <db:form name="aggrEnableMForm" destinationBinding="clientDest@servletRequest" copyParams="target,type">
      <uix:formValue name="refreshChoice" valueBinding="refreshChoice@clientAdminBean@servletRequest"/>
      <uix:formValue name="source" valueBinding="source@clientAdminBean@servletRequest"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        msgBundleBinding="DBMsgBundle"
                        titleTextKey="titleText"
                        mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        msgBundleBinding="DBMsgBundle"
                        titleTextKey="titleText"
                        mainTextKey="mainText"/>

        <uix:tableLayout width="100%">
          <uix:rowLayout>
            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:header textBinding="header@clientAdminBean@servletRequest" >
                  <uix:rowLayout hAlign="right">
           <uix:pageButtonBar>
             <uix:submitButton textBinding="CANCEL@DBObjectMsgBundle@servletRequest"
                                name="event" value="cancel"/>
             <uix:submitButton textBinding="OK@DBObjectMsgBundle@servletRequest"
                                name="event" value="ok"/>
           </uix:pageButtonBar>
                  </uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="ADD_CLIENT_TEXT@TopConsumersMsgBundle@servletRequest" />
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>
                  <uix:rowLayout width="100%">
                    <oem:table name="twoDUIDataSource"
				summaryBinding="header@clientAdminBean@servletRequest"
                                beanKey="dataSourceBean"
                                formSubmitted="true"
                                dataSourceProp="twoDUIDataSource"
                                width="100%"
                                alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
                                blockSize="25"
                                partialRenderMode="self">
                       <uix:tableSelection>
                         <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                             selectedIndexBinding="selectedIndex@clientAdminBean@servletRequest">
                           <uix:submitButton textBinding="DELETE@DBObjectMsgBundle@servletRequest"
                                            name="event" value="remove"/>
                         </uix:singleSelection>
                       </uix:tableSelection>
                     </oem:table>
                   </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="left">
                    <uix:submitButton textBinding="ADD_ANOTHER_ROW@TopConsumersMsgBundle@servletRequest"
                                        name="event" value="add"/>
                  </uix:rowLayout>
                 </uix:tableLayout>
                 <uix:spacer height="10"/>
               </uix:header>
               <%--
               </uix:subTabLayout>
               --%>
             </uix:stackLayout>
           </uix:rowLayout>
         </uix:tableLayout>

         <uix:pageButtons>
           <uix:pageButtonBar>
             <uix:submitButton textBinding="CANCEL@DBObjectMsgBundle@servletRequest"
                                name="event" value="cancel"/>
             <uix:submitButton textBinding="OK@DBObjectMsgBundle@servletRequest"
                                name="event" value="ok"/>
           </uix:pageButtonBar>
         </uix:pageButtons>

       </uix:pageLayout>
     </db:form>
   </uix:body>
 </uix:document>

 </uix:renderingContext>
