<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Client Detail Statistics tab =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
	<%@ include file="/oemTitle.jspf" %>

	<uix:body>
	  <uix:pageLayout>
	    <%@ include file="/database/global.jspf" %>

		<uix:switcher childNameBinding="refreshChoice@servletRequest">
		  <uix:case name="RT_15">
		    <uix:rawText>
			  <meta http-equiv="Refresh" content="15" >
			</uix:rawText>
		  </uix:case>
		</uix:switcher>

		<db:form name="ClientStatForm" destinationBinding="consumerDetailsDest@servletRequest" copyParams="target,type">
		  <uix:formValue name="client" valueBinding="client@ClientDetailsBean@servletRequest"/>

		  <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
				msgBundleBinding="DBMsgBundle"
				titleTextKey="titleText" mainTextKey="mainText"/>
		  <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
				msgBundleBinding="DBMsgBundle"
				titleTextKey="titleText" mainTextKey="mainText"/>

		  <uix:tableLayout width="100%">
		    <uix:rowLayout hAlign="right">
			  <uix:spacer height="10"/>
			</uix:rowLayout>
			<uix:rowLayout hAlign="right">
			  <uix:cellFormat>
			    <uix:styledText labeledNodeId="view_choice" styleClass="OraInstructionText"
					textBinding="VIEW_DATA@DBMsgBundle@servletRequest" />
				<uix:spacer width="5"/>
				<uix:choice name="refreshChoice" id="view_choice" onChange="submitForm('ClientStatForm', true, {'event':'changeRefreshChoice'})"
					selectedValueBinding="refreshChoice@ClientDetailsBean@servletRequest">
				  <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
						value="RT_15"/>
				  <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
						value="RT_MAN" />
				</uix:choice>
			  </uix:cellFormat>
			</uix:rowLayout>
			<uix:rowLayout>
			  <uix:stackLayout>
			    <uix:header textBinding="header@ClientDetailsBean@servletRequest" >
				  <uix:tableLayout width="100%">
				    <uix:rowLayout hAlign="right">
					  <uix:cellFormat>
					    <uix:switcher childNameBinding="showTime@ClientDetailsBean@servletRequest">
						  <uix:case name="true">
						    <uix:rowLayout hAlign="right">
							  <uix:cellFormat>
							    <%@ include file="../../../rac/refreshTime.jspf" %>
							  </uix:cellFormat>
							</uix:rowLayout>
						  </uix:case>
						</uix:switcher>
					  </uix:cellFormat>
					</uix:rowLayout>
				  </uix:tableLayout>
			    <uix:header textBinding="ALL_SESS_LINK@DBMsgBundle@servletRequest">
				  <uix:tableLayout width="100%">
					<uix:rowLayout width="100%">
					  <uix:switcher childNameBinding="node@ClientDetailsBean@servletRequest">
					    <uix:case name="okNode">
						  <oem:table name="statisticsTable" beanKey="dataSourceBean"
								summaryBinding="ALL_SESS_LINK@DBMsgBundle@servletRequest"
								formSubmitted="true"
								dataSourceProp="twoDUIDataSource" width="100%"
								alternateTextBinding="STAT_UNAVAILABLE_CLIENT@TopConsumersMsgBundle@servletRequest"
                                                                showAll="yes" 
								blockSize="25" partialRenderMode="self">
						  </oem:table>
						</uix:case>
						<%--
						<uix:case name="emptyNode">
						  <uix:styledText textBinding="noData@topSessionsBean@servletRequest"/>
						</uix:case>
						--%>
						<!-- Error message -->
						<uix:case name="errNode">
						  <!-- <include baja:node="errMessage" /> -->
						</uix:case>
					  </uix:switcher>
					</uix:rowLayout>
				  </uix:tableLayout>
				  </uix:header>
				</uix:header>
			  </uix:stackLayout>
			</uix:rowLayout>
		  </uix:tableLayout>
		</db:form>
	  </uix:pageLayout>
	</uix:body>
  </uix:document>
</uix:renderingContext>
