<%@ include file="/sdk/oemTop.jspf" %>
<!-- ===============  Aggregation Admin Page: All consumers ============== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:document>

  <%@ include file="/enablePPR.jspf" %>
  <%@ include file="/oemTitle.jspf" %>

  <uix:body>


    <db:form name="aggrEnableForm" destinationBinding="generalDest@servletRequest" copyParams="target,type,pageKey">
      <uix:formValue name="refreshChoice" valueBinding="refreshChoice@generalAdminBean@servletRequest"/>
      <uix:formValue name="source" valueBinding="source@generalAdminBean@servletRequest"/>
      <uix:formValue name="service" valueBinding="service@generalAdminBean@servletRequest"/>
      <uix:formValue name="module" valueBinding="module@generalAdminBean@servletRequest"/>

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        msgBundleBinding="DBMsgBundle"
                        titleTextKey="titleText"
                        mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        msgBundleBinding="DBMsgBundle"
                        titleTextKey="titleText"
                        mainTextKey="mainText"/>


        <uix:tableLayout width="100%">
          <uix:rowLayout>
            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:header textBinding="header@generalAdminBean@servletRequest" >

		  <uix:styledText styleClass="OraInstructionText" textBinding="pageDescText@generalAdminBean@servletRequest" />

                <uix:tableLayout width="100%">
		  <!-- service name/value pair -->
	          <uix:switcher childNameBinding="showServiceNV@servletRequest">
                  <uix:case name="true">
                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="left">
		            <uix:cellFormat>
		     	      <uix:styledText styleClass="OraPromptText"
			                textBinding="SERVICE@TopConsumersMsgBundle@servletRequest"/>
                  <uix:spacer width="3"/>
		      	      <uix:styledText styleClass="OraDataText"
			                textBinding="service@generalAdminBean@servletRequest"/>
		            </uix:cellFormat>
                  </uix:rowLayout>
		  </uix:case>
		  </uix:switcher>

		  <!-- module name/value pair -->
	          <uix:switcher childNameBinding="showModuleNV@servletRequest">
                  <uix:case name="true">
                  <uix:rowLayout hAlign="left">
		            <uix:cellFormat>
		              <uix:labeledFieldLayout labelWidth="5%">
		     	      <uix:styledText styleClass="OraPromptText"
			                textBinding="MODULE@TopConsumersMsgBundle@servletRequest"/>
		      	      <uix:styledText styleClass="OraDataText"
			                textBinding="module@generalAdminBean@servletRequest"/>
			                </uix:labeledFieldLayout>
		            </uix:cellFormat>
                  </uix:rowLayout>
		  </uix:case>
		  </uix:switcher>

                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>

		  <!-- consumer enable table -->
                  <uix:rowLayout width="100%">
                    <oem:table name="twoDUIDataSource"
				summaryBinding="header@generalAdminBean@servletRequest"
                                beanKey="dataSourceBean"
                                formSubmitted="true"
                                dataSourceProp="twoDUIDataSource"
                                width="100%"
                                alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
                                blockSize="25"
                                partialRenderMode="self">
                       <uix:tableSelection>
                         <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                              selectedIndexBinding="selectedIndex@generalAdminBean@servletRequest">
                           <uix:submitButton textBinding="DELETE@DBObjectMsgBundle@servletRequest"
                                            name="event" value="remove"/>
                         </uix:singleSelection>
                       </uix:tableSelection>
                     </oem:table>

                   </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>

                  <uix:rowLayout hAlign="left">
                    <uix:submitButton textBinding="ADD_ANOTHER_ROW@TopConsumersMsgBundle@servletRequest" name="event" value="add"/>
                  </uix:rowLayout>
                 </uix:tableLayout>
                 <uix:spacer height="10"/>
               </uix:header>
             </uix:stackLayout>
           </uix:rowLayout>
         </uix:tableLayout>

         <uix:pageButtons>
           <uix:pageButtonBar>
             <uix:submitButton textBinding="CANCEL@DBObjectMsgBundle@servletRequest"
                                name="event" value="cancel"/>
             <uix:submitButton textBinding="OK@DBObjectMsgBundle@servletRequest"
                                name="event" value="ok"/>
           </uix:pageButtonBar>
         </uix:pageButtons>

       </uix:pageLayout>
     </db:form>
   </uix:body>
 </uix:document>

 </uix:renderingContext>