<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Top Consumers Overview Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

      <uix:switcher childNameBinding="refreshChoice@servletRequest">
        <uix:case name="RT_15">
          <uix:rawText>
            <meta http-equiv="Refresh" content="15" >
          </uix:rawText>
        </uix:case>
      </uix:switcher>

      <db:form name="overviewForm" destinationBinding="overviewDest@servletRequest" copyParams="target,type">

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout width="100%">
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:styledText
                            labeledNodeId="refresh_time"
                            styleClass="OraInstructionText"
                            textBinding="VIEW_DATA@DBMsgBundle@servletRequest" />
              <uix:spacer width="5"/>
              <uix:choice name="refreshChoice" id="refresh_time" onChange="submitForm('overviewForm', true, {'event':'changeRefreshChoice'})"
                selectedValueBinding="refreshChoice@overviewBean@servletRequest">
                <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                        value="RT_15"/>
                <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                        value="RT_MAN"/>
              </uix:choice>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:stackLayout>
            </uix:stackLayout>
          </uix:rowLayout>
        </uix:tableLayout>

              <uix:header textBinding="TOP_CONSUMERS@DBMsgBundle@servletRequest" >

              <%@ include file="/database/instances.jspf" %>

                <uix:tableLayout width="100%">

                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat>
                      <uix:switcher childNameBinding="showTime@overviewBean@servletRequest">
                        <uix:case name="true">
                          <uix:rowLayout hAlign="right">
                            <uix:cellFormat>
                              <%@ include file="../../../rac/refreshTime.jspf" %>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>


             <uix:subTabLayout>
                  <uix:subTabs>
                    <uix:subTabBar selectedIndex="0">
                      <uix:link textBinding="OVERVIEW@DBMsgBundle@servletRequest"
                        destinationBinding="overviewDest@servletRequest"/>
                      <uix:link textBinding="TOP_SERVICES@DBMsgBundle@servletRequest"
                        destinationBinding="topServicesDest@servletRequest"/>
                      <uix:link textBinding="TOP_SM@DBMsgBundle@servletRequest"
                        destinationBinding="topSMDest@servletRequest"/>
                      <uix:link textBinding="TOP_SMA@DBMsgBundle@servletRequest"
                        destinationBinding="topSMADest@servletRequest"/>
                      <uix:link textBinding="TOP_CLIENTS@DBMsgBundle@servletRequest"
                        destinationBinding="topClientsDest@servletRequest"/>
                      <uix:link textBinding="TOP_SESSIONS_HEADER@DBMsgBundle@servletRequest"
                        destinationBinding="topSessionsDest@servletRequest"/>
                    </uix:subTabBar>
                  </uix:subTabs>

                <uix:tableLayout width="100%">
		  <uix:rowLayout hAlign="left">
 		    <uix:messagePrompt promptBinding="TC_DATA@DBMsgBundle@servletRequest"/>
		  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat vAlign="top" hAlign="left">
    <oem:chart titleBinding="TOP_SERVICES@DBMsgBundle@servletRequest"
        chartType="pieChart"
        width="300"
        height="150"
        pieValuesInLegend="percent"
        legendPosition="south"
        showSlicePercentLabels="true"
        hideZeroSlices="true"
        legendVisible="external"
        externalLegendOrientation="vertical">
        <oem:boundChartDataSource
            chartDataSourceBinding="pieDataSource@topServicesPie@overviewBean@servletRequest"/>
        <oem:imageMap
                imageMapDataSourceBinding="imageMap@topServicesPie@overviewBean@servletRequest"/>
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabel="Label 2"
            itemColor="blue"
            sourceIndex="1"/>
    </oem:chart>
    </uix:cellFormat>
                    <uix:cellFormat vAlign="top" hAlign="left">
    <oem:chart titleBinding="TOP_MODULES_BY_SERVICE@TopConsumersMsgBundle@servletRequest"
        chartType="pieChart"
        width="300"
        height="150"
        pieValuesInLegend="percent"
        legendPosition="south"
        showSlicePercentLabels="true"
        hideZeroSlices="true"
        legendVisible="external"
        externalLegendOrientation="vertical">
        <oem:boundChartDataSource
            chartDataSourceBinding="pieDataSource@topSMPie@overviewBean@servletRequest"/>
        <oem:imageMap
                imageMapDataSourceBinding="imageMap@topSMPie@overviewBean@servletRequest"/>
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabel="Label 2"
            itemColor="blue"
            sourceIndex="1"/>
    </oem:chart>
    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                  <uix:cellFormat vAlign="top" hAlign="left">
   <oem:chart titleBinding="TOP_CLIENTS@DBMsgBundle@servletRequest"
        chartType="pieChart"
        width="300"
        height="150"
        pieValuesInLegend="percent"
        legendPosition="south"
        showSlicePercentLabels="true"
        hideZeroSlices="true"
        legendVisible="external"
        externalLegendOrientation="vertical">
        <oem:boundChartDataSource
            chartDataSourceBinding="pieDataSource@topClientsPie@overviewBean@servletRequest"/>
        <oem:imageMap
                imageMapDataSourceBinding="imageMap@topClientsPie@overviewBean@servletRequest"/>
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabel="Label 2"
            itemColor="blue"
            sourceIndex="1"/>
    </oem:chart>
   </uix:cellFormat>
                  <uix:cellFormat vAlign="top" hAlign="left">
   <oem:chart titleBinding="TOP_ACTIONS_BY_MODULE_BY_SERVICE@TopConsumersMsgBundle@servletRequest"
        chartType="pieChart"
        width="300"
        height="150"
        pieValuesInLegend="percent"
        legendPosition="south"
        showSlicePercentLabels="true"
        hideZeroSlices="true"
        legendVisible="external"
        externalLegendOrientation="vertical">
        <oem:boundChartDataSource
            chartDataSourceBinding="pieDataSource@topSMAPie@overviewBean@servletRequest"/>
        <oem:imageMap
                imageMapDataSourceBinding="imageMap@topSMAPie@overviewBean@servletRequest"/>
        <oem:chartColumn isKey="true"
            displayLabel="Label 1"
            sourceIndex="0" />
        <oem:chartColumn displayLabel="Label 2"
            itemColor="blue"
            sourceIndex="1"/>
    </oem:chart>
   </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
                  <uix:spacer height="10"/>
                </uix:subTabLayout>
              </uix:header>

         <uix:spacer height="15" />

         <%@ include file="/database/instance/monitoringLinks.jspf" %>

       </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
