<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Service Detail General tab =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:styleSheet/>
<script>

 function scroll_timechart(direction)
 {
   if (direction == 'prev'){
     document.servActForm.direction.value = '1';
   }
   else{
     document.servActForm.direction.value = '2';
   }
   submitForm('servActForm', true, {'event':'scrollChart'});
 }

  function my_goto_band(selIdx, startMS, endMS)
  {
    submitForm('servActForm', true, {'event':'moveSlider','leftEdge':startMS,'rightEdge':endMS,'selectedBand':selIdx});
  }  

  
 function sliderOffLeft(param)
 {
   location.href = param;
 }
  
</script>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsg"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsg"  class="oracle.sysman.db.rsc.inst.DBMsg"/>

        <%-- check to see if auto-refresh needs to be set --%>
        <uix:switcher childNameBinding="autoRefresh@servletRequest">
          <uix:case name="true">
            <uix:rawText rendered="true">
             <meta http-equiv="Cache-Control" content="max-age=0" >
              <meta http-equiv="Refresh" content="15" >
            </uix:rawText>
          </uix:case>
        </uix:switcher>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

      <db:form name="servActForm" destinationBinding="consumerDetailsDest@servletRequest" copyParams="target,type">
      <uix:formValue name="service" valueBinding="service@serviceActivityBean@servletRequest"/>
      <uix:formValue name="pageNum" value="2"/>
      <uix:formValue name="leftEdge" valueBinding="leftEdge@servletRequest" />
      <uix:formValue name="rightEdge"  valueBinding="rightEdge@servletRequest"/>
      <uix:formValue name="event" />
      <uix:formValue name="direction" value=""/>
      <uix:formValue name="selectedBand" value=""/>

        <uix:messageBox messageTypeBinding="exceptionType@errors@waitAreaChart@serviceActivityBean@servletRequest"
          messageBinding="exceptionText@errors@waitAreaChart@serviceActivityBean@servletRequest"
          renderedBinding="showErrors@waitAreaChart@serviceActivityBean@servletRequest" />

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
		                msgBundleBinding="DBMsgBundle"
						titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
		                msgBundleBinding="DBMsgBundle"
						titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">
            <uix:spacer height="10"/>
          </uix:rowLayout>
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:styledText labeledNodeId="view_choice" styleClass="OraInstructionText"
			                  textBinding="VIEW_DATA@DBMsgBundle@servletRequest" />
              <uix:spacer width="5"/>
              <uix:choice name="refreshChoice" id="view_choice" onChange="submitForm('servActForm', true, {'event':'changeRefreshChoice'})"
			              selectedValueBinding="refreshChoice@serviceDetailsBean@servletRequest">
                <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
				            value="RT_15"/>
                <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
				            value="RT_MAN"/>
                <uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                                            value="HIST_CUST"/>                               </uix:choice>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:stackLayout>
                  <uix:header textBinding="header@serviceDetailsBean@servletRequest" >
                <%@ include file="srvActRefreshTime.jspf" %>
                <uix:subTabLayout>
                  <uix:subTabs>
                            <uix:subTabBar selectedIndex="1">
                              <%@ include file="serviceTab10g.jspf" %>
                            </uix:subTabBar>
                  </uix:subTabs>



            <uix:switcher childNameBinding="useSVG@serviceActivityBean@servletRequest">
            <uix:case name="true">
	     <uix:switcher childNameBinding="showChart@serviceActivityBean@servletRequest">	
              <uix:case name="true">
              <uix:tableLayout>
                <uix:rowLayout hAlign="left">
                  <uix:messagePrompt promptBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest" />
		  <%@ include file ="srvActClassDropdown.jspf" %>
                </uix:rowLayout>
              </uix:tableLayout>
	      </uix:case>
              <uix:case name="false">
              <uix:tableLayout>
                <uix:rowLayout>
                  <%@ include file ="srvActClassDropdown.jspf" %>
                </uix:rowLayout>
              </uix:tableLayout>
              </uix:case>
	     </uix:switcher> 
            </uix:case>
            <uix:case name="false">
             <uix:switcher childNameBinding="showChart@serviceActivityBean@servletRequest">
              <uix:case name="true">
              <uix:tableLayout>
                <uix:rowLayout hAlign="left">
                  <uix:messagePrompt promptBinding="WAIT_DETAIL_GIF_TIP@DBMsgBundle@servletRequest" />
                  <%@ include file ="srvActClassDropdown.jspf" %>
                </uix:rowLayout>
              </uix:tableLayout>
              </uix:case>
              <uix:case name="false">
              <uix:tableLayout>
                <uix:rowLayout>
                  <%@ include file ="srvActClassDropdown.jspf" %>
                </uix:rowLayout>
              </uix:tableLayout>
              </uix:case>
             </uix:switcher>

            </uix:case>
            </uix:switcher>
                        
            <%-- Stacked area chart showing average sessions waiting --%>
          <uix:switcher childNameBinding="showChart@serviceActivityBean@servletRequest">
          <uix:case name="true">
            <uix:switcher childNameBinding="useSVG@serviceActivityBean@servletRequest">
            <uix:case name="true">
             <db:flexRegion
              swfName="/database/flex/serviceDetails.swf"
              dataSrcKeyBinding="flexKey@servletRequest" 
              windowHeight="250"  
              windowWidth="100%"
              idBase="flexServiceDetailsChart"
              />
            </uix:case>   
            <uix:case name="false" >
              <oem:chart 
                chartType="timeSeriesChart"
                width="900"
                height="225"
                timeGranularity="SECOND" 
                orientation="vertical"
                fill="cumulative"  
                yAxisLabelBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"  
                legendPosition="east"
                legendVisible="true"
                titleBinding="ACTIVE_SESSIONS@DBMsgBundle@servletRequest"
                titleVisible="false"
                seriesColorsAutomatic="true"
                format="svg"
                svgUpdateFrequencyBinding="svgUpdateRate@servletRequest"
                xAxisMinBinding="beginDate@waitAreaChart@serviceActivityBean@servletRequest"
                xAxisMaxBinding="endDate@waitAreaChart@serviceActivityBean@servletRequest"
                yAxisNumberFormatBinding="waitChartYAxisFormat@servletRequest"
                axisMin="0"
                axisMaxBinding="actualMaxValue@waitAreaChart@serviceActivityBean@servletRequest"
                svgHighlightLegend="true"
                svgTimebandTipBinding="WAIT_DETAIL_SELECTOR_TIP@DBMsgBundle@servletRequest"
                colorPaletteBinding="waitColorsTable@waitAreaChart@serviceActivityBean@servletRequest"
              >
              <uix:contents>
                <oem:timeSelector
                  xAxisMinBinding="beginDate@waitAreaChart@serviceActivityBean@servletRequest"
                  xAxisMaxBinding="endDate@waitAreaChart@serviceActivityBean@servletRequest"
                  intervalTimeSecBinding="intervalTimeSec@servletRequest"
                  height="20"
                  selectedMaxDateBinding="selectedMaxDate@activityDetailsChart@serviceActivityBean@servletRequest"
                  selectedMinDateBinding="selectedMinDate@activityDetailsChart@serviceActivityBean@servletRequest"

                  numBandsSelectedBinding="numBandsSelected@servletRequest"
                  selectionDest="my_goto_band"
                  selectionDestType="JavaScript"
                  selectionAltTextBinding="SELECT_PERIOD_RANGE@DBMsgBundle@servletRequest" 
                  position="south"
                  dynamicTimeSelector="true"
                  xAxisScrollDest="scroll_timechart"
                  xAxisScrollDestType="JavaScript"
                  xAxisScrollPrevBinding="scrollButtonsAvailable@activityDetailsChart@serviceActivityBean@servletRequest"
                  xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsgBundle@servletRequest" 
                  xAxisScrollNextBinding="scrollButtonsAvailable@activityDetailsChart@serviceActivityBean@servletRequest"
                  xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsgBundle@servletRequest" 
                  selectionIndicator="shading"
                  dynamicTimeSelectorColorBinding="sliderColor@waitAreaChart@serviceActivityBean@servletRequest"
                  dynamicTimeSelectorEdgeColorBinding="sliderEdgeColor@waitAreaChart@serviceActivityBean@servletRequest"
                >
                </oem:timeSelector>
                <oem:boundChartDataSource 
                  dataClass="oracle.sysman.db.adm.inst.ServiceDetailsController"
                  dataMethod="updateChartData" />
                <oem:imageMap imageMapDataSourceBinding="legendLinks@waitAreaChart@serviceActivityBean@servletRequest"/> 
                <oem:chartColumn                                   
                    isKey="true" 
                    displayLabel=""
                    sourceIndex="0" />
                <oem:chartColumn
                    isTimeColumn="true"
                    displayLabel="Time"
                    sourceIndex="1"  />
                <oem:chartColumn                                   
                    displayLabel=""
                    sourceIndex="2" />
              </uix:contents>
            </oem:chart>

            </uix:case>
            </uix:switcher>
            </uix:case>
            <uix:case name="false">
             <uix:rowLayout>
                <uix:text textBinding="5001@ChartMsgBundle@servletRequest"/>
              </uix:rowLayout> 
            </uix:case>
            </uix:switcher>


          <uix:switcher childNameBinding="showDetails@servletRequest">
          <uix:case name="true">
            <uix:header size="1"
                textBinding="detailIntervalHeader@serviceActivityBean@servletRequest"
                renderedBinding="showChart@serviceActivityBean@servletRequest">
    
        <uix:tableLayout width="100%" >
          
              <uix:rowLayout vAlign="top">
	        <uix:cellFormat hAlign="left">
                  <uix:spacer width="8"/>
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="SPOT_SQL_DETAIL_TEXT@DBMsgBundle@servletRequest"/>
                  <uix:spacer width="8"/>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="detailStartTime@serviceActivityBean@servletRequest"/>
           <uix:cellFormat hAlign="right" >
             <uix:button textBinding="ASH_REPORT@DBMsgBundle@servletRequest"
              renderedBinding="showAshReportLink@servletRequest"
              destinationBinding="ashReportLink@servletRequest"
              shortDescBinding="ASH_REPORT@DBMsgBundle@servletRequest" />
           </uix:cellFormat>
           
	        </uix:cellFormat>


              </uix:rowLayout>

	    </uix:tableLayout>

	    <uix:tableLayout width="100%">

	      <uix:rowLayout vAlign="top">

	        <uix:cellFormat hAlign="right" vAlign="top">
                  <%@ include file="srvActSqlTab.jspf" %>   
                </uix:cellFormat>
              
	        <uix:cellFormat hAlign="left" vAlign="top">
		<uix:switcher childNameBinding="tabIndex@servletRequest" >
		  <uix:case name="0" >
		    <%@ include file="srvActSessionTab.jspf" %>  
		   </uix:case> 

		   <uix:case name="3" >
		    <%@ include file="srvActFileTab.jspf" %>
		   </uix:case>

		  <uix:case name="4" >
		    <%@ include file="srvActObjTab.jspf" %>
		   </uix:case>  

		  <uix:case name="5" >
		    <%@ include file="srvActModuleTab.jspf" %>
		   </uix:case> 

		  <uix:case name="6" >
		    <%@ include file="srvActActionTab.jspf" %>
		   </uix:case> 

		  <uix:case name="8" >
		    <%@ include file="srvActClientTab.jspf" %>
		   </uix:case> 

		  <uix:case name="9" >
		    <%@ include file="srvActPlsqlTab.jspf" %>
		   </uix:case> 

		 </uix:switcher>    
                </uix:cellFormat>

             </uix:rowLayout> 
             
             </uix:tableLayout>
            </uix:header>
            </uix:case>
            </uix:switcher>  


                </uix:subTabLayout>
              </uix:header>
            </uix:stackLayout>
          </uix:rowLayout>
        </uix:tableLayout>
               </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

