<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Service Detail General tab =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:styleSheet/>
<script>
   
 function scroll_timechart(direction)
 {
   if (direction == 'prev'){
     document.servGenForm.direction.value = '1';
   }
   else{
     document.servGenForm.direction.value = '2';
   }
   submitForm('servGenForm', true, {'event':'scrollChart'});
 }  

 function my_goto_band(selIdx, startMS, endMS)
{
}
</script>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

      <uix:switcher childNameBinding="refreshChoice@servletRequest">
        <uix:case name="RT_15">
          <uix:rawText>
            <meta http-equiv="Refresh" content="15" >
          </uix:rawText>
        </uix:case>
      </uix:switcher>

      <db:form name="servGenForm"  destinationBinding="consumerDetailsDest@servletRequest" copyParams="target,type">
      <uix:formValue name="service" valueBinding="service@serviceDetailsBean@servletRequest"/>
      <uix:formValue name="pageNum" value="1"/>
      <uix:formValue name="event" value=""/>
      <uix:formValue name="direction" value=""/>

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
		                msgBundleBinding="DBMsgBundle"
						titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
		                msgBundleBinding="DBMsgBundle"
						titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">
            <uix:spacer height="10"/>
          </uix:rowLayout>
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:styledText labeledNodeId="view_choice" styleClass="OraInstructionText"
			                  textBinding="VIEW_DATA@DBMsgBundle@servletRequest" />
              <uix:spacer width="5"/>
              <uix:choice name="refreshChoice" id="view_choice" onChange="submitForm('servGenForm', true, {'event':'changeRefreshChoice'})"
			              selectedValueBinding="refreshChoice@serviceDetailsBean@servletRequest">
                <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
				            value="RT_15"/>
                <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
				            value="RT_MAN"/>
                <uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                                            value="HIST_CUST"/>                               </uix:choice>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:stackLayout>
              <uix:header textBinding="header@serviceDetailsBean@servletRequest" >
                <%@ include file="refreshTime.jspf" %>
                  <uix:subTabLayout>
                    <uix:subTabs>
                      <uix:switcher childNameBinding="showActivity@serviceDetailsBean@servletRequest">
                        <uix:case name="true">
                          <uix:subTabBar selectedIndex="0">
                            <%@ include file="serviceTab10g.jspf" %>
                          </uix:subTabBar>
                  	</uix:case>
                        <uix:case name="false">
                          <uix:subTabBar selectedIndex="0">
                            <%@ include file="serviceTabPre10g.jspf" %>
                          </uix:subTabBar>
                        </uix:case>
                       </uix:switcher>
  		      </uix:subTabs>

     <oem:chart 
        chartType="timeSeriesChart"
        width="1050"
        height="225"
        format="svg"
        svgHighlightLegend="true"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="true"
        fill="cumulative"
        titleBinding="TOP_MODULES@TopConsumersMsgBundle@servletRequest"
        titleVisible="false"         
        yAxisLabelBinding="ACTIVE_SESSIONS@TopConsumersMsgBundle@servletRequest"
        yAxisNumberFormatBinding="YAxisLabelFormat@topModulesChart@moduleDetails@serviceDetailsBean@servletRequest"
        xAxisMinBinding="beginDate@topModulesChart@moduleDetails@serviceDetailsBean@servletRequest"
        xAxisMaxBinding="endDate@topModulesChart@moduleDetails@serviceDetailsBean@servletRequest"
        axisMin="0"
        axisMaxBinding="actualMaxValue@topModulesChart@moduleDetails@serviceDetailsBean@servletRequest"
     >

      <uix:contents>
                <oem:timeSelector
		  intervalTimeSec="900"
                  selectionDest="my_goto_band"
                  selectionDestType="JavaScript"

                  height="20"
                  position="south"
        xAxisMinBinding="beginDate@topModulesChart@moduleDetails@serviceDetailsBean@servletRequest"
        xAxisMaxBinding="endDate@topModulesChart@moduleDetails@serviceDetailsBean@servletRequest"
                  xAxisScrollDest="scroll_timechart"
                  xAxisScrollDestType="JavaScript"
                  xAxisScrollPrevBinding="scrollButtonsAvailable@topModulesChart@moduleDetails@serviceDetailsBean@servletRequest"
                  xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsgBundle@servletRequest"
                  xAxisScrollNextBinding="scrollButtonsAvailable@topModulesChart@moduleDetails@serviceDetailsBean@servletRequest"
                  xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsgBundle@servletRequest"
                  showBorderBinding="scrollButtonsAvailable@topModulesChart@moduleDetails@serviceDetailsBean@servletRequest"
                >
                </oem:timeSelector>
        <oem:boundChartDataSource 
          chartDataSourceBinding="modulesGIF@moduleDetails@serviceDetailsBean@servletRequest"/>
         
        <oem:imageMap imageMapDataSourceBinding="modulesImageMap@moduleDetails@serviceDetailsBean@servletRequest"/>

        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
     </oem:chart>

                <uix:switcher childNameBinding="viewChoice@dataSourceBean@servletRequest">
                  <uix:case name="1">
                    <uix:header textBinding="ACTIVE_SM@TopConsumersMsgBundle@servletRequest">
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:spacer height="10"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                    <uix:styledText labeledNodeId="view_choice2" styleClass="OraInstructionText"
                        textBinding="VIEW_DETAIL@DBMsgBundle@servletRequest" />
                    <uix:choice name="viewChoice" id="view_choice2" onChange="submitForm('servGenForm', true, {'event':'changeViewChoice'})"
                        selectedValueBinding="viewChoice@dataSourceBean@servletRequest">
                      <uix:option textBinding="ACTIVE_SM@TopConsumersMsgBundle@servletRequest"
                        value="1"/>
                      <uix:option textBinding="ENABLED_SM@TopConsumersMsgBundle@servletRequest"
                        value="2"/>
                    </uix:choice>
					</uix:cellFormat>
                    <uix:cellFormat hAlign="right">

	        <uix:switcher childNameBinding="isRac@servletRequest">
 		   <uix:case name="false">
                    <uix:submitButton textBinding="ADD_MODULE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="statAggrAdmin"
					                  renderedBinding="showAddButton@dataSourceBean@servletRequest"/>
		  </uix:case>
		 </uix:switcher>
					</uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
                  <uix:rowLayout width="100%">
                    <uix:switcher childNameBinding="node@dataSourceBean@servletRequest">
                      <uix:case name="okNode">
                        <oem:table name="modulesTable" beanKey="dataSourceBean"
				summaryBinding="ACTIVE_SM@TopConsumersMsgBundle@servletRequest"
						           formSubmitted="true"
								   dataSourceProp="twoDUIDataSource"
								   width="100%"
								   alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
								   blockSize="25" partialRenderMode="self">

                          <uix:tableSelection>

                            <uix:multipleSelection selectionBinding="selection@dataSourceBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedBinding="selected"
                                disabledBinding="selectionDisabled"
	                         renderedBinding="isNonRac@servletRequest">
                            <%--
                              <uix:messagePrompt promptBinding="ACTIONS@TopConsumersMsgBundle@servletRequest"/>
                              <uix:choice name="actionChoice" selectedValueBinding="actionChoice@dataSourceBean@servletRequest">
                                <uix:option textBinding="ENABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
                                    value="enableStatAggr"/>
                                <uix:option textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
                                    value="disableStatAggr"/>
                                <uix:option textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                    value="enableSQLTrace"/>
                                <uix:option textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                    value="disableSQLTrace"/>
                                <uix:option textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
                                    value="viewSQLTraceFile"/>
                              </uix:choice>
                              <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
							                    name="event" value="changeAction"/>
							                    --%>
                              <uix:submitButton textBinding="ENABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="enableStatAggr"/>
                              <uix:submitButton textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableStatAggr"/>
                              <uix:submitButton textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="enableSQLTrace"/>
                              <uix:submitButton textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableSQLTrace"/>
                              <uix:submitButton textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="viewSQLTraceFile"/>
		                    </uix:multipleSelection>

                          </uix:tableSelection>
                        </oem:table>
                      </uix:case>
                    </uix:switcher>
                  </uix:rowLayout>
                </uix:header>
                  </uix:case>
                  <uix:case name="2">
                    <uix:header textBinding="ENABLED_SM@TopConsumersMsgBundle@servletRequest">
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:spacer height="10"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                    <uix:styledText labeledNodeId="view_choice3" styleClass="OraInstructionText"
                        textBinding="VIEW_DETAIL@DBMsgBundle@servletRequest" />
                    <uix:choice name="viewChoice" id="view_choice3" onChange="submitForm('servGenForm', true, {'event':'changeViewChoice'})"
                        selectedValueBinding="viewChoice@dataSourceBean@servletRequest">
                      <uix:option textBinding="ACTIVE_SM@TopConsumersMsgBundle@servletRequest"
                        value="1"/>
                      <uix:option textBinding="ENABLED_SM@TopConsumersMsgBundle@servletRequest"
                        value="2"/>
                    </uix:choice>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                    <%--
                    <uix:submitButton textBinding="SQL_TRACE_ADMIN@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="SQLTraceAdmin"/>
                    <uix:submitButton textBinding="STAT_AGGR_ADMIN@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="statAggrAdmin"/>
					                  --%>
	        <uix:switcher childNameBinding="isRac@servletRequest">
 		   <uix:case name="false">
                    <uix:submitButton textBinding="ADD_MODULE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="statAggrAdmin"
					                  renderedBinding="showAddButton@dataSourceBean@servletRequest"/>
		  </uix:case>
		 </uix:switcher>
		</uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
                  <uix:rowLayout width="100%">
                    <uix:switcher childNameBinding="node@dataSourceBean@servletRequest">
                      <uix:case name="okNode">
                        <oem:table name="modulesTable" beanKey="dataSourceBean"
				summaryBinding="ENABLED_SM@TopConsumersMsgBundle@servletRequest"
						           formSubmitted="true"
								   dataSourceProp="twoDUIDataSource"
								   width="100%"
								   alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
								   blockSize="25" partialRenderMode="self">
                          <uix:tableSelection>
                            <uix:multipleSelection selectionBinding="selection@dataSourceBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedBinding="selected"
                                disabledBinding="selectionDisabled"
	                         renderedBinding="isNonRac@servletRequest">
                            <%--
                              <uix:messagePrompt promptBinding="ACTIONS@TopConsumersMsgBundle@servletRequest"/>
                              <uix:choice name="actionChoice" selectedValueBinding="actionChoice@dataSourceBean@servletRequest">
                                <uix:option textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                            value="enableSQLTrace"/>
                                <uix:option textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                            value="disableSQLTrace"/>
                                <uix:option textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
                                            value="viewSQLTraceFile"/>
                                <uix:option textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
                                            value="disableStatAggr"/>
                              </uix:choice>
                              <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
							                    name="event" value="changeAction"/>
							                    --%>
                              <uix:submitButton textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="enableSQLTrace"/>
                              <uix:submitButton textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableSQLTrace"/>
                              <uix:submitButton textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="viewSQLTraceFile"/>
                              <uix:submitButton textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableStatAggr"/>
		                    </uix:multipleSelection>
                          </uix:tableSelection>
                        </oem:table>
                      </uix:case>
                      <%--
                      <uix:case name="emptyNode">
                        <uix:styledText textBinding="noData@topSessionsBean@servletRequest"/>
                      </uix:case>
                      --%>
                      <!-- Error message -->
                      <uix:case name="errNode">
                        <!-- <include baja:node="errMessage" /> -->
                      </uix:case>
                    </uix:switcher>
                  </uix:rowLayout>
                </uix:header>
                  </uix:case>
                </uix:switcher>
                  <uix:spacer height="10"/>
                </uix:subTabLayout>
              </uix:header>
            </uix:stackLayout>
          </uix:rowLayout>
        </uix:tableLayout>
               </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

