<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Top Clients Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

      <uix:switcher childNameBinding="refreshChoice@servletRequest">
        <uix:case name="RT_15">
          <uix:rawText>
            <meta http-equiv="Refresh" content="15" >
          </uix:rawText>
        </uix:case>
      </uix:switcher>

      <db:form name="topClientsForm" destinationBinding="topClientsDest@servletRequest" copyParams="target,type">

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout width="100%">
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:styledText labeledNodeId="view_choice" styleClass="OraInstructionText"
                            textBinding="VIEW_DATA@DBMsgBundle@servletRequest" />
              <uix:spacer width="5"/>
              <uix:choice name="refreshChoice" id="view_choice" onChange="submitForm('topClientsForm', true, {'event':'changeRefreshChoice'})"
                selectedValueBinding="refreshChoice@topClientsBean@servletRequest">
                <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                        value="RT_15"/>
                <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                        value="RT_MAN"/>
              </uix:choice>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:stackLayout>

              <uix:header textBinding="TOP_CONSUMERS@DBMsgBundle@servletRequest" >
              <%@ include file="/database/instances.jspf" %>

                <uix:tableLayout width="100%">

                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat>
                      <uix:switcher childNameBinding="showTime@topClientsBean@servletRequest">
                        <uix:case name="true">
                          <uix:rowLayout hAlign="right">
                            <uix:cellFormat>
                              <%@ include file="../../../rac/refreshTime.jspf" %>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>
                </uix:tableLayout>

                <uix:subTabLayout>
                  <uix:subTabs>
                    <uix:subTabBar selectedIndex="4">
                      <uix:link textBinding="OVERVIEW@DBMsgBundle@servletRequest"
                        destinationBinding="overviewDest@servletRequest"/>
                      <uix:link textBinding="TOP_SERVICES@DBMsgBundle@servletRequest"
                        destinationBinding="topServicesDest@servletRequest"/>
                      <uix:link textBinding="TOP_SM@DBMsgBundle@servletRequest"
                        destinationBinding="topSMDest@servletRequest"/>
                      <uix:link textBinding="TOP_SMA@DBMsgBundle@servletRequest"
                        destinationBinding="topSMADest@servletRequest"/>
                      <uix:link textBinding="TOP_CLIENTS@DBMsgBundle@servletRequest"
                        destinationBinding="topClientsDest@servletRequest"/>
                      <uix:link textBinding="TOP_SESSIONS_HEADER@DBMsgBundle@servletRequest"
                        destinationBinding="topSessionsDest@servletRequest"/>
                    </uix:subTabBar>
                  </uix:subTabs>

                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:spacer height="10"/>
                  </uix:rowLayout>
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat hAlign="left">
                    <uix:styledText labeledNodeId="view_choice2" styleClass="OraInstructionText"
                        textBinding="VIEW_DETAIL@DBMsgBundle@servletRequest" />
                    <uix:choice name="viewChoice" id="view_choice2" onChange="submitForm('topClientsForm', true, {'event':'changeViewChoice'})"
                        selectedValueBinding="viewChoice@topClientsBean@servletRequest">
                      <uix:option textBinding="ACTIVE_CLIENT@TopConsumersMsgBundle@servletRequest"
                        value="1"/>
                      <uix:option textBinding="ENABLED_CLIENT@TopConsumersMsgBundle@servletRequest"
                        value="2"/>
                    </uix:choice>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                    <%--
                    <uix:submitButton textBinding="SQL_TRACE_ADMIN@TopConsumersMsgBundle@servletRequest"
                        name="event" value="SQLTraceAdmin"/>
                    <uix:submitButton textBinding="STAT_AGGR_ADMIN@TopConsumersMsgBundle@servletRequest"
                        name="event" value="statAggrAdmin"/>
                        --%>
	        <uix:switcher childNameBinding="isRac@servletRequest">
 		   <uix:case name="false">
                    <uix:submitButton textBinding="ADD_CLIENT@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="statAggrAdmin"
					                  renderedBinding="showAddButton@topClientsBean@servletRequest"/>
		  </uix:case>
		 </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

                              <uix:switcher childNameBinding="viewChoice@topClientsBean@servletRequest">
                                <uix:case name="1">
                  <uix:rowLayout width="100%">
                    <uix:switcher childNameBinding="node@topClientsBean@servletRequest">
                      <uix:case name="okNode">
                        <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
			    summaryBinding="ACTIVE_CLIENT@TopConsumersMsgBundle@servletRequest"
                            formSubmitted="true"
                            dataSourceProp="twoDUIDataSource" width="100%"
                            alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
                            blockSize="25" partialRenderMode="self">

                          <uix:tableSelection>

                            <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectionBinding="selection@topClientsBean@servletRequest" selectedBinding="selected"
                                disabledBinding="selectionDisabled"
	                         renderedBinding="isNonRac@servletRequest">
                              <%--
                              <uix:messagePrompt promptBinding="ACTIONS@TopConsumersMsgBundle@servletRequest"/>
                              <uix:choice name="actionChoice" selectedValueBinding="actionChoice@topClientsBean@servletRequest">
                                <uix:option textBinding="ENABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
                                    value="enableStatAggr"/>
                                <uix:option textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
                                    value="disableStatAggr"/>
                                <uix:option textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                    value="enableSQLTrace"/>
                                <uix:option textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                    value="disableSQLTrace"/>
                                <uix:option textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
                                    value="viewSQLTraceFile"/>
                              </uix:choice>
                              <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                                name="event" value="changeAction"/>
                                --%>
                              <uix:submitButton textBinding="ENABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="enableStatAggr"/>
                              <uix:submitButton textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableStatAggr"/>
                              <uix:submitButton textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="enableSQLTrace"/>
                              <uix:submitButton textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableSQLTrace"/>
                              <uix:submitButton textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="viewSQLTraceFile"/>
		                    </uix:multipleSelection>

                          </uix:tableSelection>
                        </oem:table>
                      </uix:case>
                      <%--
                      <uix:case name="emptyNode">
                        <uix:styledText textBinding="noData@topSessionsBean@servletRequest"/>
                      </uix:case>
                      --%>
                      <!-- Error message -->
                      <uix:case name="errNode">
                        <!-- <include baja:node="errMessage" /> -->
                      </uix:case>
                    </uix:switcher>
                  </uix:rowLayout>
                                </uix:case>
                                <uix:case name="2">
                  <uix:rowLayout width="100%">
                    <uix:switcher childNameBinding="node@topClientsBean@servletRequest">
                      <uix:case name="okNode">
                        <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
			    summaryBinding="ENABLED_CLIENT@TopConsumersMsgBundle@servletRequest"
                            formSubmitted="true"
                            dataSourceProp="twoDUIDataSource" width="100%"
                            alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
                            blockSize="25" partialRenderMode="self">
                          <uix:tableSelection>
                            <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                                selectionBinding="selection@topClientsBean@servletRequest" selectedBinding="selected"
                                disabledBinding="selectionDisabled"
	                         renderedBinding="isNonRac@servletRequest">
                              <%--
                              <uix:messagePrompt promptBinding="ACTIONS@TopConsumersMsgBundle@servletRequest"/>
                              <uix:choice name="actionChoice" selectedValueBinding="actionChoice@topClientsBean@servletRequest">
                                <uix:option textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                    value="enableSQLTrace"/>
                                <uix:option textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                    value="disableSQLTrace"/>
                                <uix:option textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
                                    value="viewSQLTraceFile"/>
                                <uix:option textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
                                    value="disableStatAggr"/>
                              </uix:choice>
                              <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                                name="event" value="changeAction"/>
                                --%>
                              <uix:submitButton textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="enableSQLTrace"/>
                              <uix:submitButton textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableSQLTrace"/>
                              <uix:submitButton textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="viewSQLTraceFile"/>
                              <uix:submitButton textBinding="DISABLE_STAT_AGGR@TopConsumersMsgBundle@servletRequest"
					                  name="event" value="disableStatAggr"/>
		                    </uix:multipleSelection>
                          </uix:tableSelection>
                        </oem:table>
                      </uix:case>
                      <%--
                      <uix:case name="emptyNode">
                        <uix:styledText textBinding="noData@topSessionsBean@servletRequest"/>
                      </uix:case>
                      --%>
                      <!-- Error message -->
                      <uix:case name="errNode">
                        <!-- <include baja:node="errMessage" /> -->
                      </uix:case>
                    </uix:switcher>
                  </uix:rowLayout>
                                </uix:case>
                              </uix:switcher>

                </uix:subTabLayout>

              </uix:header>

            </uix:stackLayout>
          </uix:rowLayout>
        </uix:tableLayout>

       <uix:spacer height="15" />

       <%@ include file="/database/instance/monitoringLinks.jspf" %>


       </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

