<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Top Services Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

        <uix:rawText renderedBinding="showRefreshMeta@servletRequest">
          <meta http-equiv="Refresh" content="15" >
        </uix:rawText>

      <db:form name="topServicesForm" destinationBinding="topServicesDest@servletRequest" copyParams="target,type">

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:tableLayout width="100%" cellSpacing="5">
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:styledText labeledNodeId="view_choice" styleClass="OraInstructionText"
                            textBinding="VIEW_DATA@DBMsgBundle@servletRequest" />
              <uix:spacer width="5"/>
              <uix:choice name="refreshChoice" id="view_choice" onChange="submitForm('topServicesForm', true, {'event':'changeRefreshChoice'})"
                    selectedValueBinding="refreshChoice@topServicesBean@servletRequest">
                <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                        value="RT_15"/>
                <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                        value="RT_MAN"/>
              </uix:choice>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>

              <uix:header textBinding="TOP_CONSUMERS@DBMsgBundle@servletRequest" >
              <%@ include file="/database/instances.jspf" %>

                <uix:tableLayout width="100%" cellSpacing="2"
                                 renderedBinding="showTime@topServicesBean@servletRequest">
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat>
                      <%@ include file="../../../rac/refreshTime.jspf" %>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

                <uix:subTabLayout>
                  <uix:subTabs>
                    <uix:subTabBar selectedIndex="1">
                      <uix:link textBinding="OVERVIEW@DBMsgBundle@servletRequest"
                        destinationBinding="overviewDest@servletRequest"/>
                      <uix:link textBinding="TOP_SERVICES@DBMsgBundle@servletRequest"
                        destinationBinding="topServicesDest@servletRequest"/>
                      <uix:link textBinding="TOP_SM@DBMsgBundle@servletRequest"
                        destinationBinding="topSMDest@servletRequest"/>
                      <uix:link textBinding="TOP_SMA@DBMsgBundle@servletRequest"
                        destinationBinding="topSMADest@servletRequest"/>
                      <uix:link textBinding="TOP_CLIENTS@DBMsgBundle@servletRequest"
                        destinationBinding="topClientsDest@servletRequest"/>
                      <uix:link textBinding="TOP_SESSIONS_HEADER@DBMsgBundle@servletRequest"
                        destinationBinding="topSessionsDest@servletRequest"/>
                    </uix:subTabBar>
                  </uix:subTabs>

                <uix:tableLayout width="100%" cellSpacing="5">
                  <uix:rowLayout hAlign="left">
                    <uix:cellFormat hAlign="left">
                      <uix:styledText labeledNodeId="view_choice2" styleClass="OraInstructionText"
                        textBinding="VIEW_DETAIL@DBMsgBundle@servletRequest" />
                      <uix:choice name="viewChoice" id="view_choice2" onChange="submitForm('topServicesForm', true, {'event':'changeViewChoice'})"
                        selectedValueBinding="viewChoice@topServicesBean@servletRequest">
                        <uix:option textBinding="ACTIVE_SERVICE@TopConsumersMsgBundle@servletRequest"
                        value="1"/>
                        <uix:option textBinding="ENABLED_SERVICE@TopConsumersMsgBundle@servletRequest"
                        value="2"/>
                      </uix:choice>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

                    <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
			summaryBinding="TOP_SERVICES@DBMsgBundle@servletRequest"
                        formSubmitted="true"
                        dataSourceProp="twoDUIDataSource" width="100%"
                        alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
                        blockSize="25" partialRenderMode="self">

                      <uix:tableSelection>

                        <uix:multipleSelection selectionBinding="selection@topServicesBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedBinding="selected"
                                                  disabledBinding="selectionDisabled" renderedBinding="isNonRac@servletRequest">

                          <uix:submitButton textBinding="ENABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                            name="event" value="enableSQLTrace"/>
                          <uix:submitButton textBinding="DISABLE_SQL_TRACE@TopConsumersMsgBundle@servletRequest"
                                            name="event" value="disableSQLTrace"/>
                          <uix:submitButton textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest"
                                            name="event" value="viewSQLTraceFile"/>
                        </uix:multipleSelection>

                      </uix:tableSelection>
                    </oem:table>
                  <uix:spacer height="10"/>
                </uix:subTabLayout>

              </uix:header>

         <uix:spacer height="15" />

         <%@ include file="/database/instance/monitoringLinks.jspf" %>


       </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

