<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  View SQL Trace File Page =================== -->

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <db:form name="viewSQLTraceForm" destinationBinding="refreshDest@servletRequest" copyParams="target,type">

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             msgBundleBinding="DBMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:pageLayout>

        <%@ include file="/database/global.jspf" %>

		<uix:stackLayout>
		  <uix:spacer height="10"/>
		  <uix:header textBinding="VIEW_SQL_TRACE_FILE@TopConsumersMsgBundle@servletRequest" />
		  <uix:spacer height="10"/>
		  <uix:styledText styleClass="OraInstructionText" textBinding="viewSQLTraceInst@servletRequest" />
		  <uix:spacer height="20"/>
		  <uix:rowLayout>
		    <uix:spacer width="30"/>
   		    <uix:styledText styleClass="OraInstructionText" textBinding="command@servletRequest" />
		  </uix:rowLayout>
   		  <uix:spacer height="20"/>
		  <uix:styledText styleClass="OraInstructionText" textBinding="TKPROF_INST@TopConsumersMsgBundle@servletRequest" />
        </uix:stackLayout>
        

        <uix:pageButtons>
		  <uix:pageButtonBar>
			<uix:submitButton name="ok" textBinding="OK@DBObjectMsgBundle@servletRequest" destinationBinding="refreshDest@servletRequest"/>
		  </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
 
