<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:variable name="quot">"</xsl:variable>
 
 <!-- ++++++++++++ root path where emviewers are deployed +++++++++++++++ -->
  <xsl:variable name="base_path">
    <xsl:choose>
      <xsl:when test="/report/@base_path">
        <xsl:value-of
          select="concat(/report/@base_path, '/')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'http://download.oracle.com/otn_software/'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!-- ++++++++++++ main template for SQL monitor viewer +++++++++++++++ -->
  <xsl:template match="/">
  <html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <base>
      <xsl:attribute name="href">
        <xsl:value-of select="$base_path"/>
      </xsl:attribute>
    </base>
    <script language="javascript" type="text/javascript">
      <xsl:attribute name="src">
        <xsl:value-of select="'emviewers/scripts/flashver.js'"/>
      </xsl:attribute>
      <xsl:comment>Test flash version</xsl:comment>                  
    </script>
    <style>
      body { margin: 0px; overflow:hidden }
    </style>

    <xsl:apply-templates
      select="/report/*/report_parameters"/>
  </head>

  <body scroll="no">

        <script type="text/xml">
          <xsl:comment>FXTMODEL</xsl:comment>
            <xsl:copy-of select="/"/>
          <xsl:comment>FXTMODEL</xsl:comment>
        </script>
        <script language="JavaScript" type="text/javascript">
          <xsl:attribute name="src">
            <xsl:value-of select="'emviewers/scripts/loadswf.js'"/>
          </xsl:attribute>
          <xsl:comment>Load report viewer</xsl:comment>
        </script>
        <iframe name="_history" frameborder="0" scrolling="no" width="22" 
                height="0">
          <html>
            <head>
              <meta http-equiv="Content-Type" 
                    content="text/html; charset=iso-8859-1" />
              <script type='text/javascript' language='JavaScript1.2' 
                      charset='utf-8'>
                var v = new top.Vars(top.getSearch(window));
                var fv = v.toString('$_');
              </script>
            </head>
            <body>
              <script type='text/javascript' language='JavaScript1.2'
                      charset='utf-8' >
                <xsl:attribute name="src">
                  <xsl:value-of select="'emviewers/scripts/document.js'"/>
                </xsl:attribute>
                <xsl:comment>Run document script</xsl:comment>
              </script>
            </body>
          </html>
        </iframe>
  </body>
</html>
</xsl:template>

<!-- +++++++++++++++++++++++ auto-refresh template +++++++++++++++++++++++ -->
<xsl:template match="report_parameters">
  <xsl:if test="auto_refresh">
    <meta http-equiv="refresh">
      <xsl:attribute name="content">
        <xsl:value-of select="auto_refresh"/>
      </xsl:attribute>
    </meta>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
