<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext  id="renderingContext">
 <uix:bundle name="DBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
 <uix:bundle name="HDMMsg"
      class="oracle.sysman.db.rsc.inst.HDMMsg"/>
 <oem:setURLEncoder id="renderingContext"/> 
 <uix:document>
  <%@ include file="/enablePPR.jspf" %>

  <%@ include file="/oemTitle.jspf" %>

  <uix:body>
   <db:form name="foo" method="POST" destination="/console/database/instance/hdm"    copyParams="target,type,dbPageNum, task_id,findingID, refreshChoice">
    <uix:pageLayout>

      <%@ include file="/database/global.jspf" %>
      <oem:messageBox messageType="error" 
                  errorTableBinding="dbError@servletRequest"
                  titleTextKey="titleText"
                  mainTextKey="noTaskText"/>
      <oem:messageBox messageType="error"
                          errorTableBinding="errorsSqlTuning@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="info"
                          errorTableBinding="infoSqlTuning@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
      <uix:switcher childNameBinding="findingDetailsAvailable@servletRequest">
       <uix:case name="true">  
        <uix:header textBinding="header@HDMFindingDetailsBean@servletRequest">
         <uix:switcher childNameBinding="gte11g@HDMResultsBean@servletRequest"> 
          <uix:case name="false">
           <uix:stackLayout>
            <%@ include file="generalinclude.jspf" %> 
            <uix:separator/>
            <uix:labeledFieldLayout labelWidth="25%" columns="1">
    
             <uix:styledText styleClass="OraPromptText"
               textBinding="FINDING_HEADER@HDMMsgBundle@servletRequest"/>
             <uix:styledText styleClass="OraDataText" textBinding="message@HDMFindingDetailsBean@servletRequest"/>    

             <uix:styledText styleClass="OraPromptText"
               textBinding="IMPACT_HEADER@HDMMsgBundle@servletRequest"/>
             <uix:styledText styleClass="OraDataText" textBinding="impactInMin@HDMFindingDetailsBean@servletRequest"/>
    
             <uix:styledText styleClass="OraPromptText"
               textBinding="PERCENTAGE_FINDING_IMPACT@HDMMsgBundle@servletRequest"/>
               
             <uix:flowLayout>
                <uix:include nodeBinding="impactBar@HDMFindingDetailsBean@servletRequest" />
                <uix:spacer width="5" />
                <uix:styledText styleClass="OraDataText" textBinding="impactInPct@HDMFindingDetailsBean@servletRequest"/>
             </uix:flowLayout>
            </uix:labeledFieldLayout>
       
           </uix:stackLayout>
          </uix:case>
          <uix:case name="true"> 
           <uix:tableLayout width="100%">
           
             <uix:rowLayout>
               <uix:cellFormat hAlign="right" >
                 <uix:styledText styleClass="OraPromptText"
                    textBinding="FINDING_HEADER@HDMMsgBundle@servletRequest"/>
               </uix:cellFormat>
               <uix:spacer width="8"/>
               <uix:cellFormat hAlign="left" >
                 <uix:styledText styleClass="OraDataText" textBinding="message@HDMFindingDetailsBean@servletRequest"/>      
                 <uix:spacer width="5"/>
                 <uix:button textBinding="FINDING_HISTORY@HDMMsgBundle@servletRequest" destinationBinding="findingHistoryDest@servletRequest" renderedBinding="showFindingHistory@HDMResultsBean@servletRequest"/>
               </uix:cellFormat>
             </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right" >
                 <uix:styledText styleClass="OraPromptText"
                   textBinding="FINDING_HISTORY_IMPACT_COL_HEADER@HDMMsgBundle@servletRequest"/>
               </uix:cellFormat>
               <uix:spacer width="8"/>
               <uix:cellFormat hAlign="left" > 
                 <uix:styledText styleClass="OraDataText" textBinding="activeSession@HDMFindingDetailsBean@servletRequest"/>
               </uix:cellFormat>
             </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right" >
                 <uix:styledText styleClass="OraPromptText"
                   textBinding="PERCENTAGE_FINDING_IMPACT@HDMMsgBundle@servletRequest"/>
               </uix:cellFormat>
               <uix:spacer width="8" />
               <uix:cellFormat hAlign="left" > 
                 <uix:flowLayout>
                   <uix:include nodeBinding="impactBar@HDMFindingDetailsBean@servletRequest" />
                   <uix:spacer width="5" />
                   <uix:styledText styleClass="OraDataText" textBinding="impactInPct@HDMFindingDetailsBean@servletRequest"/>
                 </uix:flowLayout>
               </uix:cellFormat>
             </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                 <uix:styledText styleClass="OraPromptText"
                   textBinding="START_TIME@HDMMsgBundle@servletRequest"/>
               </uix:cellFormat>
               <uix:spacer width="8" />     
               <uix:cellFormat hAlign="left" > 
                 <uix:styledText styleClass="OraDataText"
                   textBinding="startPeriod@HDMResultsBean@servletRequest"/>
               </uix:cellFormat>
             </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right" >
                 <uix:styledText styleClass="OraPromptText"
                   textBinding="DURATION@HDMMsgBundle@servletRequest"/>
               </uix:cellFormat>
               <uix:spacer width="8" />  
               <uix:cellFormat hAlign="left" > 
                 <uix:styledText styleClass="OraDataText"
                   textBinding="periodDuration@HDMResultsBean@servletRequest"/>
               </uix:cellFormat>
             </uix:rowLayout>

    
             <uix:rowLayout>
               <uix:cellFormat hAlign="right" >
                 <uix:styledText styleClass="OraPromptText"
                   textBinding="FILTERED_COLUMN@HDMMsgBundle@servletRequest"/>
               </uix:cellFormat>
               <uix:spacer width="8" />  
               <uix:cellFormat hAlign="left" > 
                 <uix:styledText styleClass="OraDataText"
                   textBinding="filteredString@HDMFindingDetailsBean@servletRequest"/>
                 <uix:spacer width="5" />
                 <uix:button textBinding="CURRENT_FILTERS@HDMMsgBundle@servletRequest" destinationBinding="showFindingDirectivesDest@servletRequest"/>
               </uix:cellFormat>
             </uix:rowLayout>

           </uix:tableLayout>
          </uix:case>
         </uix:switcher>

         <uix:header textBinding="RECOMMENDATION_HEADER@HDMMsgBundle@servletRequest" >
          <uix:stackLayout>
         
           <uix:switcher childNameBinding="numRecGTEqOne@HDMFindingDetailsBean@servletRequest"> 
      
           <uix:case name="true">
            <uix:table name="recTable" partialRenderMode="self" 
              summaryBinding="RECOMMENDATION_HEADER@HDMMsgBundle@servletRequest"
              id="recTable" 
              tableDataBinding="recTableData@HDMFindingDetailsBean@servletRequest"  
              columnHeaderDataBinding="recColHeaderData@HDMFindingDetailsBean@servletRequest"  
              detailDisclosureBinding="detailsState@HDMFindingDetailsBean@servletRequest" 
              formSubmitted="true" 
              allDetailsEnabled="true" width="100%" 
              blockSizeBinding="recTableBlockSize@HDMFindingDetailsBean@servletRequest"
              valueBinding="recTableValue@HDMFindingDetailsBean@servletRequest" 
              minValueBinding="recTableMinValue@HDMFindingDetailsBean@servletRequest" 
              maxValueBinding="recTableMaxValue@HDMFindingDetailsBean@servletRequest"
              columnFormatsBinding="recTableColFormats@HDMFindingDetailsBean@servletRequest" >
              
              <uix:tableSelection>
               <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedBinding="selected"  disabledBinding="selectionDisabled" selectionBinding="selection@HDMFindingDetailsBean@servletRequest" renderedBinding="anySQLTuningAction@HDMFindingDetailsBean@servletRequest"> 
                <uix:contents>
                 <uix:switcher childNameBinding="anySQLTuningAction@HDMFindingDetailsBean@servletRequest"> 
                  <uix:case name="true">
                   <uix:submitButton textBinding="RUN_SELECTED_SQL_TUNING_ADVISOR@HDMMsgBundle@servletRequest" name="event" value="runSqlTuningAdvisor"/> 
                  </uix:case>
                 </uix:switcher>
                </uix:contents>
               </uix:multipleSelection>
              </uix:tableSelection>

              <uix:columnHeaderStamp>
               <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
              </uix:columnHeaderStamp>  
          
              <uix:contents>
               <uix:styledText textBinding="recType"/>
               <uix:include nodeBinding="recBenefitBar" />
               <uix:image sourceBinding="filteredImg" renderedBinding="hasFilteredResults@HDMFindingDetailsBean@servletRequest"/>
              </uix:contents>

              <uix:detail>
               <%@ include file="recSectionInclude.jspf" %>
              </uix:detail>
            </uix:table> 
           </uix:case>
    
           <uix:case name="false">
             <uix:styledText textBinding="NO_REC_AVAILABLE_MESSAGE@HDMMsgBundle@servletRequest" styleClass="OraInstructionText"/>
           </uix:case>

          </uix:switcher> 
                    
           <uix:spacer height="5"/>
           <uix:switcher childNameBinding="hasUnfilteredResults@HDMFindingDetailsBean@servletRequest">
            <uix:case name="true"> 
             <uix:stackLayout>
              <uix:styledText styleClass="OraPromptText" textBinding="VIEW_UNFILTERED_REC_DESC@HDMMsg"/>
              <uix:link textBinding="VIEW_UNFILTERED_RESULTS@HDMMsg" destinationBinding="unfilteredFindingDetails@servletRequest"/> 
             </uix:stackLayout>
            </uix:case>
           </uix:switcher> 
           <uix:switcher childNameBinding="hasFilteredResults@HDMFindingDetailsBean@servletRequest">
            <uix:case name="true">  
             <uix:stackLayout>
              <uix:styledText styleClass="OraPromptText" textBinding="VIEW_FILTERED_REC_DESC@HDMMsg"/>
              <uix:link textBinding="VIEW_FILTERED_RESULTS@HDMMsg" destinationBinding="filteredFindingDetails@servletRequest"/> 
             </uix:stackLayout>
            </uix:case> 
           </uix:switcher> 
          </uix:stackLayout>
         </uix:header>

         <uix:switcher childNameBinding="additionalInfoAvailable@HDMFindingDetailsBean@servletRequest"> 
          <uix:case name="true">
           <uix:header textBinding="ADDITIONAL_INFO_HEADER@HDMMsgBundle@servletRequest" >
            <uix:rawText textBinding="additionalInfo@HDMFindingDetailsBean@servletRequest" /> 
           </uix:header>
          </uix:case>
         </uix:switcher>

         <uix:header textBinding="FINDINGS_PATH_HEADER@HDMMsgBundle@servletRequest" >
          <uix:hGrid id="findingTree"
                         summaryBinding="FINDINGS_PATH_HEADER@HDMMsgBundle@servletRequest"
                         width="100%"
                         alternateText="No findings available"
                         destinationBinding="findingDetailsURI@servletRequest"
                         columnHeaderDataBinding="findingTreeColumnHeaderData@HDMFindingDetailsBean@servletRequest"
                         treeDataBinding="findingTreeData@HDMFindingDetailsBean@servletRequest"
                         formSubmitted="true"
                         proxyBinding="proxy@servletRequest"
                         columnFormatsBinding="findingTreeColFormats@HDMFindingDetailsBean@servletRequest">
           <uix:nodeStamp>
            <uix:column>
             <uix:columnHeader>
              <uix:styledText textBinding="FINDING_TABLE_HEADER@HDMMsgBundle@servletRequest"/>
             </uix:columnHeader>
            </uix:column>
           </uix:nodeStamp>

           <uix:columnHeaderStamp>
            <uix:text textBinding="text"/>
           </uix:columnHeaderStamp>

           <uix:include nodeBinding="impactBar" />
           <uix:link textBinding="additionalInfoText" onClickBinding="additionalInfoUrl" />
          </uix:hGrid>
         </uix:header>  
         <uix:spacer height="10" />
         
         <uix:switcher childNameBinding="instancesSectionRendered@HDMFindingDetailsBean@servletRequest">
	       <uix:case name="true">
		     <uix:header textBinding="HDM_INSTANCE_IMPACTS_HEADER@HDMMsgBundle@servletRequest" >
		       <oem:table name="instancesFTableUI"   id="instancesTable" 
			       summaryBinding="HDM_INSTANCE_IMPACTS_HEADER@HDMMsgBundle@servletRequest"
			       width="50%"
			       formSubmitted="true"
			       dataSourceProp="instancesTableUI"
			       beanKey="HDMFindingDetailsBean" copyParams="target,type,dbPageNum,task_id"
			       blockSize="25" alternateTextBinding="NO_INSTNCE_INFO_MESSAGE@HDMMsgBundle@servletRequest" partialRenderMode="self"> 
		       </oem:table>
             </uix:header>
	      </uix:case>
	    </uix:switcher>
         
          <!-- ASH breakdown of finding details-->
          <uix:header size="1" textBinding="IMPACT_BREAKDOWN@HDMMsg"
                renderedBinding="ashBreakdownSectionRendered@HDMFindingDetailsBean@servletRequest">
           <%@ include file="findingDetailsDropdown.jspf"%>
           <uix:switcher childNameBinding="instanceBreakdown@HDMFindingDetailsBean@servletRequest">
            <uix:case name="true">
             <uix:header textBinding="HDM_INSTANCE_IMPACTS_HEADER@HDMMsgBundle@servletRequest" >
              <oem:table name="instancesFTableUI"   id="instancesTable" 
                summaryBinding="HDM_INSTANCE_IMPACTS_HEADER@HDMMsgBundle@servletRequest"
                width="50%"
                formSubmitted="true"
                dataSourceProp="instancesTableUI"
                beanKey="HDMFindingDetailsBean" copyParams="target,type,dbPageNum,task_id"
                blockSize="25" alternateTextBinding="NO_INSTNCE_INFO_MESSAGE@HDMMsgBundle@servletRequest" partialRenderMode="self"> 
              </oem:table>
             </uix:header>
            </uix:case>
            <uix:case name="false">
              <uix:header textBinding="header@breakdownTable@HDMFindingDetailsBean@servletRequest"
                     renderedBinding="dropdownSelected@HDMFindingDetailsBean@servletRequest">  
                <oem:table name="breakdownTable" beanKey="HDMFindingDetailsBean"
                        alternateTextBinding="NO_DATA_AVAILABLE@DBMsgBundle" formSubmitted="true"
                        summaryBinding="header@breakdownTable@HDMFindingDetailsBean@servletRequest" 
                        dataSourceProp="breakdownTable"
                        blockSize="25" showAll="yes" partialRenderMode="self"
                        destinationBinding="findingDetailsPageUrl@HDMFindingDetailsBean@servletRequest"
                        width="100%"/>
                <uix:rowLayout hAlign="right">
                  <uix:styledText styleClass="OraCopyright"
                              textBinding="sampleCountMessage@breakdownTable@HDMFindingDetailsBean@servletRequest"/>
                </uix:rowLayout>
              </uix:header>
            </uix:case>
           </uix:switcher>
          </uix:header>
          
        </uix:header>            
       </uix:case>
      </uix:switcher> 
    </uix:pageLayout>
   </db:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>


