<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="HDMMsg"
	    class="oracle.sysman.db.rsc.inst.HDMMsg"/>
<uix:bundle name="DBMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sdkMessageBundle"
	    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>

<%@ include file="waitTimeChartScripts.jspf" %>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="foo" method="POST" destination="/console/database/instance/hdm"    copyParams="target,type,dbPageNum, task_id,endSnapID,startSnapID,refreshChoice">
	<uix:formValue name="event" value=""/>
	<uix:formValue name="direction" value=""/>
	<uix:formValue name="iconIndex" value=""/>
	<uix:formValue name="pageName" value="/database/instance/hdm/results"/>
	<uix:pageLayout>
	  <%@ include file="/database/global.jspf" %>
	  <oem:messageBox messageType="info" 
                  errorTableBinding="noTaskIDForSnapshot@servletRequest"
                   mainTextKey="noTaskIDForSnapshotText"/>
	  <oem:messageBox messageType="error" 
                  errorTableBinding="dbError@servletRequest"
			  titleTextKey="titleText" 
                   mainTextKey="noTaskText"/>
	  <oem:messageBox messageType="info" 
          	        errorTableBinding="info@servletRequest"
               	  	titleTextKey="titleText" mainTextKey="mainText"/>
	  <oem:messageBox messageType="error" 
                	errorTableBinding="errors@servletRequest"
                	titleTextKey="titleText" mainTextKey="mainText"/>
	  <oem:messageBox messageType="warning"
			errorTableBinding="intervalWarning@servletRequest"
			mainTextKey="exceptionText"/>
	  <oem:messageBox messageType="error"
			errorTableBinding="intervalError@servletRequest"
			mainTextKey="exceptionText"/>

	  <uix:spacer height="10"/>

	  <uix:switcher childNameBinding="invalidTask@HDMResultsBean@servletRequest">
	      <uix:case name="false"> 

	  <uix:header textBinding="HDM_FINDINGS_HEADER@HDMMsgBundle@servletRequest">

        <uix:contextSwitcher>
    <uix:switcher childNameBinding="showSwitchToList@servletRequest">
    <uix:case name="true">
            <uix:rowLayout>
                <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText" 
                        textBinding="SWITCH_TO@DBMsg"/>
                 </uix:cellFormat>
                 <uix:cellFormat vAlign="middle" wrappingDisabled="true">
                  <uix:spacer width="1"/>
                  <oem:choice name="newTarget"
                      onChange="submitForm('foo', true, {'event':'switchTo','dbPageNum':'2'})"
                      optionsBinding="racSwitchToList@servletRequest"
                      selectedValueBinding="targetName@HDMResultsBean@servletRequest"/>
                 </uix:cellFormat>
              </uix:rowLayout>
    </uix:case>
    </uix:switcher>
    </uix:contextSwitcher>




          <%-- REFRESH --%>
          <uix:tableLayout width="100%" cellSpacing="2">
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              <uix:rowLayout>
                <uix:styledText styleClass="OraTipText" 
                     textBinding="PAGE_REFRESHED@DBMsg"/>
	        <uix:spacer width="5"/>
                <uix:styledText styleClass="OraTipLabel" 
                     textBinding="lastUpdatedTime@HDMResultsBean@servletRequest"/>
	        <uix:spacer width="10"/>
                <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
                     destinationBinding="refreshDest@servletRequest" />
              </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>
	  <uix:header textBinding="CHOOSE_HDM_TASK@HDMMsg">
	    <uix:tableLayout width="100%">
	      <uix:rowLayout>
		 <uix:cellFormat hAlign="right">
		 <uix:submitButton textBinding="CREATE_HDM_TASK@HDMMsg" name="event" value="runHDM" renderedBinding="instUp@HDMResultsBean@servletRequest"/>
		   <uix:spacer width="5" />
		 <uix:submitButton textBinding="FINDING_HISTORY@HDMMsg" name="event" value="selectFinding" renderedBinding="showFindingHistory@HDMResultsBean@servletRequest"/>  
		 </uix:cellFormat>
	      </uix:rowLayout>
	      <uix:rowLayout>
		<uix:styledText styleClass="OraPromptText" textBinding="CHOOSE_HDM_DESC@HDMMsg"/>
	      </uix:rowLayout>
	    </uix:tableLayout>
      
    <uix:switcher childNameBinding="showData@waitsBean@servletRequest">
      <uix:case name="true">
	<uix:stackLayout>
      <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
      <uix:cellFormat hAlign="right">
      <oem:chart 
        chartType="timeSeriesChart"
        width="850"
        height="150"
        timeGranularity="SECOND" 
        orientation="vertical"
        seriesColorsAutomatic="true"
        legendPosition="east" 
        legendVisible="true"
        fill="cumulative"
        yAxisLabelBinding="ACTIVE_SESSIONS@DBMsg"
        titleBinding="ACTIVE_SESSIONS@DBMsg"
        titleVisible="false"
        xAxisMinBinding="beginDate@waitsBean@servletRequest"
        xAxisMaxBinding="endDate@waitsBean@servletRequest"
	 yAxisNumberFormatBinding="waitChartYAxisFormat@servletRequest" 
        format="svg"
        colorPaletteBinding="nonStaticPickerColors@waitsChart@waitsBean@servletRequest"
        axisMaxBinding="maxValue@waitsBean@servletRequest"
        svgHighlightLegend="true"
      >
      <uix:contents>
        <oem:timeSelector
          intervalTimeSecBinding="intervalTimeSec@waitsBean@servletRequest"
          height="20"
          selectionDest="svgIconClicked"
          selectionDestType="JavaScript"
          selectionAltTextBinding="selectionAltText@waitsBean@servletRequest"
          position="south"
          timebandDataSourceBinding="timebands@waitsBean@servletRequest"
          xAxisScrollDest="scroll_timechart"
          xAxisScrollDestType="JavaScript"
          xAxisScrollPrev="true"
          xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsg"
          xAxisScrollNext="true"
          xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsg"
          showBorder="false"
        >
        </oem:timeSelector>
        <oem:boundChartDataSource 
          chartDataSourceBinding="chartDataSource@waitsBean@servletRequest"/>               
        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>      
      </oem:chart>
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:header textBinding="ZOOM@HDMMsg"/>
          <uix:rowLayout hAlign="right">
            <uix:spacer width="20"/>
            <uix:switcher childNameBinding="zoomInDisabled@waitsBean@servletRequest">
              <uix:case name="true">
                <uix:image source="<%= request.getContextPath() + \"/images/toolbar_zoomin_enabled.gif\" %>" shortDescBinding="ZOOM_IN_TOOLTIP@HDMMsg"/>
              </uix:case>
              <uix:case name="false">
                <uix:image source="<%= request.getContextPath() + \"/images/toolbar_zoomin_enabled.gif\" %>"  shortDescBinding="ZOOM_IN_TOOLTIP@HDMMsg"  
                          onClick="submitForm('foo', true, {'event':'zoomIn'})"/>
              </uix:case>
            </uix:switcher>
            <uix:spacer width="10"/>
            <uix:switcher childNameBinding="zoomOutDisabled@waitsBean@servletRequest">
              <uix:case name="true">
                <uix:image source="<%= request.getContextPath() + \"/images/toolbar_zoomout_enabled.gif\" %>"  shortDescBinding="ZOOM_OUT_TOOLTIP@HDMMsg"  />
              </uix:case>
              <uix:case name="false">
                <uix:image source="<%= request.getContextPath() + \"/images/toolbar_zoomout_enabled.gif\" %>"  shortDescBinding="ZOOM_OUT_TOOLTIP@HDMMsg" 
                          onClick="submitForm('foo', true, {'event':'zoomOut'})"/>
              </uix:case>
            </uix:switcher>            
            </uix:rowLayout>        
      </uix:cellFormat>
      </uix:rowLayout>
      </uix:tableLayout>
	<uix:tip>
            <uix:styledText textBinding="LEGEND_TEXT@sdkMessageBundle"/>
            <uix:link textBinding="ICON_LEGEND_HEADER@HDMMsg" destinationBinding="iconLegendUrl@servletRequest"/>  
  </uix:tip>
	</uix:stackLayout>
    </uix:case>
  </uix:switcher>
      
      


	  </uix:header>

	    <uix:switcher childNameBinding="isCompleted@HDMResultsBean@servletRequest">
	      <uix:case name="true">
		<uix:header textBinding="TASK_DETAIL_HEADER@HDMMsgBundle@servletRequest">

<%-- START TASK CHOICES --%>
    <uix:labeledFieldLayout columns="2" labelWidth="10%">
    <uix:styledText styleClass="OraPromptText" textBinding="TASK_NAME@HDMMsgBundle@servletRequest" labeledNodeId="taskName"/>  
      <uix:switcher childNameBinding="moreThanOneTasks@HDMResultsBean@servletRequest">
	<uix:case name="true"> 
          <oem:choice name="selectedTaskName" id="taskName" 
	       selectedValueBinding="taskNameWithEndTime@HDMResultsBean@servletRequest" 
	       optionsBinding="allSameEndTimeTaskNames@HDMResultsBean@servletRequest" 
	       onChange="submitForm('foo', true, {'event':'chooseTask'})"/>
	</uix:case>
	<uix:case name="false"> 
          <uix:styledText styleClass="OraDataText" 
		      textBinding="name@HDMResultsBean@servletRequest"  id="taskName" />
	</uix:case>
      </uix:switcher>
    
     </uix:labeledFieldLayout>
<%-- END TASK CHOICES --%>
<uix:separator/>
		<uix:stackLayout> 
		  <uix:tableLayout width="100%">
		    <uix:rowLayout hAlign="right"> 
		      <uix:flowLayout>

		   <uix:submitButton textBinding="CURRENT_FILTERS@HDMMsgBundle@servletRequest" name="event" value="showDirectives"  renderedBinding="gte11g@HDMResultsBean@servletRequest"/>
	           <uix:spacer width="5"/>
		  <uix:button textBinding="VIEW_SNAPSHOTS_BUTTON@HDMMsgBundle@servletRequest" destinationBinding="snapshotDetailsLink@servletRequest" />
	          <uix:spacer width="5"/>
		  <uix:submitButton textBinding="REPORT_HEADER@HDMMsgBundle@servletRequest" name="event" value="viewReport"/> 
		      </uix:flowLayout>
		    </uix:rowLayout>
		  </uix:tableLayout>
		  <uix:switcher childNameBinding="gte11g@HDMResultsBean@servletRequest"> 
		     <uix:case name="false"> 
		   <%@ include file="generalinclude.jspf" %>
		     </uix:case>
		    <uix:case name="true"> 
		      <%@ include file="resultsGeneralInclude11g.jspf" %>		    </uix:case>
		  </uix:switcher> 
		  <uix:spacer height="10"/>
		    <oem:table name="findingsTableUI" id="findingsTable" 
			       summaryBinding="HDM_FINDINGS_HEADER@HDMMsgBundle@servletRequest"
			       width="100%"
			       formSubmitted="true"
			       dataSourceProp="findingsTableUI"
			       beanKey="HDMResultsBean" copyParams="target,type,dbPageNum,task_id"
			       blockSize="25" alternateTextBinding="NO_FINDING_MESSAGE@HDMMsgBundle@servletRequest" partialRenderMode="self"> 
		    </oem:table>
		  <uix:spacer height="5"/>
		  <uix:switcher childNameBinding="hasUnfilteredResults@HDMResultsBean@servletRequest">
	      <uix:case name="true"> 
			<uix:stackLayout>
	 <uix:styledText styleClass="OraPromptText" textBinding="VIEW_UNFILTERED_RESULTS_DESC@HDMMsg"/>
	 <uix:link textBinding="VIEW_UNFILTERED_RESULTS@HDMMsg" destinationBinding="unfilteredResults@servletRequest"/> 
			</uix:stackLayout>
	      </uix:case>
 </uix:switcher>
 <uix:switcher childNameBinding="hasFilteredResults@HDMResultsBean@servletRequest">
	      <uix:case name="true"> 
			<uix:stackLayout>
            <uix:styledText styleClass="OraPromptText" textBinding="VIEW_FILTERED_RESULTS_DESC@HDMMsg"/>
	   <uix:link textBinding="VIEW_FILTERED_RESULTS@HDMMsg" destinationBinding="filteredResults@servletRequest"/> 
			</uix:stackLayout>
	      </uix:case> 
     </uix:switcher> 
		  <uix:switcher  childNameBinding="nonProblemExists@HDMResultsBean@servletRequest">
		    <uix:case name="true">  
		      <uix:hideShowHeader textBinding="NON_PROBLEMS_HEADER@HDMMsgBundle@servletRequest" disclosedBinding="showNonProblems@HDMResultsBean@servletRequest" formSubmitted="true" id="hideShowInfo" partialRenderMode="self">
			<uix:rawText textBinding="nonProblems@HDMResultsBean@servletRequest" /> 

		      </uix:hideShowHeader>
		    </uix:case>
		  </uix:switcher>
		</uix:stackLayout> 
		</uix:header>
	      </uix:case>
	      <uix:case name="false">
		<uix:switcher  childNameBinding="taskID@HDMResultsBean@servletRequest">
		  <uix:case name="-1">
		    <uix:styledText textBinding="NO_HDM_TASK_LABEL@HDMMsgBundle@servletRequest"/>
		  </uix:case>
		   <uix:case name="-2">
		   </uix:case>
		  <uix:default>
		<uix:header textBinding="TASK_DETAIL_HEADER@HDMMsgBundle@servletRequest">
<%-- START TASK CHOICES --%>
    <uix:labeledFieldLayout columns="2" labelWidth="10%">
      <uix:styledText styleClass="OraPromptText" textBinding="TASK_NAME@HDMMsgBundle@servletRequest" labeledNodeId="taskName"/>
      <uix:switcher childNameBinding="moreThanOneTasks@HDMResultsBean@servletRequest">
	<uix:case name="true"> 
          <oem:choice name="selectedTaskName" id="taskName" 
	       selectedValueBinding="taskNameWithEndTime@HDMResultsBean@servletRequest" 
	       optionsBinding="allSameEndTimeTaskNames@HDMResultsBean@servletRequest" 
	       onChange="submitForm('foo', true, {'event':'chooseTask'})"/>
	</uix:case>
	<uix:case name="false"> 
          <uix:styledText styleClass="OraDataText"
		      textBinding="name@HDMResultsBean@servletRequest"/>
	 	</uix:case>
      </uix:switcher>
     <uix:messagePrompt promptBinding="TIME_RANGE@HDMMsg"/>
     <uix:styledText styleClass="OraDataText" 
          textBinding="timeRangeString@HDMResultsBean@servletRequest"/>
     </uix:labeledFieldLayout>
<%-- END TASK CHOICES --%>
<uix:separator/>

<uix:labeledFieldLayout labelWidth="10%">
      <uix:styledText styleClass="OraPromptText"
		      textBinding="TASK_OWNER@HDMMsgBundle@servletRequest"/>

      <uix:styledText styleClass="OraDataText"
		      textBinding="owner@HDMResultsBean@servletRequest"/>
			    <uix:styledText styleClass="OraPromptText"
					    textBinding="STATUS@HDMMsgBundle@servletRequest"/>
			    <uix:styledText styleClass="OraDataText"
					    textBinding="status@HDMResultsBean@servletRequest"/>
</uix:labeledFieldLayout>
      <uix:switcher  childNameBinding="statusError@HDMResultsBean@servletRequest">
		    <uix:case name="true"> 
                    <uix:labeledFieldLayout labelWidth="10%">
			    <uix:styledText styleClass="OraPromptText"
					    textBinding="ERROR_MESSAGE@HDMMsgBundle@servletRequest"/>
			    <uix:styledText styleClass="OraDataText"
					    textBinding="errorStatusMessage@HDMResultsBean@servletRequest"/>
                    </uix:labeledFieldLayout>
		    </uix:case>
		      </uix:switcher>

		      <uix:switcher  childNameBinding="executing@HDMResultsBean@servletRequest">
		    <uix:case name="true"> 
		      <uix:spacer height="10"/>
		      <uix:submitButton textBinding="REFRESH_BUTTON@HDMMsgBundle@servletRequest" name="event" value="doLoad" />
		    </uix:case>
		      </uix:switcher>
                    </uix:header>
		  </uix:default>
		</uix:switcher>
	      </uix:case>
	    </uix:switcher>  
	      
	    	    <uix:switcher childNameBinding="rac@HDMResultsBean@servletRequest">
	      <uix:case name="true"> 
		<uix:header textBinding="HDM_INSTANCES_HEADER@HDMMsgBundle@servletRequest" >
		<oem:table name="instancesTableUI" id="instancesTable" 
			       summaryBinding="HDM_INSTANCES_HEADER@HDMMsgBundle@servletRequest"
			       width="50%"
			       formSubmitted="true"
			       dataSourceProp="instancesTableUI"
			       beanKey="HDMResultsBean" copyParams="target,type,dbPageNum,task_id"
			       blockSize="25" alternateTextBinding="NO_INSTANCE_INFO_MESSAGE@HDMMsgBundle@servletRequest" partialRenderMode="self"> 
		    </oem:table> 
		</uix:header>
	      </uix:case>
	    </uix:switcher>
	  </uix:header> 
	  </uix:case>
	 </uix:switcher>
 

	</uix:pageLayout>
      </db:form>
      
    </uix:body>


  </uix:document>
</uix:renderingContext>

