<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="HDMMsg"
	    class="oracle.sysman.db.rsc.inst.HDMMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@uixDBObjectBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      
       <% if (request.getAttribute("msgTable") != null) {%>
        <uix:pageLayout messageType="confirmation">
          <% if (request.getAttribute("em2goApp") != null) {%>
            <%@ include file="/em2go/em2goGlobal.jspf" %>
          <% } else {%>
            <%@ include file="/database/globalPopup.jspf" %>
          <%} %>
          
         <% if (request.getAttribute("em2goApp") != null) {%>
           <%@ include file="/em2go/em2goFooter.jspf" %>
         <%}%>  

         <uix:stackLayout>
           <uix:rowLayout>
             <% if (request.getAttribute("em2goApp") == null) {%>
                <uix:spacer width="40"/>
             <%} %>
             <uix:styledText styleClass="OraDataText"
                             textBinding="msgText@msgTable@servletRequest"/>
           </uix:rowLayout>
         </uix:stackLayout>   

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="NO@uixDBObjectBundle@servletRequest" 
                      destinationBinding="backURL@servletRequest"/>
              <uix:button textBinding="YES@uixDBObjectBundle@servletRequest" 
                      destinationBinding="deleteURL@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      <%}%>  

      <% if (request.getAttribute("errorBean") != null) {%>
        <uix:pageLayout renderedBinding="rendered@errorBean@servletRequest"
                        messageTypeBinding="messageType@errorBean@servletRequest">
          <% if (request.getAttribute("em2goApp") != null) {%>
            <%@ include file="/em2go/em2goGlobal.jspf" %>
          <% } else {%>
            <%@ include file="/database/globalPopup.jspf" %>
          <%} %>
          
          <% if (request.getAttribute("em2goApp") != null) {%>
            <%@ include file="/em2go/em2goFooter.jspf" %>
          <%}%>
           <uix:switcher childNameBinding="rendered@errorBean@servletRequest">
             <uix:case name="true">
               <uix:rowLayout width="100%">
                 <% if (request.getAttribute("em2goApp") == null) {%>
                  <uix:spacer width="40"/>
                 <%} %>
                   <uix:styledText styleClass="OraDataText"
                                  textBinding="message@errorBean@servletRequest"/>
                 
               </uix:rowLayout>
             </uix:case>
           </uix:switcher>

           <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="NO@uixDBObjectBundle@servletRequest" 
                      destinationBinding="backURL@servletRequest"/>
	       <uix:button textBinding="FILTER_ALL_OBJS_IN_SCHEMA@HDMMsg" 
                      destinationBinding="filterAllObjsInSchemaURL@servletRequest"/>
              <uix:button textBinding="YES@uixDBObjectBundle@servletRequest" 
                      destinationBinding="deleteURL@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      <%}%>

      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>



