<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
<uix:bundle name="HDMMsg"
	    class="oracle.sysman.db.rsc.inst.HDMMsg"/>
<uix:bundle name="DBMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sdkMessageBundle"
	    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="uixDBObjectMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form name="foo" method="POST" destination="/console/database/instance/hdm"    copyParams="target,type,sql_id,dbPageNum, task_id,endSnapID,startSnapID,refreshChoice,sqlPlanHashValue">
	<uix:formValue name="event" value=""/>
	<uix:formValue name="direction" value=""/>
	<uix:formValue name="iconIndex" value=""/>
	<uix:formValue name="pageName" value="/database/instance/hdm/findingDirective"/>
	<uix:pageLayout>
	  <%@ include file="/database/global.jspf" %>
	  	    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="error@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
	  <uix:header textBinding="header@HDMSQLDirectiveBean@servletRequest"> 
	          <uix:tableLayout width="100%" cellSpacing="5">

       <uix:rowLayout>
       <uix:cellFormat width="20%" hAlign="right">
        <uix:messagePrompt promptBinding="NAME_COL_HEADER@HDMMsg" labeledNodeId="directiveName"/>
       </uix:cellFormat>
       <uix:cellFormat width="80%" hAlign="left"> 
	 <uix:switcher childNameBinding="creating@HDMSQLDirectiveBean@servletRequest">
                    <uix:case name="false">
	 <uix:styledText styleClass="OraDataText" textBinding="directiveName@HDMSQLDirectiveBean@servletRequest"/>
		    </uix:case>
	 <uix:case name="true">
                      <uix:textInput id="directiveName" name="directiveName" textBinding="directiveName@HDMSQLDirectiveBean@servletRequest" columns="50"/>
                    </uix:case>
       </uix:switcher>
       </uix:cellFormat>
      </uix:rowLayout>
            <uix:rowLayout>
       <uix:cellFormat width="20%" hAlign="right">
        <uix:messagePrompt promptBinding="ACT_SESN_LABEL@HDMMsg" labeledNodeId="activeSessions" />
       </uix:cellFormat>
       <uix:cellFormat width="80%" hAlign="left">   
	 <uix:switcher childNameBinding="editable@HDMSQLDirectiveBean@servletRequest">
	   <uix:case name="false">
	   <uix:stackLayout>
	 <uix:styledText styleClass="OraDataText" textBinding="activeSessions@HDMSQLDirectiveBean@servletRequest"/>
	 <uix:styledText styleClass="OraInlineInfoText" textBinding="VIEW_SQL_DIRECTIVE_RESPONSE_TIME_TIP@HDMMsg" />    
	   </uix:stackLayout>
	      </uix:case>
	 <uix:case name="true">
	 <uix:stackLayout>
	   <uix:textInput id="activeSessions" name="activeSessions" textBinding="activeSessions@HDMSQLDirectiveBean@servletRequest" columns="50"/>
	    <uix:styledText styleClass="OraInlineInfoText" textBinding="CREATE_SQL_DIRECTIVE_ACT_SESS_TIP@HDMMsg" />    
	   </uix:stackLayout>
                    </uix:case>
       </uix:switcher>
       </uix:cellFormat>
      </uix:rowLayout>


      <uix:rowLayout>
       <uix:cellFormat width="20%" hAlign="right">
        <uix:messagePrompt promptBinding="RESPONSE_TIME_LABEL@HDMMsg" labeledNodeId="responseTime" />
       </uix:cellFormat>
       <uix:cellFormat width="80%" hAlign="left">   
	 <uix:switcher childNameBinding="editable@HDMSQLDirectiveBean@servletRequest">
	   <uix:case name="false">
	      <uix:stackLayout>
	 <uix:styledText styleClass="OraDataText" textBinding="responseTime@HDMSQLDirectiveBean@servletRequest"/>
	      <uix:styledText styleClass="OraInlineInfoText" textBinding="VIEW_SQL_DIRECTIVE_RESPONSE_TIME_TIP@HDMMsg" />    
	   </uix:stackLayout>
	   </uix:case>
	      <uix:case name="true">
		 <uix:stackLayout>
                      <uix:textInput id="responseTime" name="responseTime" textBinding="responseTime@HDMSQLDirectiveBean@servletRequest" columns="50"/>
		 <uix:styledText styleClass="OraInlineInfoText" textBinding="CREATE_SQL_DIRECTIVE_RESPONSE_TIME_TIP@HDMMsg" />    
	   </uix:stackLayout>
                    </uix:case>
       </uix:switcher>
       </uix:cellFormat>
      </uix:rowLayout>
 

      </uix:tableLayout>
	    	<uix:tip>
	  <uix:styledText textBinding="SQL_DIRECTIVE_TIP@HDMMsg"/>
	   <uix:spacer width="10"/>

	  <uix:link textBinding="SQL_ACTIVITY_LINK@HDMMsg" destinationBinding="sqlDetailsUrl@HDMSQLDirectiveBean@servletRequest"/>    
         </uix:tip> 
	  </uix:header>

<uix:pageButtons>	 
	 <uix:switcher childNameBinding="editable@HDMSQLDirectiveBean@servletRequest">
                    <uix:case name="false">
 
<uix:pageButtonBar>
<uix:submitButton textBinding="RETURN@uixDBObjectMsg"
	          event="cancelCreateDirective"/>
</uix:pageButtonBar>
 

		    </uix:case>

	    <uix:case name="true">

<uix:pageButtonBar>
<uix:submitButton textBinding="CANCEL@uixDBObjectMsg"
	event="cancelCreateDirective"/>
<uix:switcher childNameBinding="creating@HDMSQLDirectiveBean@servletRequest">
                    <uix:case name="true">
<uix:submitButton textBinding="OK@uixDBObjectMsg"
	event="okCreateSQLDirective"/>
 </uix:case>

	    <uix:case name="false">
<uix:submitButton textBinding="OK@uixDBObjectMsg"
	event="okEditSQLDirective"/>
 </uix:case>
 </uix:switcher>
</uix:pageButtonBar>

		    </uix:case>
	 </uix:switcher>
</uix:pageButtons>
	</uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
