<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <uix:head titleBinding="HOST_CREDENTIALS@DBMsgBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
    <db:form name="foo" destinationBinding="destinationURL@servletRequest" method="post" 
        copyParams="target,type,pageNum,datasource">

    <uix:formValue name="event" value="hostLogin" />


      <uix:pageLayout titleBinding="HOST_CREDENTIALS@DBMsgBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="HOST_CREDENTIALS@DBMsgBundle@servletRequest">
            <uix:labeledFieldLayout labelWidth="10%">
              <uix:messagePrompt required="yes" labeledNodeId="sgaUser"
                      promptBinding="LOGON_USERNAME@DBMsgBundle@servletRequest"/>
              <uix:stackLayout>
                <uix:textInput name="sgaUser" id="sgaUser" noAutoComplete="true"
                     textBinding="sgaUser@hostLoginBean@servletRequest" columns="30"/>
                <uix:messageText messageType="error" messageBinding="HostUserName@errors@servletRequest"/>
              </uix:stackLayout>
              <uix:messagePrompt required="yes" labeledNodeId="sgaPasswd"
                   promptBinding="LOGON_PASSWORD@DBMsgBundle@servletRequest"/>
              <uix:stackLayout>
                <uix:textInput name="sgaPasswd" secret="true" noAutoComplete="true" id="sgaPasswd"
                    textBinding="sgaPasswd@hostLoginBean@servletRequest" columns="30"/>
                <uix:messageText messageType="error" messageBinding="HostPassword@errors@servletRequest"/>
              </uix:stackLayout>
            </uix:labeledFieldLayout>
        </uix:header>

          <uix:pageButtons>
              <uix:pageButtonBar>

                <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest" destinationBinding="cancelDestination@servletRequest"/>
                <uix:submitButton textBinding="CONTINUE@DBMsgBundle@servletRequest" formName="foo" name="event" value="hostLogin"/>

              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

