<%-- 
 * Copyright (c) 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *       initParametersPage.jsp
 *
 *      NOTES
 *       Initialization Parameters page.
 *
 * MODIFIED
 *    kmckeen    08/09/06 - Bug 5446813 - disable Execute SQL for db control
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

<%-- Message Bundles --%>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>

  <uix:document> 
   <%@ include file="/oemTitle.jspf" %>
    <uix:body>  
     <db:form name="foo" method="POST" copyParams="target,type"
      destinationBinding="controllerPath@pageBean@servletRequest">
     <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

      <uix:pageButtons>
          <uix:pageButtonBar>
	    	<uix:submitButton textBinding="LAUNCH_EXECUTE_SQL@dbMsgs"
                        renderedBinding="launchExecuteSQLRendered@pageBean@servletRequest"
        	            name="event" 
        	            value="launchExecuteSQL" />
                  <uix:submitButton textBinding="SHOWSQL@initParametersMsgBundle@servletRequest" name="event" value="showSql"/>

     <uix:switcher childNameBinding="hasPageBackURL@pageBean@servletRequest"> 
	<uix:case name="true">
                  <uix:submitButton textBinding="CANCEL@initParametersMsgBundle@servletRequest" name="event" value="revert" unvalidated="true"/>
	</uix:case>
	<uix:default>
                  <uix:submitButton textBinding="REVERT@initParametersMsgBundle@servletRequest" name="event" value="revert" unvalidated="true"/>
	</uix:default>
	</uix:switcher>
     <uix:switcher childNameBinding="hasPageBackURL@pageBean@servletRequest"> 
	<uix:case name="true">
                  <uix:submitButton textBinding="OK@initParametersMsgBundle@servletRequest" name="event" value="apply"/>
	</uix:case>
	<uix:default>
                  <uix:submitButton textBinding="APPLY@initParametersMsgBundle@servletRequest" name="event" value="apply"/>
	</uix:default>
	</uix:switcher>
           </uix:pageButtonBar>
      </uix:pageButtons>

    <uix:stackLayout>
             <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:formValue name="pageName" value="/database/instance/initparam/initParametersPage"/>

     <uix:switcher childNameBinding="connectingRole@pageBean@servletRequest"> 
     <uix:case name="normal">
     <uix:rowLayout>
     <uix:stackLayout>
            <uix:spacer height="5"/>
            <uix:messagePrompt messageType="warning" promptBinding="NOTSYSDBAMSG@initParametersMsgBundle@servletRequest"/>      
     </uix:stackLayout>
     </uix:rowLayout>
     </uix:case>
     </uix:switcher>
     
      <uix:header textBinding="INITPARAMETERSTITLE@initParametersMsgBundle@servletRequest">
      
      <uix:tableLayout width="100%">
     
     <uix:rowLayout>
     <uix:subTabLayout>      
      <uix:subTabs>
           <uix:switcher childNameBinding="useSPFile@pageBean@servletRequest">
           <uix:case name="true">
            <uix:subTabBar selectedIndexBinding="selectTabIndex@pageBean@servletRequest">
               <uix:switcher childNameBinding="paramMode@pageBean@servletRequest">
                <uix:case name="CONFIGURED">
                   <uix:link textBinding="RUNNING@initParametersMsgBundle@servletRequest" onClick="submitForm('foo', true, {event:'changeTab',value:'RUNNING'})"/>
                </uix:case>
                <uix:case name="RUNNING">
                   <uix:link textBinding="RUNNING@initParametersMsgBundle@servletRequest"/>   
                </uix:case>
               </uix:switcher>
                
               <uix:switcher childNameBinding="paramMode@pageBean@servletRequest">
                <uix:case name="RUNNING">
                   <uix:link textBinding="CONFIGURED@initParametersMsgBundle@servletRequest" onClick="submitForm('foo', true, {event:'changeTab',value:'CONFIGURED'})"/>
                </uix:case>
                <uix:case name="CONFIGURED">
                   <uix:link textBinding="CONFIGURED@initParametersMsgBundle@servletRequest"/>   
                </uix:case>
               </uix:switcher>
            </uix:subTabBar>
        </uix:case>
        </uix:switcher>
     </uix:subTabs>   

      
      <uix:tableLayout cellSpacing="5" width="100%">
      <uix:switcher childNameBinding="paramMode@pageBean@servletRequest">
        <uix:case name="RUNNING">
        <uix:rowLayout>
        <uix:cellFormat  columnSpan="3">
           <uix:styledText styleClass="OraFieldText" 
                textBinding="RUNNINGDESC@initParametersMsgBundle@servletRequest"/>
           <uix:spacer width="5"/>

           <uix:switcher childNameBinding="connectingRole@pageBean@servletRequest"
                renderedBinding="useSPFile@pageBean@servletRequest"> 
           <uix:case name="sysdba">
               <uix:styledText styleClass="OraFieldText" 
                    textBinding="CHANGESTATICMSG@initParametersMsgBundle@servletRequest"/>
           </uix:case>
           </uix:switcher>    
        </uix:cellFormat>        
        </uix:rowLayout>
        </uix:case>
        <uix:case name="CONFIGURED">
         <uix:rowLayout>
            <uix:cellFormat columnSpan="3" hAlign="left">
            <uix:styledText styleClass="OraFieldText"
                textBinding="CONFIGUREDDESC@initParametersMsgBundle@servletRequest"/>
            <uix:spacer width="5"/>
            <uix:styledText styleClass="OraInstructionTextStrong"
                textBinding="SPFile@pageBean@servletRequest"/>
            </uix:cellFormat>    
         </uix:rowLayout>
         </uix:case>
     </uix:switcher>   

    
     <uix:switcher childNameBinding="paramMode@pageBean@servletRequest">
      <uix:case name="CONFIGURED">
      <uix:rowLayout>
          <%@ include file="searchFilters.jspf" %>
      </uix:rowLayout>      
      </uix:case>
     </uix:switcher>
      
      <uix:rowLayout>
      <uix:cellFormat hAlign="left">
          <uix:switcher childNameBinding="paramMode@pageBean@servletRequest">
           <uix:case name="CONFIGURED">
                   <uix:checkBox name="applyToBothModes" 
                        checkedBinding="applyToBothModes@initParameters@pageBean@servletRequest"
                        textBinding="SPFILETORUNNINGMSG@initParametersMsgBundle@servletRequest"/>
           </uix:case>
           <uix:case name="RUNNING">
             <%@ include file="searchFilters.jspf" %>  
           </uix:case>
          </uix:switcher>
      </uix:cellFormat>
      </uix:rowLayout>
      <uix:rowLayout renderedBinding="useSPFile@pageBean@servletRequest">
      <uix:cellFormat hAlign="left">
          <uix:switcher childNameBinding="paramMode@pageBean@servletRequest">
           <uix:case name="RUNNING">
                   <uix:checkBox name="applyToBothModes" 
                        checkedBinding="applyToBothModes@initParameters@pageBean@servletRequest"
                        textBinding="RUNNINGTOSPFILEMSG@initParametersMsgBundle@servletRequest"/>
           </uix:case>
          </uix:switcher>
      </uix:cellFormat>
      </uix:rowLayout>
      
     <uix:cellFormat hAlign="right">
     <uix:tableLayout>
     <uix:rowLayout>
                  <uix:pageButtonBar>
                          <%-- save to file button --%>
                          <uix:switcher childNameBinding="isRAC@pageBean@servletRequest">
                          <uix:case name="false">
                          <uix:switcher childNameBinding="paramMode@pageBean@servletRequest">
                             <uix:case name="RUNNING">
                               <uix:submitButton textBinding="SAVE_TO_FILE@initParametersMsgBundle@servletRequest" 
                                          name="event" value="saveToFile"/>
                             </uix:case>
                          </uix:switcher>
                          </uix:case>
                          </uix:switcher>
                            
                            <%-- Show All button --%>
                            <uix:switcher childNameBinding="showAll@pageBean@servletRequest" 
                                    renderedBinding="isShowAllVisible@pageBean@servletRequest">
                            <uix:case name="true">
                                <uix:submitButton textBinding="SHOWNAVIGATION@initParametersMsgBundle@servletRequest" 
                                          name="event" value="switchShowAll"/>
                            </uix:case>
                            <uix:case name="false">
                                <uix:submitButton textBinding="SHOWALL@initParametersMsgBundle@servletRequest" 
                                          name="event" value="switchShowAll"/>
                            </uix:case>     
                            </uix:switcher>
                   </uix:pageButtonBar>
      </uix:rowLayout>
      </uix:tableLayout>
      </uix:cellFormat>
     
     </uix:tableLayout>
      
      <uix:formValue name="uniqueUIDataSourceID" valueBinding="uniqueUIDataSourceID@pageBean@servletRequest"/>
      <uix:formValue name="firstVisibleIndex" valueBinding="firstVisibleIndex@pageBean@servletRequest"/>
      
<%--
      <oem:table name="UIDataSource" beanKey="pageBean" dataSourceProp="UIDataSource" 
                      blockSizeBinding="blockSize@pageBean@servletRequest"
                      destination="initParameters" formSubmitted="true"
                      width="100%">
--%> 
     <uix:switcher childNameBinding="paramMode@pageBean@servletRequest">
      <uix:case name="CONFIGURED">
            <uix:switcher childNameBinding="showAll@pageBean@servletRequest">
              <uix:case name="true">
                  <oem:table name="UIDataSource" beanKey="pageBean" dataSourceProp="UIDataSource" 
                            formSubmitted="true"
                            blockSizeBinding="blockSize@pageBean@servletRequest"
                            alternateTextBinding="NOPARAMETESRFOUND@initParametersMsgBundle@servletRequest"
                            width="100%"
                            summaryBinding="INITPARAMETERSTITLE@initParametersMsgBundle@servletRequest"
                            >
                            <uix:tableSelection>
                               <uix:singleSelection
                                    shortDescBinding="SELECT@dbMsgs"
                                    selectedIndexBinding="selectedIndex@pageBean@servletRequest">
                                          <uix:submitButton textBinding="ADD@initParametersMsgBundle@servletRequest" 
                                                 name="event" value="addParam"
                                                 renderedBinding="isRAC@pageBean@servletRequest"/>
                                          <uix:submitButton textBinding="RESET@initParametersMsgBundle@servletRequest"
                                                 name="event" value="resetParam"/>
                               </uix:singleSelection>      
                            </uix:tableSelection> 
                  </oem:table>          
                 </uix:case>
 
                 <uix:case name="false">
                   <oem:table name="UIDataSource" beanKey="pageBean" dataSourceProp="UIDataSource" 
                            alternateTextBinding="NOPARAMETESRFOUND@initParametersMsgBundle@servletRequest"
                            blockSize="50"
                            formSubmitted="true"
                            width="100%"
                            summaryBinding="INITPARAMETERSTITLE@initParametersMsgBundle@servletRequest"
                            >
                            <uix:tableSelection>
                             <uix:singleSelection 
                               shortDescBinding="SELECT@dbMsgs"
                               selectedIndexBinding="selectedIndex@pageBean@servletRequest">
                                          <uix:submitButton textBinding="ADD@initParametersMsgBundle@servletRequest" 
                                                 name="event" value="addParam"
                                                 renderedBinding="isRAC@pageBean@servletRequest"/>
                                          <uix:submitButton textBinding="RESET@initParametersMsgBundle@servletRequest"
                                                 name="event" value="resetParam"/>
                             </uix:singleSelection>        
                            </uix:tableSelection> 
                  </oem:table>
                 </uix:case>     
             </uix:switcher>
          </uix:case>
          
          <uix:case name="RUNNING">
            <uix:switcher childNameBinding="showAll@pageBean@servletRequest">
              <uix:case name="true">
                  <oem:table name="UIDataSource" beanKey="pageBean" dataSourceProp="UIDataSource" 
                            formSubmitted="true"
                            blockSizeBinding="blockSize@pageBean@servletRequest"
                            alternateTextBinding="NOPARAMETESRFOUND@initParametersMsgBundle@servletRequest"
                            width="100%"
                            summaryBinding="INITPARAMETERSTITLE@initParametersMsgBundle@servletRequest"
                            >
                            <uix:tableSelection>
                             <uix:singleSelection 
                                shortDescBinding="SELECT@dbMsgs"
                                selectedIndexBinding="selectedIndex@pageBean@servletRequest"
                                    renderedBinding="isRacDatabaseLevel@pageBean@servletRequest">
                                        <uix:submitButton textBinding="ADD@initParametersMsgBundle@servletRequest" 
                                                 name="event" value="addParam"/>
                                        <uix:submitButton textBinding="RESET@initParametersMsgBundle@servletRequest"
                                                 name="event" value="resetParam"/>
                             </uix:singleSelection>        
                            </uix:tableSelection> 
                  </oem:table>
                 </uix:case>
 
                 <uix:case name="false">
                   <oem:table name="UIDataSource" beanKey="pageBean" dataSourceProp="UIDataSource" 
                            alternateTextBinding="NOPARAMETESRFOUND@initParametersMsgBundle@servletRequest"
                            blockSize="50"
                            formSubmitted="true"
                            width="100%"
                            summaryBinding="INITPARAMETERSTITLE@initParametersMsgBundle@servletRequest"
                            >
                            <uix:tableSelection>
                             <uix:singleSelection
                               shortDescBinding="SELECT@dbMsgs"
                               selectedIndexBinding="selectedIndex@pageBean@servletRequest"
                                    renderedBinding="isRacDatabaseLevel@pageBean@servletRequest">
                                        <uix:submitButton textBinding="ADD@initParametersMsgBundle@servletRequest" 
                                                 name="event" value="addParam"/>
                                        <uix:submitButton textBinding="RESET@initParametersMsgBundle@servletRequest"
                                                 name="event" value="resetParam"/>
                             </uix:singleSelection>        
                            </uix:tableSelection> 
                  </oem:table>
                 </uix:case>     
             </uix:switcher>
           </uix:case>
          </uix:switcher>

       <uix:tableLayout cellSpacing="5" width="100%">
       <uix:rowLayout>
    <%-- removed as of ui review -----------
      <uix:cellFormat hAlign="left">
        <uix:rowLayout>
          <uix:image sourceBinding="tipImage@servletRequest" />
          <uix:styledText styleClass="OraTipLabel" 
            textBinding="TIP@initParametersMsgBundle@servletRequest"/>
          <uix:spacer width="5" />  
          <uix:styledText styleClass="OraTipText" 
            textBinding="RESET_PARAM_TIP@initParametersMsgBundle@servletRequest"/>
        </uix:rowLayout>
      </uix:cellFormat>
    ---------------------------------------%>   
    
       <uix:cellFormat hAlign="right">
       <uix:pageButtonBar>
               <%-- Generate init.ora button --%>
              <uix:switcher childNameBinding="isRAC@pageBean@servletRequest">
              <uix:case name="false">
              <uix:switcher childNameBinding="paramMode@pageBean@servletRequest">
                 <uix:case name="RUNNING">
                  <uix:submitButton textBinding="SAVE_TO_FILE@initParametersMsgBundle@servletRequest" 
                                          name="event" value="saveToFile"/>
                 </uix:case>
              </uix:switcher>
              </uix:case>
              </uix:switcher>
                
                <%-- Show All Button --%>
                <uix:switcher childNameBinding="showAll@pageBean@servletRequest" 
                        renderedBinding="isShowAllVisible@pageBean@servletRequest">
                <uix:case name="true">
                    <uix:submitButton textBinding="SHOWNAVIGATION@initParametersMsgBundle@servletRequest" 
                              name="event" value="switchShowAll"/>
                </uix:case>
                <uix:case name="false">
                    <uix:submitButton textBinding="SHOWALL@initParametersMsgBundle@servletRequest" 
                              name="event" value="switchShowAll"/>
                </uix:case>     
                </uix:switcher>
       </uix:pageButtonBar>
       </uix:cellFormat>
      </uix:rowLayout>

      </uix:tableLayout>
      </uix:subTabLayout>
      
     </uix:rowLayout>
     </uix:tableLayout>
     <uix:switcher childNameBinding="showRelatedLinks@pageBean@servletRequest">
		  <uix:case name="true">
     <uix:header textBinding="RELATEDLINKSTITLE@initParametersMsgBundle@servletRequest">  
        <uix:stackLayout>
            <uix:link textBinding="INITPARAMCHGHISLINK@initParametersMsgBundle@servletRequest" 
                destinationBinding="initParamChangeHistoryLink@pageBean@servletRequest"/>
            <uix:link textBinding="INITPARAMHISLINK@initParametersMsgBundle@servletRequest" 
                destinationBinding="initParamHistoryLink@pageBean@servletRequest"/>
        </uix:stackLayout> 
     </uix:header>
      </uix:case>
		  </uix:switcher>
     </uix:header>    
     </uix:stackLayout>      

    </uix:pageLayout>

    <uix:formParameter name="source"/>
    <uix:formParameter name="size"/>
    <uix:formParameter name="value"/>
    <uix:formParameter name="event"/>

      <uix:formValue name="pageBackURL" valueBinding="pageBackURL@pageBean@servletRequest"/>
    </db:form>
  </uix:body>      
  </uix:document> 
</uix:renderingContext> 
