<%@ include file="/sdk/oemTop.jspf" %>
<!-- ================  Database Instance Activity Page =================== -->  

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="warning"
			      errorTableBinding="intervalWarning@servletRequest"
                  mainTextKey="exceptionText"/>

        <oem:messageBox messageType="error"
			      errorTableBinding="intervalError@servletRequest"
			      mainTextKey="exceptionText"/>

    <uix:switcher childNameBinding="refreshChoice@servletRequest">
      <uix:case name="RT_15">
        <uix:rawText>
          <meta http-equiv="Refresh" content="15" >
        </uix:rawText>
      </uix:case>
    </uix:switcher>

    <uix:form name="iaForm" destinationBinding="defaultDest@servletRequest">
    <uix:formValue name="target" valueBinding="targetName@instanceActivityBean@servletRequest"/>
    <uix:formValue name="type" valueBinding="targetType@instanceActivityBean@servletRequest"/>
    <uix:formValue name="pageNum" value="8"/>
      <%--
      <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             msgBundleBinding="defaultMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      --%>
      <uix:tableLayout width="100%">
        <uix:rowLayout hAlign="right">
          <uix:cellFormat>
            <uix:styledText styleClass="OraInstructionText"
			    labeledNodeId="view_choice"
                            textBinding="VIEW_DATA@ResourceBundle@servletRequest" />
            <uix:spacer width="5"/>
            <uix:choice name="refreshChoice"
			id="view_choice"
                        selectedValueBinding="refreshChoice@servletRequest"
                        onChange="submitForm('iaForm', true, {'event':'changeRefreshChoice','pageNum':'8'})">
              <uix:option textBinding="REAL_TIME_AUTO_15_SEC@ResourceBundle@servletRequest"
                        value="RT_15"/>
              <uix:option textBinding="REAL_TIME_MANUAL@ResourceBundle@servletRequest"
                        value="RT_MAN"/>
              <uix:option textBinding="HIST_CUSTOMIZED@ResourceBundle@servletRequest"
                        value="HIST_CUST"/>
            </uix:choice>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:switcher childNameBinding="refreshChoice@servletRequest">
          <uix:case name="RT_15">
        <uix:rowLayout hAlign="right">
          <uix:cellFormat>
            <%@ include file="../fromToTime.jspf" %>    
          </uix:cellFormat>
        </uix:rowLayout>
          </uix:case>
          <uix:case name="-1">
        <uix:rowLayout hAlign="right">
          <uix:cellFormat>
            <%@ include file="../fromToTime.jspf" %>    
          </uix:cellFormat>
        </uix:rowLayout>
          </uix:case>
        </uix:switcher>
        <uix:rowLayout>
          <uix:stackLayout>
      <uix:header textBinding="INSTANCE_ACTIVITY@ResourceBundle@servletRequest" >
       <%@ include file="/database/instances.jspf" %>

      <uix:subTabLayout>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="7">
            <uix:link textBinding="CURSORS@ResourceBundle@servletRequest"
                destinationBinding="curDest@servletRequest"/>
            <uix:link textBinding="TRANSACTION@ResourceBundle@servletRequest"
                destinationBinding="txnDest@servletRequest"/>
            <uix:link textBinding="SESSION@ResourceBundle@servletRequest"
                destinationBinding="sessDest@servletRequest"/>
            <uix:link textBinding="LOGICAL_IO@ResourceBundle@servletRequest"
                destinationBinding="logIODest@servletRequest"/>
            <uix:link textBinding="PHYSICAL_IO@ResourceBundle@servletRequest"
                destinationBinding="phyIODest@servletRequest"/>
            <uix:link textBinding="NET_IO@ResourceBundle@servletRequest"
                destinationBinding="netIODest@servletRequest"/>
            <uix:link textBinding="TABLE@ResourceBundle@servletRequest"
                destinationBinding="tableDest@servletRequest"/>
            <%--
            <uix:link textBinding="EFFICIENCY@ResourceBundle@servletRequest"
                destinationBinding="efficiencyDest@servletRequest"/>
            --%>
            <uix:link textBinding="ALL@ResourceBundle@servletRequest"
                destinationBinding="allDest@servletRequest"/>
          </uix:subTabBar>
        </uix:subTabs>

        <uix:tableLayout width="100%">
<%--
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
                  <uix:rowLayout>
                <uix:styledText styleClass="OraInlineInfoText"
                      textBinding="collectionInterval@instanceActivityBean@servletRequest"/>
                <uix:switcher childNameBinding="refreshChoice@servletRequest">
                    <uix:case name="-1">
                        <uix:image sourceBinding="refreshImage@servletRequest"
                            destinationBinding="refreshDest@servletRequest" />
                     </uix:case>
                    <uix:case name="15">
                        <uix:image sourceBinding="refreshImage@servletRequest"
                            destinationBinding="refreshDest@servletRequest" />
                     </uix:case>
                </uix:switcher>

                  </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>
          --%>
            <uix:switcher childNameBinding="refreshChoice@servletRequest">
              <uix:case name="1">
                <uix:rowLayout>
                  <uix:spacer height="10"/>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>
            <uix:switcher childNameBinding="refreshChoice@servletRequest">
              <uix:case name="1">

                <uix:rowLayout hAlign="right">
                    <uix:cellFormat rowSpan="1" hAlign="right">

                      <uix:messagePrompt promptBinding="INTERVAL_STARTS@ResourceBundle@servletRequest"
			labeledNodeId="start_date" />

                      <uix:dateField  name="startDate" columns="15"
			id="start_date"
                        valueBinding="startDate@instActTimeInterval@httpSession"
                        maxValueBinding="currentDate@instActTimeInterval@httpSession"/>

                      <oem:choice name="startTime"
			shortDescBinding="INTERVAL_STARTS@ResourceBundle@servletRequest"
                        selectedValueBinding="startTime@instActTimeInterval@httpSession"
                        optionsBinding="timeValues@instActTimeInterval@httpSession"  />

                      <uix:messagePrompt promptBinding="INTERVAL_ENDS@ResourceBundle@servletRequest"
			labeledNodeId="end_date" />


                      <uix:dateField  name="endDate" columns="15"
			id="end_date"
                        maxValueBinding="currentDate@instActTimeInterval@httpSession"
                        valueBinding="endDate@instActTimeInterval@httpSession"/>

                      <oem:choice name="endTime"
			shortDescBinding="INTERVAL_ENDS@ResourceBundle@servletRequest"
                        selectedValueBinding="endTime@instActTimeInterval@httpSession"
                        optionsBinding="timeValues@instActTimeInterval@httpSession"  />

                      <uix:submitButton textBinding="GO@ResourceBundle@servletRequest" name="event" value="changeRefreshChoice" />
                      </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

<%--
          <uix:rowLayout>
            <uix:rowLayout hAlign="right">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraInstructionText"
                            textBinding="STAT_CATEGORY@ResourceBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="5"/>
              <uix:cellFormat>
                <oem:choice name="categoryChoice" onChange="submitForm('iaForm', true, {'event':'changeCategory'})"
                            optionsBinding="categoryNames@instanceActivityBean@servletRequest"
                            selectedValueBinding="selectedCategory@instanceActivityBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:rowLayout>
          <uix:rowLayout width="100%">
            <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
                       formSubmitted="true"
                      dataSourceProp="twoDUIDataSource" width="100%"
                      alternateTextBinding="SYS_STAT_UNAVAILABLE@ResourceBundle@servletRequest"
                      partialRenderMode="self">
            </oem:table>
          </uix:rowLayout>
          --%>
          <uix:rowLayout width="100%">
        <uix:switcher childNameBinding="node@instanceActivityBean@servletRequest">
          <uix:case name="okNode">
            <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
		      summaryBinding="ALL_SESS_LINK@ResourceBundle@servletRequest"
                      blockSize="25" formSubmitted="true"
                      dataSourceProp="twoDUIDataSource" width="100%"
                      alternateTextBinding="SYS_STAT_UNAVAILABLE@ResourceBundle@servletRequest"
                      partialRenderMode="self">
            </oem:table>
        </uix:case>
        </uix:switcher>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:subTabLayout>
      </uix:header>
          </uix:stackLayout>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:spacer height="15" />

      <%@ include file="/database/instance/monitoringLinks.jspf" %>

    </uix:form>
    </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

