<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="warning"
          errorTableBinding="intervalWarning@servletRequest"
          mainTextKey="exceptionText"/>

        <oem:messageBox messageType="error"
          errorTableBinding="intervalError@servletRequest"
          mainTextKey="exceptionText"/>

        <uix:switcher childNameBinding="needHttpRefresh@servletRequest">
          <uix:case name="yes">
            <uix:rawText>
              <meta http-equiv="Refresh" content="15" >
            </uix:rawText>
          </uix:case>
        </uix:switcher>

        <uix:form name="iaForm" method="get" destinationBinding="defaultDest@servletRequest">
          <uix:formValue name="target" valueBinding="targetName@instanceActivityBean@servletRequest"/>
          <uix:formValue name="type"valueBinding="targetType@instanceActivityBean@servletRequest"/>
          <uix:formValue name="event"/>
          <uix:formValue name="pageNum" valueBinding="pageNum@instanceActivityBean@servletRequest"/>

          <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat>
                <uix:styledText styleClass="OraInstructionText"
                  labeledNodeId="view_choice"
                  textBinding="VIEW_DATA@ResourceBundle@servletRequest" />
                <uix:spacer width="5"/>
                <uix:choice name="refreshChoice"
                  id="view_choice"
                  onChange="submitForm('iaForm', true, {'event':'changeRefreshChoice'})"
                  selectedValueBinding="refreshChoice@servletRequest">
                  <uix:option textBinding="REAL_TIME_AUTO_15_SEC@ResourceBundle@servletRequest"
                    value="RT_15"/>
                  <uix:option textBinding="REAL_TIME_MANUAL@ResourceBundle@servletRequest"
                    value="RT_MAN"/>
                  <uix:option textBinding="HIST_CUSTOMIZED@ResourceBundle@servletRequest"
                    value="HIST_CUST"/>
                </uix:choice>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:switcher childNameBinding="refreshChoice@servletRequest">
              <uix:case name="RT_15">
                <uix:switcher childNameBinding="formatChoice@instanceActivityBean@servletRequest">
                  <uix:case name="1">
                    <uix:rowLayout hAlign="right">
                      <%@ include file="../fromToTime.jspf" %>
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>
              </uix:case>
              <uix:case name="RT_MAN">
                <uix:rowLayout hAlign="right">
                  <%@ include file="../fromToTime.jspf" %>
                </uix:rowLayout>
              </uix:case>
              <uix:case name="HIST_CUST">
                <uix:switcher childNameBinding="formatChoice@instanceActivityBean@servletRequest">
                  <uix:case name="1">
                    <uix:rowLayout hAlign="right">
                      <%@ include file="../fromToTime.jspf" %>
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>
              </uix:case>
            </uix:switcher>
          </uix:tableLayout>

          <uix:header textBinding="INSTANCE_ACTIVITY@ResourceBundle@servletRequest" >
            <%@ include file="/database/instances.jspf" %>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndexBinding="tabIndex@instanceActivityBean@servletRequest">
                  <uix:link textBinding="CURSORS@ResourceBundle@servletRequest"
                    destinationBinding="curDest@servletRequest"/>
                  <uix:link textBinding="TRANSACTION@ResourceBundle@servletRequest"
                    destinationBinding="txnDest@servletRequest"/>
                  <uix:link textBinding="SESSION@ResourceBundle@servletRequest"
                    destinationBinding="sessDest@servletRequest"/>
                  <uix:link textBinding="LOGICAL_IO@ResourceBundle@servletRequest"
                    destinationBinding="logIODest@servletRequest"/>
                  <uix:link textBinding="PHYSICAL_IO@ResourceBundle@servletRequest"
                    destinationBinding="phyIODest@servletRequest"/>
                  <uix:link textBinding="NET_IO@ResourceBundle@servletRequest"
                    destinationBinding="netIODest@servletRequest"/>
                  <uix:link textBinding="TABLE@ResourceBundle@servletRequest"
                    destinationBinding="tableDest@servletRequest"/>
                  <uix:link textBinding="ALL@ResourceBundle@servletRequest"
                    destinationBinding="allDest@servletRequest"/>
                </uix:subTabBar>
              </uix:subTabs>

              <uix:tableLayout width="100%">
                <uix:switcher childNameBinding="refreshChoice@servletRequest">
                  <uix:case name="HIST_CUST">
                    <uix:rowLayout>
                      <uix:spacer height="10"/>
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="refreshChoice@servletRequest">
                  <uix:case name="HIST_CUST">

                    <uix:rowLayout hAlign="right">
                      <uix:cellFormat rowSpan="1" hAlign="right">
                        <uix:messagePrompt promptBinding="INTERVAL_STARTS@ResourceBundle@servletRequest"
                          labeledNodeId="start_date"/>
                        <uix:dateField  name="startDate" columns="15"
                          id="start_date"
                          valueBinding="startDate@instActTimeInterval@httpSession"
                          maxValueBinding="currentDate@instActTimeInterval@httpSession"/>
                        <oem:choice name="startTime"
                          shortDescBinding="INTERVAL_STARTS@ResourceBundle@servletRequest"
                          selectedValueBinding="startTime@instActTimeInterval@httpSession"
                          optionsBinding="timeValues@instActTimeInterval@httpSession"  />
                        <uix:messagePrompt promptBinding="INTERVAL_ENDS@ResourceBundle@servletRequest"
                          labeledNodeId="end_date" />
                        <uix:dateField  name="endDate" columns="15"
                          id="end_date"
                          maxValueBinding="currentDate@instActTimeInterval@httpSession"
                          valueBinding="endDate@instActTimeInterval@httpSession"/>
                        <oem:choice name="endTime"
                          shortDescBinding="INTERVAL_ENDS@ResourceBundle@servletRequest"
                          selectedValueBinding="endTime@instActTimeInterval@httpSession"
                          optionsBinding="timeValues@instActTimeInterval@httpSession"  />
                        <uix:submitButton textBinding="GO@ResourceBundle@servletRequest"
                          name="event" value="changeRefreshChoice" />
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>

                <uix:switcher childNameBinding="node@instanceActivityBean@servletRequest">
                  <uix:case name="okNode">

                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:tableLayout width="100%">
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="left">
                              <uix:contents childDataBinding="formatChoices@instanceActivityBean@servletRequest">
                                <uix:radioButton name="formatChoice"
                                  textBinding="text"
                                  valueBinding="val"
                                  onClick="submitForm('iaForm', true, {'event':'doLoad'})"
                                  selectedValueBinding="formatChoice@instanceActivityBean@servletRequest" />
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:switcher childNameBinding="formatChoice@instanceActivityBean@servletRequest">
                              <uix:case name="0">
                                <uix:cellFormat hAlign="right">
                                  <uix:styledText styleClass="OraInstructionText"
                                    labeledNodeId="rate_choice"
                                    textBinding="METRIC_RATE@ResourceBundle@servletRequest" />
                                  <uix:choice name="rateType"
                                    id="rate_choice"
                                    selectedValueBinding="rateType@instanceActivityBean@servletRequest"
                                    onChange="submitForm('iaForm', true, {'event':'changeRateType'})">
                                    <uix:option textBinding="SP_PER_SECOND@ResourceBundle@servletRequest"
                                      value="0"/>
                                    <uix:option textBinding="SP_PER_TRANSACTION@ResourceBundle@servletRequest"
                                      value="1"/>
                                  </uix:choice>
                                </uix:cellFormat>
                              </uix:case>
                            </uix:switcher>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>

                  </uix:case>
                </uix:switcher>

              </uix:tableLayout>

              <uix:switcher childNameBinding="node@instanceActivityBean@servletRequest">
                <uix:case name="okNode">

                  <uix:switcher childNameBinding="formatChoice@instanceActivityBean@servletRequest">
                    <uix:case name="0">
                      <uix:switcher childNameBinding="useSVG@instanceActivityBean@servletRequest">
                        <uix:case name="false">
                          <oem:chart
                            chartType="timeSeriesChart"
                            width="1000"
                            height="300"
                            timeGranularity="SECOND"
                            orientation="vertical"
                            legendPosition="south"
                            fill="none"
                            titleBinding="chartTitle@instanceActivityBean@servletRequest"
                            titleVisible="false">
                            <uix:contents>
                              <oem:boundChartDataSource
                                chartDataSourceBinding="sysstatChartGIF@instanceActivityBean@servletRequest"/>
                              <oem:imageMap imageMapDataSourceBinding="systatImageDataSource@servletRequest"/>
                              <oem:chartColumn
                                isKey="true"
                                displayLabel=""
                                sourceIndex="0" />
                              <oem:chartColumn
                                isTimeColumn="true"
                                displayLabel="Time"
                                sourceIndex="1"  />
                              <oem:chartColumn
                                displayLabel=""
                                sourceIndex="2" />
                            </uix:contents>
                          </oem:chart>
                        </uix:case>
                        <uix:case name="true">
                          <db:lineGraph dataSrcKey="sysstatChart"
                            windowWidth="1000"
                            windowHeight="300"
                            stacked="false" legendColumnsBinding="legendColumns@instanceActivityBean@servletRequest"
                            updateIntervalBinding="svgUpdateInterval@servletRequest"
                            viewportWidth="100%" viewportHeight="50%" />
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                    <uix:case name="1">
                      <uix:switcher childNameBinding="node@instanceActivityBean@servletRequest">
                        <uix:case name="okNode">
                          <oem:table name="twoDUIDataSource" beanKey="dataSourceBean"
			    summaryBinding="ALL_SESS_LINK@ResourceBundle@servletRequest"
                            formSubmitted="true"
                            dataSourceProp="twoDUIDataSource" width="100%"
                            alternateTextBinding="SYS_STAT_UNAVAILABLE@ResourceBundle@servletRequest"
                            blockSize="25" partialRenderMode="self">
                          </oem:table>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                  </uix:switcher>

                </uix:case>
              </uix:switcher>

            </uix:subTabLayout>
          </uix:header>

         <uix:spacer height="15" />

         <%@ include file="/database/instance/monitoringLinks.jspf" %>

        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

