<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>



<script>

 function scroll_timechart(direction)
 {
   if (direction == 'prev'){
     document.foo.direction.value = '1';
   }
   else{
     document.foo.direction.value = '2';
   }
   submitForm('foo', true, {'event':'scrollChart'});
 }

 function do_nothing(a, b, c)
 {
 }

</script>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest">
        <%-- only need refresh if automatic refresh selected and not using SVG --%> 
        <uix:switcher childNameBinding="manualSelected@servletRequest">
          <uix:case name="false">
            <uix:rawText>
              <meta http-equiv="Cache-Control" content="max-age=0">
              <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoiceGIF") %>">
            </uix:rawText> 
          </uix:case>  
        </uix:switcher>
      </uix:head>
    </uix:metaContainer>


    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

    <db:form name="foo" method="GET" destination="/console/database/instance/ioDrilldown"
      copyParams="target,type,function,rateType">

     <uix:formValue name="direction" value=""/>
     <uix:formValue name="selectedBand" value=""/>
     <uix:formValue name="event" />  


    <uix:header textBinding="header@defaultBean@servletRequest">


          <uix:tableLayout width="100%" >
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" vAlign="center">
                <uix:messagePrompt promptBinding="IO_DETAILS_INSTR@DBMsgBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat hAlign="right" vAlign="center">

                  <uix:styledText styleClass="OraFieldText" 
                    textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                    labeledNodeId="ViewLabel" />

                  <uix:choice name="refreshChoice" id="ViewLabel"
                      onChange="submitForm('foo', true, {'event':'doLoad','pageNum':'2'})"
                       selectedValueBinding="refreshChoiceSelected@servletRequest">
                    <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                      value="RT_15"/>
                    <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                      value="RT_MAN"/>
                    <uix:option textBinding="HISTORICAL@DBMsgBundle@servletRequest"
                      value="HIST_CUST"/>  
                  </uix:choice>          

              </uix:cellFormat>
              
            </uix:rowLayout>
          </uix:tableLayout>


















    <uix:tableLayout width="100%" cellSpacing="2">
 
   <uix:rowLayout vAlign="top" renderedBinding="realTime@defaultBean@servletRequest">

    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="250"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="masterHeader@defaultBean@servletRequest"
        titleVisible="false"         
        yAxisLabelBinding="masterYAxisLabel@defaultBean@servletRequest"
        yAxisWidth="50"
        colorPaletteBinding="colors@defaultBean@servletRequest"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="masterGIF@defaultBean@servletRequest"/>
         
        <oem:imageMap imageMapDataSourceBinding="ioImageMap@defaultBean@servletRequest"/>

        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>

    </uix:rowLayout>




   <uix:rowLayout vAlign="top" renderedBinding="historical@defaultBean@servletRequest">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="250"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="masterHeader@defaultBean@servletRequest"
        titleVisible="true"         
        yAxisLabelBinding="masterYAxisLabel@defaultBean@servletRequest"
        yAxisWidth="50"
        xAxisMinBinding="beginDate@defaultBean@servletRequest"
        xAxisMaxBinding="endDate@defaultBean@servletRequest"
        colorPaletteBinding="colors@defaultBean@servletRequest"
    >
      <uix:contents>
      <oem:timeSelector
        intervalTimeSec="3600"
        height="20"
        position="south"
        xAxisMinBinding="beginDate@defaultBean@servletRequest"
        xAxisMaxBinding="endDate@defaultBean@servletRequest"
        showBorder="false"
        dynamicTimeSelector="true"
        selectionDestType="JavaScript"
        selectionDest="do_nothing"
        xAxisScrollDest="scroll_timechart"
        xAxisScrollDestType="JavaScript"
        xAxisScrollPrev="true"
        xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsgBundle@servletRequest" 
        xAxisScrollNext="true"
        xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsgBundle@servletRequest" >
      </oem:timeSelector>

        <oem:boundChartDataSource 
          chartDataSourceBinding="masterGIF@defaultBean@servletRequest"/>
         
        <oem:imageMap imageMapDataSourceBinding="ioImageMap@defaultBean@servletRequest"/>

        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>
    </uix:rowLayout>



    <uix:rowLayout vAlign="top">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="200"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="throughputHeader@defaultBean@servletRequest"
        titleVisible="true"         
        yAxisLabelBinding="MB_PER_SECOND@DBMsgBundle@servletRequest"
        yAxisWidth="50"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="throughputGIF@defaultBean@servletRequest"/>
        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>

    </uix:rowLayout>
    <uix:rowLayout vAlign="top">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="200"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="cumulative"
        titleBinding="rateHeader@defaultBean@servletRequest"
        titleVisible="true"         
        yAxisLabelBinding="IO_PER_SECOND@DBMsgBundle@servletRequest"
        yAxisWidth="50"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="rateGIF@defaultBean@servletRequest"/>
        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>



    </uix:rowLayout>
    <uix:rowLayout vAlign="top">
    <oem:chart 
        chartType="timeSeriesChart"
        width="800"
        height="200"
        timeGranularity="SECOND"
        orientation="vertical"
        legendPosition="east" 
        legendVisible="external"
        fill="none"
        titleBinding="latencyHeader@defaultBean@servletRequest"
        titleVisible="true"         
        yAxisLabelBinding="MS@DBMsgBundle@servletRequest"
        yAxisWidth="50"
    >
      <uix:contents>
        <oem:boundChartDataSource 
          chartDataSourceBinding="latencyGIF@defaultBean@servletRequest"/>
        <oem:chartColumn                                   
            isKey="true" 
            displayLabel=""
            sourceIndex="0" />
        <oem:chartColumn
            isTimeColumn="true"
            displayLabel="Time"
            sourceIndex="1"  />
        <oem:chartColumn                                   
            displayLabel=""
            sourceIndex="2" />
      </uix:contents>
    </oem:chart>



    </uix:rowLayout>                      
    </uix:tableLayout>
    </uix:header>


    </db:form>    
    </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>

