<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 


  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %> 
        
        <db:form name="foo" method="post" destinationBinding="destURL@request"
          copyParams="target,type"> 

        <uix:formValue name="event" />
        
          <uix:contents>
      <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             msgBundleBinding="ResourceBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
         errorTableBinding="errors@servletRequest"
         titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:header textBinding="pageHeader@lockBean@servletRequest" >
              
              <%@ include file="../refreshTime.jspf" %>

              <uix:tableLayout width="100%" >
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat>
                    <uix:flowLayout>
                      <uix:styledText styleClass="OraInstructionText"
                                      labeledNodeId="viewById"
                                      textBinding="VIEW_DETAIL@DBMsgBundle@servletRequest" />
                      <uix:choice name="viewBy" id="viewById"
                                  onChange="submitForm('foo', true, {'event':'switch'})" >
                        <uix:option textBinding="BLOCKING_LOCKS@DBMsgBundle@servletRequest"
                                    value="blockingLocks"/>
                        <uix:option textBinding="USER_LOCKS@DBMsgBundle@servletRequest"
                                    value="userLocks" selectedBinding="userLocksSelected@servletRequest"/>
                        <uix:option textBinding="ALL_LOCKS@DBMsgBundle@servletRequest"
                                    renderedBinding="showInstName@lockBean@servletRequest"
                                    value="allLocks" selectedBinding="allLocksSelected@servletRequest"/>
                        <uix:option textBinding="ALL_INSTANCE_LOCKS@DBMsgBundle@servletRequest"
                                    renderedBinding="isInstanceLevel@lockBean@servletRequest"
                                    value="allLocks" selectedBinding="allLocksSelected@servletRequest"/>
                      
                      </uix:choice>
                    </uix:flowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:stackLayout renderedBinding="allLocksSelected@servletRequest" >
                <uix:spacer height="10" />
                <uix:checkBox name="showMR" onClick="submitForm('foo', true, {'event':'doLoad'})"
                              textBinding="SHOW_MR_LOCKS@DBMsgBundle@servletRequest"
                              selectedValueBinding="showMR@servletRequest"                             
                              value="on" />
                <uix:spacer height="10" />             
              </uix:stackLayout>                  

              
              <uix:hGrid id="locks"
                         width="100%"
                         alternateTextBinding="NO_LOCKS@DBMsgBundle@servletRequest"
                         destinationBinding="destURI@servletRequest"
                         columnHeaderDataBinding="columnHeaderData@lockBean@servletRequest"
                         columnFormatsBinding="columnFormatData@lockBean@servletRequest"
                         treeDataBinding="treeData@lockBean@servletRequest"
                         formSubmitted="true"
                         summaryBinding="pageHeader@lockBean@servletRequest"
                         proxyBinding="proxy@servletRequest">
                <uix:nodeStamp>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="LOCK_USERNAME@DBMsgBundle@servletRequest"/>
                    </uix:columnHeader>

                    <uix:rowLayout>
                      
                      <uix:image sourceBinding="iconText" />
                      <uix:spacer width="5" />
                      <uix:styledText textBinding="username"
                                      styleClass="OraFieldText" />
                      
                    </uix:rowLayout>
                    
                  </uix:column>
                </uix:nodeStamp>

                <uix:tableSelection>
                  <uix:singleSelection selectedIndex="1"
                                       shortDescBinding="SELECT@DBMsgBundle@servletRequest"
                                       disabledBinding="disabled">

                    <uix:rowLayout>
                      <uix:submitButton name="event" value="killSession"  
                                        textBinding="KILL_SESSION@DBMsgBundle@servletRequest"/>                                           
                      <uix:submitButton name="event" value="vsession"
                                        textBinding="database/instance/sessionDetails@DBMsgBundle@servletRequest"/> 
                      <uix:submitButton name="event" value="viewObject"
                                        textBinding="VIEW_OBJECT@DBMsgBundle@servletRequest"/> 
                      <uix:switcher childNameBinding="is10iOrHigher@lockBean@servletRequest">
                        <uix:case name="false">
                          <uix:submitButton name="event" value="viewSqlDetail"
                                        textBinding="VIEW_SQL_STMT@DBMsgBundle@servletRequest"/> 
                        </uix:case>
                      </uix:switcher>
                    </uix:rowLayout>  

                  </uix:singleSelection>
                </uix:tableSelection>

                
                
                
                <uix:columnHeaderStamp>
                  <uix:text textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:styledText textBinding="numBlocked"/>
                <uix:styledText textBinding="instname" 
                                renderedBinding="showInstName@servletRequest"/>
                <uix:styledText textBinding="sid"
                                destinationBinding="sidURL"/>
                <uix:styledText textBinding="serialNumber"/>
                <uix:styledText textBinding="serverPID"/>
                <uix:styledText textBinding="sqlHash"
                                destinationBinding="sqlDetailURL"/>
                <uix:styledText textBinding="lockType"/>
                <uix:styledText textBinding="modeHeld"/>
                <uix:styledText textBinding="modeRequested"/>
                <uix:styledText textBinding="objectType"/>
                <uix:styledText textBinding="objectOwner"/>
                <uix:styledText textBinding="objectName"
                                destinationBinding="objURL"/>
                <uix:styledText textBinding="waitRowId"/> 


                <%--    <uix:styledText textBinding="id1"/>
                  <uix:styledText textBinding="id2"/>  --%>
                <uix:styledText textBinding="ctime"/> 

                <uix:formValue name="uniqueID" valueBinding="uid" />
                
              </uix:hGrid>

              <uix:cellFormat hAlign="left">
                <uix:rowLayout>
                  <uix:image sourceBinding="tipImage@servletRequest" />
                  <uix:styledText styleClass="OraTipLabel" 
                                  textBinding="TIP@DBMsgBundle@servletRequest"/>
                  <uix:spacer width="5" />  
                  <uix:styledText styleClass="OraTipText" 
                                  textBinding="LOCK_TIP@DBMsgBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:cellFormat>

            </uix:header>
          </uix:contents>

         <uix:spacer height="15" />

          <uix:switcher childNameBinding="showInstName@servletRequest">
            <uix:case name="false">
              <uix:stackLayout>
                <%@ include file="/database/instance/monitoringLinks.jspf" %>
              </uix:stackLayout>
            </uix:case>
          </uix:switcher>

        </db:form>
    </uix:pageLayout>
  </uix:body>
</uix:document>
</uix:renderingContext> 
