<%@ include file="/sdk/oemTop.jspf" %> 
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
 <uix:document>
  <%@ include file="/oemTitle.jspf" %>
  <uix:body>
    <db:form name="foo" method="post" destination="/console/database/instance/memory"
		copyParams="target,type">
    <uix:formValue name="pageName" value="/database/instance/memory/enableMemoryTargetAutoTuning.jsp"/>

    <uix:pageLayout titleBinding="ENABLEAUTOMEMORYTARGET@memoryMsgBundle@servletRequest">
    
      <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      <uix:pageStatus>
            <uix:styledText styleClass="oraFieldText" 
                    textBinding="enableAutoMemoryManagementDesc@memObj@pageBean@servletRequest"/>
      </uix:pageStatus>
      <uix:spacer width="15"/>

      <uix:tableLayout cellSpacing="5">
        <uix:rowLayout>
          <uix:contents>
            <uix:cellFormat hAlign="right">
              <uix:styledText styleClass="oraFieldText" textBinding="CURRENT_MEMORY_USAGE@memoryMsgBundle@servletRequest"/>
              <uix:styledText styleClass="oraFieldText" text=" ("/>
              <uix:styledText styleClass="oraFieldText" textBinding="memoryTargetUnit@memObj@pageBean@servletRequest"/>
              <uix:styledText styleClass="oraFieldText" text=")"/>
            </uix:cellFormat>            
            <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="currentMemoryUsage@memObj@pageBean@servletRequest"/>
            </uix:cellFormat>
          </uix:contents>      
        </uix:rowLayout>
        
        <uix:rowLayout>
            <uix:contents>
                <uix:cellFormat hAlign="right">
                    <%--uix:styledText styleClass="OraInlineInfoText" 
                        textBinding="STATICPARAMTOKEN@memoryMsgBundle@servletRequest"
                        renderedBinding="memoryMaxTargetStatic@memObj@pageBean@servletRequest"/--%>    
                    <uix:styledText labeledNodeId="memoryMaxTarget"
                        styleClass="oraFieldText" textBinding="MAXMOMORYSIZE@memoryMsgBundle@servletRequest"/>    
                </uix:cellFormat>    
                <uix:cellFormat hAlign="left">
                    <uix:textInput name="memoryMaxTarget"
                        id="memoryMaxTarget"
                        columns="10"
                        disabledBinding="memoryMaxTargetReadOnly@memObj@pageBean@servletRequest"
                        textBinding="memoryMaxTarget@memObj@pageBean@servletRequest"/>
                    <uix:choice name="memoryMaxTargetUnit"                         
                        disabledBinding="memoryMaxTargetReadOnly@memObj@pageBean@servletRequest"
                        selectedValueBinding="memoryMaxTargetUnit@memObj@pageBean@servletRequest">
                       <%-- shortDescBinding="MAX_MEMORY_SIZE_UNIT@memoryMsgBundle@servletRequest" --%>
                       <%-- need to uncomment above message after the msg file can be changed --%>
                        <uix:option text="MB" value="MB"/>    
                        <uix:option text="GB" value="GB"/>                
                    </uix:choice>
                    <uix:messageText messageType="error" messageBinding="memoryMaxTarget@msgBox@servletRequest"/>
                </uix:cellFormat>
            </uix:contents>      
        </uix:rowLayout>
        <uix:switcher childNameBinding="userName@pageBean@servletRequest"> 
            <uix:case name="SYS">
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                        <uix:contents>
                            <uix:styledText styleClass="OraInlineInfoText" textBinding="ENABLE_AUTO_MEMORY_PAGE_MAX_MEMORY_SIZE_HINT@memoryMsgBundle@servletRequest"/>
                        </uix:contents>
                    </uix:cellFormat>
                </uix:rowLayout>
            </uix:case>
        </uix:switcher>
        
        <uix:rowLayout>          
          <uix:cellFormat hAlign="right">
            <uix:contents>
              <uix:styledText labeledNodeId="memoryTarget"
                  styleClass="oraFieldText" textBinding="AUTOTUNEMEMORYTARGETTEXT@memoryMsgBundle@servletRequest"/>  
            </uix:contents>
          </uix:cellFormat>

            <uix:cellFormat hAlign="left">
                <uix:textInput name="memoryTarget" id="memoryTarget" columns="10"
                    disabledBinding="memoryTargetReadOnly@memObj@pageBean@servletRequest"
                    textBinding="currentMemoryUsage@memObj@pageBean@servletRequest"/>
                <uix:choice name="memoryTargetUnit"                         
                    disabledBinding="memoryTargetReadOnly@memObj@pageBean@servletRequest"
                    shortDescBinding="TOTAL_MEMORY_SIZE_UNIT@memoryMsgBundle@servletRequest"
                    selectedValueBinding="memoryTargetUnit@memObj@pageBean@servletRequest">
                    <uix:option text="MB" value="MB"/>    
                    <uix:option text="GB" value="GB"/>                
                </uix:choice>
                <uix:messageText messageType="error" messageBinding="memoryTarget@msgBox@servletRequest"/>
            </uix:cellFormat>

        </uix:rowLayout>
      </uix:tableLayout>


      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:submitButton name="event" 
                textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                value="cancelEnableMemoryTargetAutoTuning" />  
          <uix:submitButton name="event" 
                textBinding="OK@uixDBObjectBundle@servletRequest"
                value="okEnableMemoryTargetAutoTuning" />  
        </uix:pageButtonBar>
      </uix:pageButtons>

    </uix:pageLayout>
   </db:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>
