<%@ include file="/sdk/oemTop.jspf" %> 
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
 <uix:document>
  <%@ include file="/oemTitle.jspf" %>
<%--
  <uix:metaContainer>
   <uix:head titleBinding="title@objectBean@servletRequest"/>	
  </uix:metaContainer>
--%>
  <uix:body>
    <db:form name="foo" method="post" destination="/console/database/instance/memory"
		copyParams="target,type">
    <uix:formValue name="pageName" value="/database/instance/memory/enableSGAAutoTuning.jsp"/>

    <uix:pageLayout titleBinding="ENABLEAUTOSGA@memoryMsgBundle@servletRequest">
    
      <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
<%--
    <oem:messageBox messageType="confirmation"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>      
--%>
      <uix:pageStatus>
        <uix:styledText styleClass="oraFieldText" 
          textBinding="SGAAUTOTUNETEXT@memoryMsgBundle@servletRequest"/>
      </uix:pageStatus>
      <uix:spacer width="15"/>

      <uix:tableLayout cellSpacing="5">
        <uix:rowLayout>
          <uix:contents>
            <uix:cellFormat hAlign="right">
              <uix:styledText styleClass="oraFieldText" textBinding="CURRENTSGASIZE@memoryMsgBundle@servletRequest"/>
              <uix:styledText styleClass="oraFieldText" text=" ("/>
              <uix:styledText styleClass="oraFieldText" textBinding="totalSGASizeUnit@memObj@pageBean@servletRequest"/>
              <uix:styledText styleClass="oraFieldText" text=")"/>
            </uix:cellFormat>

            <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="totalSGASize@memObj@pageBean@servletRequest"/>
            </uix:cellFormat>

          </uix:contents>      
        </uix:rowLayout>
        <uix:rowLayout>          
          <uix:cellFormat hAlign="right">
            <uix:contents>
              <uix:styledText labeledNodeId="SGATargetSize"
                  styleClass="oraFieldText" textBinding="AUTOTUNESGASIZETEXT@memoryMsgBundle@servletRequest"/>  
            </uix:contents>
          </uix:cellFormat>

          <uix:cellFormat hAlign="left">
            <uix:stackLayout>
              <uix:contents>
                <uix:textInput name="SGATargetSize" id="SGATargetSize" columns="10"
                    disabledBinding="isSGATargetSizeReadOnly@memObj@pageBean@servletRequest"
                    textBinding="totalSGASize@memObj@pageBean@servletRequest"/>
                <uix:messageText messageType="error" messageBinding="SGATargetSize@msgBox@servletRequest"/>
              </uix:contents>
            </uix:stackLayout>
          </uix:cellFormat>

          <uix:cellFormat hAlign="left">
            <uix:contents>
              <uix:choice name="SGATargetSizeUnit"                         
                  shortDescBinding="TOTAL_SGA_SIZE_UNIT@memoryMsgBundle@servletRequest"
                  selectedValueBinding="SGATargetSizeUnit@memObj@pageBean@servletRequest">
                <uix:option text="MB" value="MB"/>    
                <uix:option text="GB" value="GB"/>
                
              </uix:choice>
            </uix:contents>
          </uix:cellFormat>              
        </uix:rowLayout>
      </uix:tableLayout>


      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:submitButton name="event" 
                textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                value="cancelEnableAutoTuning" />  
          <uix:submitButton name="event" 
                textBinding="OK@uixDBObjectBundle@servletRequest"
                value="okEnableAutoTuning" />  
        </uix:pageButtonBar>
      </uix:pageButtons>

    </uix:pageLayout>
   </db:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>
