<%-- 
 * Copyright (c) 2006, 2007, Oracle. All rights reserved.  
 *
 * MODIFIED
 *    misun      01/19/07 - fix Memory Advisor UI Review bugs
 *    misun      01/05/07 - XbranchMerge misun_bug-5675432 from main
 *    kmckeen    08/30/06 - Disable Execute On Multiple Databases button for db control
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:document> 
      <script>
      function myCallBack(lovwin, event)
      {
      }
      </script>

    <%@ include file="/oemTitle.jspf" %>         

    <uix:head>

      <script>
      function doLoad()
      {
	var isNav = (navigator.appName.indexOf("Netscape") != -1);
	if (isNav)
	{
            document.captureEvents(Event.CLICK);
	}

        var isPGAAdvice = document.getElementById('showAdvicePGA');
        if (isPGAAdvice!=null && isPGAAdvice!="undefined")
        {
                   document.getElementById('showAdvicePGA').onclick=openPopup;
        }
        
        var isMemoryTargetAdvice = document.getElementById('showAdviceMemoryTarget');
        if (isMemoryTargetAdvice!=null && isMemoryTargetAdvice!="undefined")
        {
                   document.getElementById('showAdviceMemoryTarget').onclick=openPopupMemoryTarget;
        }
        
        return true;
      }
        function openPopup()
        {
                eval(document.getElementById('showAdvicePGA1').value);
        }

        function openPopupMemoryTarget()
        {
                eval(document.getElementById('showAdviceMemoryTargetl').value);
        }

      </script>
    </uix:head>
    <uix:body onLoad="doLoad();">  
    <db:form name="foo" method="POST" destination="/console/database/instance/memory"
             copyParams="target,type">
     <uix:pageLayout>
     <%@ include file="/database/global.jspf" %>  
             <uix:contentFooter>
                  <uix:pageButtonBar>
                     <uix:contents>
	    		<uix:submitButton textBinding="LAUNCH_EXECUTE_SQL@dbMsgs"
        	            name="event" 
        	            value="launchExecuteSQL" 
                        renderedBinding="launchExecuteSQLRendered@memObj@pageBean@servletRequest"/>
                          <uix:submitButton textBinding="SHOWSQL@memoryMsgBundle@servletRequest" name="event" value="showSql"/>
                          <uix:submitButton textBinding="REVERT@memoryMsgBundle@servletRequest" name="event" value="revert" unvalidated="true"/>
                          <uix:submitButton textBinding="APPLY@memoryMsgBundle@servletRequest" name="event" value="apply"/>
                     </uix:contents>
                   </uix:pageButtonBar>
              </uix:contentFooter>

    
    <uix:stackLayout>
    <uix:contents>

             <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:formValue name="pageName" value="/database/instance/memory/memoryPage9AutoAdvice.jsp"/>

     <uix:switcher childNameBinding="connectingRole@pageBean@servletRequest"> 
     <uix:case name="normal">
     <uix:rowLayout>
     <uix:stackLayout>
            <uix:spacer height="5"/>
            <uix:messagePrompt messageType="warning" promptBinding="NOTSYSDBAMSG@memoryMsgBundle@servletRequest"/>
     </uix:stackLayout>
     </uix:rowLayout>
     </uix:case>
     </uix:switcher>
     
     <uix:header textBinding="MEMORYTITLE@memoryMsgBundle@servletRequest">
        <%@ include file="memoryPageTopSection.jspf" %>  
     
     <uix:subTabLayout>
       <uix:subTabs>
         <uix:subTabBar selectedIndex="1">
           <uix:link textBinding="SGATITLE@memoryMsgBundle@servletRequest"
                     onClick="submitForm('foo', true, {event:'sgaTab'})"/>
           <uix:link textBinding="PGATITLE@memoryMsgBundle@servletRequest"/>
         </uix:subTabBar>
       </uix:subTabs>
       
 
     <uix:stackLayout>
     <uix:spacer height="10"/>
     <uix:styledText styleClass="oraFieldText" textBinding="PGA_DESC@memoryMsgBundle@servletRequest"/>    
     
     <uix:tableLayout cellSpacing="5">
     <uix:contents>
     <uix:rowLayout>
     <uix:tableLayout cellSpacing="2">
     <uix:contents>
       <uix:switcher childNameBinding="aggregatePGATargetTuningType@memObj@pageBean@servletRequest"> 
        <uix:case name="AUTO"> 
            <uix:rowLayout>
              <uix:contents>
                 <uix:cellFormat hAlign="right">
                 <uix:contents>
                    <uix:styledText styleClass="oraFieldText" 
                        textBinding="AGGREGATEPGATARGET@memoryMsgBundle@servletRequest"
                        labeledNodeId="aggPgaTarget" /> 
                    <uix:styledText styleClass="OraTipText" 
                        textBinding="STATICPARAMTOKEN@memoryMsgBundle@servletRequest"
                        renderedBinding="isAggregatePGATargetStatic@memObj@pageBean@servletRequest"/>    

                    <uix:styledText styleClass="oraFieldText" text=" ("/>
                    <uix:styledText styleClass="oraFieldText" 
                        textBinding="aggregatePGATargetUnit@memObj@pageBean@servletRequest"/>
                    <uix:styledText styleClass="oraFieldText" text=")"/>
                    <uix:spacer width="5"/>
                 </uix:contents>
                 </uix:cellFormat>
        
                 <uix:cellFormat hAlign="left">
                 <uix:stackLayout>
                 <uix:contents>
                      <uix:textInput name="aggregatePGATarget" columns="10" id="aggPgaTarget"
                      disabledBinding="isAggregatePGATargetReadOnly@memObj@pageBean@servletRequest"
                      textBinding="aggregatePGATarget@memObj@pageBean@servletRequest"/>
                      <uix:messageText messageType="error" messageBinding="aggregatePGATarget@msgBox@servletRequest"/>
                 </uix:contents>
                 </uix:stackLayout>
                 </uix:cellFormat>
             </uix:contents>      
            </uix:rowLayout>        
        </uix:case>
        <uix:case name="MANUAL"> 
            <uix:rowLayout>
              <uix:contents>
                 <uix:cellFormat hAlign="right">
                 <uix:contents>
                      <uix:styledText styleClass="oraFieldText" textBinding="AGGREGATEPGATARGET@memoryMsgBundle@servletRequest"
                        labeledNodeId="aggPgaTarget" /> 
                      <uix:styledText styleClass="OraTipText" 
                          textBinding="STATICPARAMTOKEN@memoryMsgBundle@servletRequest"
                          renderedBinding="isAggregatePGATargetStatic@memObj@pageBean@servletRequest"/>    
                 <uix:spacer width="5"/>
                 </uix:contents>
                 </uix:cellFormat>
        
                 <uix:cellFormat hAlign="left">
                 <uix:stackLayout>
                 <uix:contents>
                      <uix:textInput name="aggregatePGATarget" columns="10" id="aggPgaTarget"
                      disabledBinding="isAggregatePGATargetReadOnly@memObj@pageBean@servletRequest"
                      textBinding="aggregatePGATarget@memObj@pageBean@servletRequest"/>
                      <uix:messageText messageType="error" messageBinding="aggregatePGATarget@msgBox@servletRequest"/>
                 </uix:contents>
                 </uix:stackLayout>
                 </uix:cellFormat>
        
                 <uix:cellFormat hAlign="left">
                 <uix:contents>
                     <uix:choice name="aggregatePGATargetUnit" 
                         shortDescBinding="AGGREGATEPGATARGET@memoryMsgBundle@servletRequest"
                         disabledBinding="isAggregatePGATargetReadOnly@memObj@pageBean@servletRequest" 
                         selectedValueBinding="aggregatePGATargetUnit@memObj@pageBean@servletRequest"
                         >
                      <uix:option text="GB" value="GB"/>    
                      <uix:option text="MB" value="MB"/>    
                      <uix:option text="KB" value="KB"/>
                      <uix:option text="B" value="B"/>
                   </uix:choice>
                 </uix:contents>
                 </uix:cellFormat>
        
                 <uix:cellFormat>
                 <uix:switcher childNameBinding="DBVersion@memObj@pageBean@servletRequest">    
                 <uix:case name="92">   
                    <uix:switcher childNameBinding="isAdvisoriesTurnedOn@memObj@pageBean@servletRequest"> 
                    <uix:case name="1">          
                        <uix:stackLayout>
                      <uix:button id="showAdvicePGA" name="showAdvicePGA" textBinding="SHOWADVICE@memoryMsgBundle@servletRequest" 
                          onClickBinding="blankAdvice@pageBean@servletRequest"/>
        
                      <uix:formValue id="showAdvicePGA1" name="showAdvicePGA1" valueBinding="pgaTargetAdvicePopupLink@pageBean@servletRequest"/>
                        </uix:stackLayout>
                     </uix:case>
                     <uix:case name="0">
                          <uix:submitButton textBinding="ENABLEADVICE@memoryMsgBundle@servletRequest" name="event" value="enbaleAdvisories"/>
                     </uix:case>
                     </uix:switcher>     
                   </uix:case>
                   </uix:switcher>
                 </uix:cellFormat>   
             
             </uix:contents>      
            </uix:rowLayout>
        </uix:case>        
      </uix:switcher>
      
      <uix:rowLayout>
      <uix:contents>
         <uix:cellFormat hAlign="right">
         <uix:contents>
              <uix:styledText styleClass="oraFieldText" textBinding="CURRENTPGAALLOCATED@memoryMsgBundle@servletRequest"/>
              <uix:spacer width="5"/>
         </uix:contents>
         </uix:cellFormat>

         <uix:cellFormat hAlign="left">
         <uix:contents>
              <uix:styledText styleClass="OraDataText" textBinding="currentPGAAllocated@memObj@pageBean@servletRequest"/>
         </uix:contents>
         </uix:cellFormat>

         </uix:contents>      
      </uix:rowLayout>

      <uix:rowLayout>
      <uix:contents>
         <uix:cellFormat hAlign="right">
         <uix:contents>
              <uix:styledText styleClass="oraFieldText" textBinding="MAXIMUMPGAALLOCATED@memoryMsgBundle@servletRequest"/>
              <uix:spacer width="5"/>
         </uix:contents>
         </uix:cellFormat>

         <uix:cellFormat hAlign="left">
         <uix:contents>
              <uix:styledText styleClass="OraDataText" textBinding="maxPGAAllocated@memObj@pageBean@servletRequest"/>
         </uix:contents>
         </uix:cellFormat>
         </uix:contents>      
      </uix:rowLayout>

      <uix:rowLayout>
         <uix:cellFormat hAlign="right">
         </uix:cellFormat>
         <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraInlineInfoText" textBinding="SINCESTARTUP@memoryMsgBundle@servletRequest"/>
         </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
      <uix:contents>
         <uix:cellFormat hAlign="right">
         <uix:contents>
              <uix:styledText styleClass="oraFieldText" textBinding="CACHEHITPERCENTAGE@memoryMsgBundle@servletRequest"/>
              <uix:spacer width="5"/>  
         </uix:contents>
         </uix:cellFormat>

         <uix:cellFormat hAlign="left">
         <uix:contents>
              <uix:styledText styleClass="OraDataText" textBinding="pgaCacheHitPct@memObj@pageBean@servletRequest"/>
         </uix:contents>
         </uix:cellFormat>

         </uix:contents>      
      </uix:rowLayout>

      </uix:contents>
      </uix:tableLayout>
      </uix:rowLayout>

      <uix:switcher childNameBinding="isAdvisoriesTurnedOn@memObj@pageBean@servletRequest">
      <uix:case name="1">
          <uix:rowLayout>
<%--
             <uix:submitButton textBinding="MEMORYUSAGEDETAILS@memoryMsgBundle@servletRequest" 
                    name="event" value="showPgaDetails"/>           
--%>    
          <uix:button textBinding="MEMORYUSAGEDETAILS@memoryMsgBundle@servletRequest" 
                onClickBinding="pgaUsageDetailsPopupLink@pageBean@servletRequest"/>
          </uix:rowLayout>
      </uix:case>
      </uix:switcher>
      </uix:contents>
      </uix:tableLayout>
  
       <uix:spacer height="5"/> 
       <uix:tip> 
        <uix:styledText textBinding="AUTO92MEMORYSUMMSG@memoryMsgBundle@servletRequest"/>
       </uix:tip>
       <uix:spacer height="5"/> 
                
      </uix:stackLayout>
      
     

     </uix:subTabLayout>

      <uix:spacer height="10"/>
      <uix:rowLayout renderedBinding="useSPFile@pageBean@servletRequest">
       <uix:checkBox name="applyToSPFILEOnly" 
            checkedBinding="applyToSPFILEOnly@pageBean@servletRequest"
            textBinding="APPLYSPFILEONLYMSG@memoryMsgBundle@servletRequest"/>
      </uix:rowLayout>
     
      <uix:spacer height="10"/>
      <uix:rowLayout>
      <uix:tip> 
        <uix:styledText textBinding="STATICPARAMMSG@memoryMsgBundle@servletRequest"/>
      </uix:tip>
      </uix:rowLayout>

     </uix:header>
      
     </uix:contents>              
     </uix:stackLayout>      
    </uix:pageLayout>
  </db:form>
  </uix:body>      
  </uix:document> 
</uix:renderingContext> 

