<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>         
    <uix:body>  

      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>

        <%@ include file="../refreshTime.jspf" %>

        <uix:stackLayout>

          <oem:chart
            titleBinding="SGA_CHART_TITLE@memoryMsgBundle@servletRequest"
            chartType="barChart"
            width="700"
            height="200"
            orientation="horizontal"
            stacked="true"
            legendPosition="east"
            xAxisLabelBinding="SGA_CHART_XAXIS_TITLE@memoryMsgBundle@servletRequest">
            <uix:contents>
              <oem:boundChartDataSource chartDataSourceBinding="sgaDS@servletRequest"/>
              <oem:imageMap defaultLabel="true" />
              <oem:chartColumn                                  
                isKey="true"
                displayLabelBinding="SGA_COMPONENT@memoryMsgBundle@servletRequest"
                sourceIndex="0"/>
              <oem:chartColumn                                  
                displayLabelBinding="DEFAULT_POOL@memoryMsgBundle@servletRequest"
                itemColor="#4A86C6"
                sourceIndex="1"/>
              <oem:chartColumn                                  
                displayLabelBinding="USED@memoryMsgBundle@servletRequest"
                itemColor="#9C3000"
                sourceIndex="2"/>
              <oem:chartColumn
                displayLabelBinding="FREE_MEMORY@@memoryMsgBundle@servletRequest"
                itemColor="#9C9A31"
                sourceIndex="3"/>
            </uix:contents>
          </oem:chart>

          <uix:spacer height="15"/>

          <uix:flowLayout>

            <uix:rowLayout>

              <db:switcher connectionBinding="emConnection@servletRequest"
                           versionAtLeast="9.0">
                <uix:case name="true">

                  <uix:cellFormat>

                    <uix:stackLayout>

                      <oem:chart
                        titleBinding="BUFFER_CACHE_USAGE@memoryMsgBundle@servletRequest"
                        chartType="pieChart"
                        width="400"
                        height="200"
                        legendPosition="east">
                        <uix:contents>
                          <oem:boundChartDataSource
                            chartDataSourceBinding="bufferCacheDS@servletRequest"/>
                          <oem:chartColumn                                  
                            isKey="true"
                            displayLabelBinding="BUFFER_CACHE_COMPONENT@memoryMsgBundle@servletRequest"
                            sourceIndex="0"/>
                          <oem:chartColumn                                  
                            displayLabelBinding="SIZE@memoryMsgBundle@servletRequest"
                            sourceIndex="1"/>
                        </uix:contents>
                      </oem:chart>

                      <uix:flowLayout>
                        <uix:styledText styleClass="OraFieldText"
                                        textBinding="DEFAULT_BLOCK_SIZE@memoryMsgBundle@servletRequest"/>
                        <uix:spacer width="5"/>
                        <uix:styledText styleClass="OraDataText" textBinding="dbBlockSize@servletRequest"/>
                      </uix:flowLayout>

                      <uix:spacer height="20"/>

                    </uix:stackLayout>

                  </uix:cellFormat>

                </uix:case>
              </db:switcher>

              <uix:cellFormat>
                <oem:chart
                  titleBinding="SHARED_POOL_CURRENT_USAGE@memoryMsgBundle@servletRequest"
                  chartType="pieChart"
                  pieSlicesFromColumn="true"
                  width="350"
                  height="200"
                  legendPosition="east">
                  <uix:contents>
                    <oem:boundChartDataSource
                      chartDataSourceBinding="sharedPoolDS@servletRequest"/>
                    <oem:chartColumn
                      displayLabelBinding="LIBRARY_CACHE@memoryMsgBundle@servletRequest"
                      itemColor="#4A86C6"
                      sourceIndex="0"/>
                    <oem:chartColumn
                      displayLabelBinding="SQL_AREA@memoryMsgBundle@servletRequest"
                      itemColor="#9C3000"
                      sourceIndex="1"/>
                    <oem:chartColumn
                      displayLabelBinding="FREE@memoryMsgBundle@servletRequest"
                      itemColor="#9C9A31"
                      sourceIndex="2"/>
                    <oem:chartColumn
                      displayLabelBinding="DICTIONARY_CACHE@memoryMsgBundle@servletRequest"
                      itemColor="#CE9A31"
                      sourceIndex="3"/>
                  </uix:contents>
                </oem:chart>
              </uix:cellFormat>

            </uix:rowLayout>

          </uix:flowLayout>

        </uix:stackLayout>
        
        <uix:header textBinding="RELATED_LINKS@SDKBundle@servletRequest">
          <uix:tableLayout width="100%" cellSpacing="2">   
            <uix:rowLayout>     
              <uix:stackLayout>
                <db:link textBinding="MEMORYTITLE@memoryMsgBundle@servletRequest"
                         destination="/console/database/instance/memory" 
                         copyParams="target,type"/>
                </uix:stackLayout>
            </uix:rowLayout>   
          </uix:tableLayout>
        </uix:header>
        

      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
