<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext> 

  <uix:document> 
    
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
       <db:form name="foo" method="POST" copyParams="target,type" destinationBinding="controllerPath@servletRequest">

        <uix:formValue name="pageName" value="/database/instance/recovery/credentials.jsp"/>
        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>
          
           <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
          
          <uix:stackLayout>
            <uix:contents>
              <uix:header textBinding="SPECIFY_CREDENTIALS_HEADER@racMsgBundle@servletRequest">

	      <uix:tableLayout width="100%">
	      <uix:rowLayout>
	        <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_CREDENTIALS_DESC@DBMsgBundle@servletRequest" />
	        </uix:cellFormat>

	        <uix:cellFormat hAlign="right">
		<uix:flowLayout>
		  <uix:spacer width="10"/>
                  <uix:submitButton textBinding="CANCEL@DBMsgBundle@servletRequest" name="event" value="null" shortDescBinding="CANCEL@DBMsgBundle@servletRequest"/>
                  <uix:spacer width="10"/>
                  <uix:submitButton textBinding="CONTINUE@DBMsgBundle@servletRequest"  name="event" value="changeDBInMountMode" shortDescBinding="CONTINUE@DBMsgBundle@servletRequest"/> 
                </uix:flowLayout>
	        </uix:cellFormat>

		<uix:cellFormat>
		  <uix:spacer width="5" />
		</uix:cellFormat>

	      </uix:rowLayout>
	      </uix:tableLayout>

                <uix:header textBinding="SPECIFY_CLUSTER_CREDENTIALS@racMsgBundle@servletRequest" >
                  <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_CLUSTER_CREDENTIALS_DESC@racMsgBundle@servletRequest" />   
                  <uix:spacer height="5"/>

		  <!-- use preferred credentials -->
                  <%@ include file="/dbhostcreds.jspf" %>			  
<%--
                  <uix:tableLayout cellSpacing="5">
                    
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt 
                          required="yes" promptBinding="OS_USER_NAME@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:textInput name="osUserName" textBinding="osUserName@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt 
                          required="yes" promptBinding="OS_USER_PASSWORD@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right">
                        <uix:textInput name="osUserPassword" secret="true" textBinding="osUserPassword@servletRequest"/>
                      </uix:cellFormat>
                      
                    </uix:rowLayout>
                  </uix:tableLayout>
--%>
                </uix:header>

                <uix:header textBinding="SPECIFY_DATABASE_CREDENTIALS@DBMsgBundle@servletRequest" >
                  <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_RAC_CREDENTIALS_DESC@racMsgBundle@servletRequest" />   

                  <uix:spacer height="5"/>

		  <!-- use preferred credentials -->
                  <%@ include file="/credentials.jspf" %>			  
<%--
                  <uix:tableLayout cellSpacing="5">

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt 
                          required="yes" promptBinding="DB_USER_NAME@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:textInput name="dbUserName" textBinding="dbUserName@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt 
                          required="yes" promptBinding="DB_USER_PASSWORD@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:textInput name="dbUserPassword" secret="true" textBinding="dbUserPassword@servletRequest"/>
                      </uix:cellFormat>
                      
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt promptBinding="DB_USER_ROLE@DBMsgBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText" text="SYSDBA"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                  </uix:tableLayout>
--%>
                </uix:header>

              </uix:header>
            </uix:contents>              
          </uix:stackLayout> 

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:spacer width="10"/>
	      <uix:flowLayout>
                <uix:submitButton textBinding="CANCEL@DBMsgBundle@servletRequest" name="event" value="null" shortDescBinding="CANCEL@DBMsgBundle@servletRequest"/>
                <uix:spacer width="10"/>
                <uix:submitButton textBinding="CONTINUE@DBMsgBundle@servletRequest"  name="event" value="changeDBInMountMode" shortDescBinding="CONTINUE@DBMsgBundle@servletRequest"/> 
	      </uix:flowLayout>
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>  
      </db:form>
      
    </uix:body>
  </uix:document> 
</uix:renderingContext> 
