<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.resources.eml.creds.PrefCredsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
request.setAttribute("credsMsgBundle", new BundleDataObject(NLSUtil.getBundle(PrefCredsMsg.class.getName(), request)));
%>


<uix:renderingContext> 

 <uix:bundle name="DBMsgBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
 <uix:bundle name="RecoveryMsgBundle" class="oracle.sysman.db.rsc.inst.RecoveryMsg"/>
 <uix:bundle name="racMsgBundle" class="oracle.sysman.db.rsc.rac.RacCommonMsg"/>
 <uix:bundle name="SDKBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
 <uix:bundle name="stateBundle" class="oracle.sysman.db.rsc.inst.ChangeStateMsg"/>


  <uix:document> 

    
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
       <db:form name="foo" method="POST" copyParams="target,type" destinationBinding="controllerPath@servletRequest">

        <uix:formValue name="pageName" value="/database/instance/recovery/hostCredentials.jsp"/>
        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>
          
           <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
          
          <uix:stackLayout>
            <uix:contents>
              <uix:header textBinding="CREDENTIAL_FOR_DIR_CHECK_HEAD@RecoveryMsgBundle">

	      <uix:tableLayout width="100%">
	      <uix:rowLayout>

	        <uix:cellFormat hAlign="right">
		<uix:flowLayout>
		  <uix:spacer width="10"/>
                  <uix:submitButton textBinding="CANCEL@DBMsgBundle" name="event" value="null" shortDescBinding="CANCEL@DBMsgBundle"/>
                  <uix:spacer width="10"/>
                  <uix:submitButton textBinding="CONTINUE@DBMsgBundle"  name="event" value="setHostCredential" shortDescBinding="CONTINUE@DBMsgBundle"/> 
                </uix:flowLayout>
	        </uix:cellFormat>

		<uix:cellFormat>
		  <uix:spacer width="5" />
		</uix:cellFormat>

	      </uix:rowLayout>
	      </uix:tableLayout>

        <uix:switcher childNameBinding="isRac@servletRequest">
        <uix:case name="true">
                <uix:header textBinding="SPECIFY_CLUSTER_CREDENTIALS@racMsgBundle" >
                  <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_CLUSTER_CREDENTIALS_DESC@racMsgBundle" />
                  <uix:spacer height="5"/>
                  <%@ include file="/credentials.jspf" %>                         
                </uix:header>
        </uix:case>
        <uix:default>
                <uix:header textBinding="HOST_CREDENTIALS@DBMsgBundle" >
                  <uix:styledText styleClass="OraInstructionText" textBinding="SPECIFY_HOST_CREDENTIALS_DESC@stateBundle" />
                  <uix:spacer height="5"/>
                  <%@ include file="/credentials.jspf" %>                         
                </uix:header>
        </uix:default>
        </uix:switcher>                 

              </uix:header>
            </uix:contents>              
          </uix:stackLayout> 

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:spacer width="10"/>
	      <uix:flowLayout>
                <uix:submitButton textBinding="CANCEL@DBMsgBundle" name="event" value="null" shortDescBinding="CANCEL@DBMsgBundle"/>
                <uix:spacer width="10"/>
                <uix:submitButton textBinding="CONTINUE@DBMsgBundle"  name="event" value="setHostCredential" shortDescBinding="CONTINUE@DBMsgBundle"/> 
	      </uix:flowLayout>
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>  
      </db:form>
      
    </uix:body>
  </uix:document> 
</uix:renderingContext> 

