<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
<uix:form name="foo" method="post" destination="/console/database/instance/repDown/home">

    <uix:pageLayout titleBinding="header@servletRequest">


    <%@ include file="/database/global.jspf" %>
      <uix:switcher childNameBinding="stateChange@servletRequest">
      <uix:case name="true">
        <oem:messageBox messageTypeBinding="stateChangeMessageType@servletRequest"
	      errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:case>
    </uix:switcher>


     <uix:flowLayout>
          <uix:tableLayout width="100%">
            <uix:rowLayout vAlign="top">
            
              <uix:cellFormat hAlign="left" width="60%">
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="instrText@servletRequest"/>
              </uix:cellFormat>

               <uix:cellFormat hAlign="right" wrappingDisabled="true" >
                <uix:rowLayout>
                    <uix:styledText styleClass="OraTipText" 
                      textBinding="PAGE_REFRESHED_TIME@SDKBundle@servletRequest"/>
                    <uix:spacer width="5" />  
                    <uix:styledText styleClass="OraTipLabel" 
                      textBinding="refreshTime@servletRequest"/>
                    <uix:spacer width="5" />
                    <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
                        destinationBinding="refreshDest@servletRequest" />
                </uix:rowLayout>
              </uix:cellFormat>
                 
              </uix:rowLayout>
        </uix:tableLayout>
      </uix:flowLayout>
      
      
      <uix:spacer height="5"/>

       <uix:tableLayout width="100%" cellSpacing="2">

            <uix:rowLayout vAlign="top">
              <uix:cellFormat vAlign="top" width="50%">

                <!-- ...................  General Section .................. -->
                  <uix:stackLayout>
                       <uix:stackLayout>

                        <uix:rowLayout>

			  <uix:tableLayout hAlign="left">

 			      <!-- show buttons for rac -->
			    <uix:rowLayout hAlign="right" renderedBinding="isRac@servletRequest" >
			      <uix:cellFormat>
			        <uix:spacer width="20"/>
		          </uix:cellFormat>
              <uix:cellFormat hAlign="right">
                <uix:flowLayout>
                  <uix:spacer width="10"/> 
                  <uix:button textBinding="STARTUP@DBMsgBundle@servletRequest"
                    destinationBinding="changeStateUrl@servletRequest"/>
                  <uix:spacer width="10"/>
                  <uix:button textBinding="RECOVERY@DBMsgBundle@servletRequest"
                    destinationBinding="recoveryUrl@servletRequest"/>
                </uix:flowLayout>
              </uix:cellFormat>
            </uix:rowLayout>                 
        </uix:tableLayout>
          
	
			    
			</uix:rowLayout>
		       </uix:stackLayout>
		  </uix:stackLayout>
	      </uix:cellFormat>
	    </uix:rowLayout>
       </uix:tableLayout>





      <uix:stackLayout renderedBinding="singleInstance@servletRequest" >
  
        
      <%@ include file="repDownInclude.jspf" %>
        

      </uix:stackLayout>


      <uix:switcher childNameBinding="newRepDownLinks@servletRequest">
      <uix:case name="true">



       <uix:header textBinding="RELATED_LINKS@DBMsgBundle@servletRequest">
	    <uix:tableLayout width="100%" >
		 <uix:rowLayout vAlign="top">
          <uix:tableLayout width="100%" cellSpacing="20">
            <uix:rowLayout vAlign="top">
      
         <uix:cellFormat vAlign="top">
              <uix:stackLayout>

                <uix:link textBinding="RECOVERY_SETTINGS@DBMsgBundle@servletRequest"
                    destinationBinding="configureRecoveryUrl@servletRequest"/>

          <oem:license>
                <uix:link textBinding="SITEMAP_LW@DBMsgBundle@servletRequest"
                    destinationBinding="lwUrl@servletRequest"
                    renderedBinding="showMemModeLink@servletRequest"/>
          </oem:license>

                <%-- SWB (oracle/rac_database) link --%>
                <uix:link textBinding="swbText@servletRequest"
                    destinationBinding="swbUrl@servletRequest"
                    renderedBinding="showSWBLink@servletRequest"/>

                <%-- SWB (osm_instance) link --%>
                <uix:link textBinding="swbAsmText@servletRequest"
                    destinationBinding="swbAsmUrl@servletRequest"
                    renderedBinding="showAsmSWBLink@servletRequest"/>

              </uix:stackLayout>
         </uix:cellFormat>
		</uix:rowLayout>
          </uix:tableLayout>
           
			<uix:tableLayout width="100%" cellSpacing="20">
            <uix:rowLayout vAlign="top">
      
         <uix:cellFormat vAlign="top" >
              <uix:stackLayout>

                <uix:link textBinding="CHANGE_DATABASE_SRVPOOL@DBMsgBundle@servletRequest"
                          renderedBinding="isPolicyManagedDB@servletRequest"
                          destinationBinding="srvpoolChangeUrl@servletRequest"/>

                <uix:link textBinding="CRS_START_STOP@DBMsgBundle@servletRequest"
                          renderedBinding="isRac@servletRequest"
                    destinationBinding="crsChangeStateUrl@servletRequest"/>

              </uix:stackLayout>
         </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
		 </uix:rowLayout>
		</uix:tableLayout>
        </uix:header>

      </uix:case>
    </uix:switcher>  
    
    </uix:pageLayout>
<%--    --%>
</uix:form>

    </uix:body>


  </uix:document>
</uix:renderingContext>

