<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="bundle"
              class="oracle.sysman.db.rsc.inst.RsrcConfigMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form
        copyParams="target,type,cancelURL"
        name="rsrcStartForm" 
        method="post"
        destination="rsrcStart">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcStarted"/>

        <uix:pageLayout
          titleBinding="STARTED_TITLE@bundle"
          >

          <%@ include file="/database/global.jspf" %>



<uix:tableLayout cellSpacing="20" >
  <uix:rowLayout>
      <uix:styledText styleClass="OraInstructionText" textBinding="DESC@bundle" />
  </uix:rowLayout>          
  <uix:rowLayout>
  <uix:tip>
      <db:link textBinding="ADMIN_PRIV@bundle" 
      		destinationBinding="userPage@servletRequest"
		copyParams="target,type"/>
      <uix:spacer width="5" />
      <uix:styledText styleClass="OraTipText" textBinding="ADMIN_PRIV_DESC@bundle" />
  </uix:tip>
  </uix:rowLayout>          
  <uix:rowLayout>
        <uix:bulletedList rows="5" >

  <uix:flowLayout>
      <db:link textBinding="CONSUMER_GROUP@bundle"
      shortDescBinding="CONSUMER_GROUP_SHORT_DESC@bundle"
      		destination="/console/database/databaseObjectsSearch?event=search&otype=RESOURCE_GROUP"
		copyParams="target,type"/>
      <uix:spacer width="5" />
      <uix:styledText styleClass="OraPromptText" textBinding="CONSUMER_GROUP_DESC@bundle" />
  </uix:flowLayout>
  <uix:flowLayout>
      <db:link textBinding="CONSUMER_GROUP_MAP@bundle" shortDescBinding="CONSUMER_GROUP_MAP_SHORT_DESC@bundle"
      		destination="/console/database/instance/rsrcmap"
		copyParams="target,type"/>
      <uix:spacer width="5" />
      <uix:styledText styleClass="OraPromptText"
      textBinding="CONSUMER_GROUP_MAP_DESC@bundle" />
  </uix:flowLayout>
  <uix:flowLayout>
      <db:link textBinding="PLAN@bundle" shortDescBinding="PLAN_SHORT_DESC@bundle"
      		destination="/console/database/databaseObjectsSearch?event=search&otype=RESOURCE_PLAN"
		copyParams="target,type"/>
      <uix:spacer width="5" />
      <uix:styledText styleClass="OraPromptText" textBinding="PLAN_DESC@bundle" />
  </uix:flowLayout>
  <uix:flowLayout>
      <db:link textBinding="SETTINGS@bundle" shortDescBinding="SETTINGS_SHORT_DESC@bundle"
      		destination="/console/database/instance/rsrcconfig?otype=RESOURCE_GROUP"
		copyParams="target,type"/>
      <uix:spacer width="5" />
      <uix:styledText styleClass="OraPromptText" textBinding="SETTINGS_DESC@bundle" />
  </uix:flowLayout>
  <uix:flowLayout>
      <db:link textBinding="PERF_STATS@bundle"  shortDescBinding="PERF_STATS_SHORT_DESC@bundle"
      		destination="/console/database/instance/rsrcmon"
		copyParams="target,type"/>
      <uix:spacer width="5" />
      <uix:styledText styleClass="OraPromptText" textBinding="PERF_STATS_DESC@bundle" />
  </uix:flowLayout>
  </uix:bulletedList>
  </uix:rowLayout>          
</uix:tableLayout>  


        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
