<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<db:script src="/database/utils.js"/>

 <uix:bundle name="rsrcConfigBundle"
          class="oracle.sysman.db.rsc.inst.RsrcConfigMsg"/>
 <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form
        copyParams="target,type"
        name="calibForm" 
        method="post"
        destination="/console/database/instance/rsrccalibration">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrccalib/ioCalibration"/>

        <uix:pageLayout titleBinding="CALIB_TITLE@rsrcConfigBundle">

          <%@ include file="/database/global.jspf" %>

<uix:messages>
<uix:stackLayout>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
	    destTableBinding="infoUrls@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
	    destTableBinding="infoUrls@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
</uix:stackLayout>
</uix:messages>

            	<uix:messagePrompt messageType="warning" promptBinding="CALIB_WARNING@rsrcConfigBundle"/>
            <uix:tableLayout cellSpacing="5" width="100%" >

	    <uix:rowLayout>
	    <uix:cellFormat>
	    <uix:header textBinding="EXISTING_CALIB_RESULTS@rsrcConfigBundle">
	    <uix:tableLayout cellSpacing="5">
	    <uix:rowLayout>
	    <uix:cellFormat hAlign="left" columnSpan="2">
	    	<uix:tableLayout cellSpacing="5" width="50%">
		    <uix:rowLayout>
		    <uix:cellFormat hAlign="right" wrappingDisabled="true">
	        	  <uix:styledText styleClass="OraPromptText" labeledNodeId="physicalDisksCount" textBinding="CALIB_DATE@rsrcConfigBundle"/>
		    </uix:cellFormat>
		    <uix:cellFormat hAlign="left" wrappingDisabled="true">
		    	<uix:switcher childNameBinding="calibDate@calibBean@servletRequest">
                  		<uix:case name="">
	        	  		<uix:styledText styleClass="OraDataText" labeledNodeId="physicalDisksCount"
			  			textBinding="NONE@rsrcConfigBundle"/>
                  		</uix:case>
				<uix:default>
	        	  		<uix:styledText styleClass="OraDataText" labeledNodeId="physicalDisksCount"
				  		textBinding="calibDate@calibBean@servletRequest"/>
				</uix:default>
		    	</uix:switcher>
		    </uix:cellFormat>
		    </uix:rowLayout>
		  </uix:tableLayout>
	    </uix:cellFormat>
	    </uix:rowLayout>
	    <uix:rowLayout>
	    <uix:cellFormat hAlign="left" columnSpan="2">
	    	<uix:header textBinding="INPUTS@rsrcConfigBundle">
	    	<uix:tableLayout cellSpacing="5">
	    	<uix:rowLayout>
	    	<uix:cellFormat hAlign="right">
	          	<uix:styledText styleClass="OraPromptText" labeledNodeId="physicalDisksCount" textBinding="MAX_IOPS@rsrcConfigBundle"/>
	    	</uix:cellFormat>
	    	<uix:cellFormat hAlign="left">
		    	<uix:switcher childNameBinding="maxIOPS@calibBean@servletRequest">
                  		<uix:case name="">
	        	  		<uix:styledText styleClass="OraDataText" labeledNodeId="physicalDisksCount"
			  			textBinding="NONE@rsrcConfigBundle"/>
                  		</uix:case>
				<uix:default>
	        	  		<uix:styledText styleClass="OraDataText" labeledNodeId="physicalDisksCount"
				  		textBinding="maxIOPS@calibBean@servletRequest"/>
				</uix:default>
		    	</uix:switcher>
	    	</uix:cellFormat>
	    	</uix:rowLayout>
	    	<uix:rowLayout>
	    	<uix:cellFormat hAlign="right">
	          	<uix:styledText styleClass="OraPromptText" labeledNodeId="physicalDisksCount" textBinding="MAX_MBPS@rsrcConfigBundle"/>
	    	</uix:cellFormat>
	    	<uix:cellFormat hAlign="left">
		    	<uix:switcher childNameBinding="maxMBPS@calibBean@servletRequest">
                  		<uix:case name="">
	        	  		<uix:styledText styleClass="OraDataText" labeledNodeId="physicalDisksCount"
			  			textBinding="NONE@rsrcConfigBundle"/>
                  		</uix:case>
				<uix:default>
	        	  		<uix:styledText styleClass="OraDataText" labeledNodeId="physicalDisksCount"
				  		textBinding="maxMBPS@calibBean@servletRequest"/>
				</uix:default>
		    	</uix:switcher>
	    	</uix:cellFormat>
	    	</uix:rowLayout>
	    	</uix:tableLayout>
	    	</uix:header>
	    </uix:cellFormat>
	    </uix:rowLayout>
	    <uix:rowLayout>
	    <uix:cellFormat hAlign="left" columnSpan="2">
	    	<uix:header textBinding="MEASUREMENTS@rsrcConfigBundle">
	    	<uix:tableLayout cellSpacing="5">
	    	<uix:rowLayout>
	    	<uix:cellFormat hAlign="right" wrappingDisabled="false">
	          	<uix:styledText styleClass="OraPromptText" labeledNodeId="physicalDisksCount" textBinding="MAX_LATENCY@rsrcConfigBundle"/>
	    	</uix:cellFormat>
	    	<uix:cellFormat hAlign="left">
		    	<uix:switcher childNameBinding="maxLatency@calibBean@servletRequest">
                  		<uix:case name="">
	        	  		<uix:styledText styleClass="OraDataText" labeledNodeId="physicalDisksCount"
			  			textBinding="NONE@rsrcConfigBundle"/>
                  		</uix:case>
				<uix:default>
	        	  		<uix:styledText styleClass="OraDataText" labeledNodeId="physicalDisksCount"
				  		textBinding="maxLatency@calibBean@servletRequest"/>
				</uix:default>
		    	</uix:switcher>
	    	</uix:cellFormat>
	    	</uix:rowLayout>
	    	<uix:rowLayout>
	    	<uix:cellFormat hAlign="right">
	          	<uix:styledText styleClass="OraPromptText" labeledNodeId="physicalDisksCount" textBinding="STATUS@rsrcConfigBundle"/>
	    	</uix:cellFormat>
	    	<uix:cellFormat hAlign="left">
		    	<uix:switcher childNameBinding="status@calibBean@servletRequest">
                  		<uix:case name="">
	        	  		<uix:styledText styleClass="OraDataText" labeledNodeId="physicalDisksCount"
			  			textBinding="NONE@rsrcConfigBundle"/>
                  		</uix:case>
				<uix:default>
	        	  		<uix:styledText styleClass="OraDataText" labeledNodeId="physicalDisksCount"
				  		textBinding="status@calibBean@servletRequest"/>
				</uix:default>
		    	</uix:switcher>
	    	</uix:cellFormat>
	    	</uix:rowLayout>
	    	</uix:tableLayout>
	    	</uix:header>
	    </uix:cellFormat>
	    </uix:rowLayout>
	    </uix:tableLayout>
	    </uix:header>
	    </uix:cellFormat>
	    </uix:rowLayout>

	    <uix:rowLayout>
	    <uix:cellFormat>
	    <uix:header textBinding="INPUTS_HEADER@rsrcConfigBundle">
	    <uix:tableLayout cellSpacing="5">
	    <uix:rowLayout>
	    <uix:cellFormat hAlign="right">
	          <uix:styledText styleClass="OraPromptText" labeledNodeId="physicalDisksCount" textBinding="PHYSICAL_DISKS@rsrcConfigBundle"/>
	    </uix:cellFormat>
	    <uix:cellFormat hAlign="left">
	          <uix:textInput id="physicalDisksCount" 
		  		name="physicalDisksCount"
				columns="10">
		  <uix:onBlurValidater>
		  	<uix:decimal />
		  </uix:onBlurValidater>
		  </uix:textInput>
	    </uix:cellFormat>
	    </uix:rowLayout>
	    <uix:rowLayout>
	    <uix:cellFormat hAlign="right">
	          <uix:styledText styleClass="OraPromptText"
		  labeledNodeId="maxTolLatency" textBinding="MAX_TOL_LATENCY@rsrcConfigBundle"/>
	    </uix:cellFormat>
	    <uix:cellFormat hAlign="left">
	          <uix:textInput id="maxTolLatency" 
		  		name="maxTolLatency" 
				columns="10">
		  <uix:onBlurValidater>
		  	<uix:decimal />
		  </uix:onBlurValidater>
		  </uix:textInput>
	    </uix:cellFormat>
	    </uix:rowLayout>
	    </uix:tableLayout>
	    </uix:header>
	    </uix:cellFormat>
	    </uix:rowLayout>
	    </uix:tableLayout>
	    <%@ include file="schedule.jspf" %>
	    <uix:tip textBinding="CALIB_TIP@rsrcConfigBundle"/>

          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:submitButton
                name="event"
                textBinding="CALIBRATE@rsrcConfigBundle"
                shortDescBinding="CALIBRATE@rsrcConfigBundle"
                value="calibrate"/>
              <uix:submitButton
                name="event"
                textBinding="CANCEL@rsrcConfigBundle"
                shortDescBinding="CANCEL@rsrcConfigBundle"
                value="cancel"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

