<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<db:script src="/database/utils.js"/>

 <uix:bundle name="rsrcConfigBundle"
          class="oracle.sysman.db.rsc.inst.RsrcConfigMsg"/>
 <uix:bundle name="uixDBObjectBundle"
          class="oracle.sysman.db.rsc.DBObjectMsg"/>
 <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form
        copyParams="target,type,cancelURL"
        name="configForm" 
        method="post"
        destination="/console/database/instance/rsrcconfig">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcconfig/rsrcConfig"/>

        <uix:pageLayout titleBinding="TITLE@rsrcConfigBundle">

          <%@ include file="/database/global.jspf" %>

<uix:messages>
<uix:stackLayout>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
</uix:stackLayout>
</uix:messages>


          <%-----------------------------------------
           -  Active Resource Plan Selection        -
           -----------------------------------------%>
            <uix:tableLayout cellSpacing="5" width="75%" >

            <%-------------  Current Active Plan  ---------------%>
              <uix:rowLayout>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:styledText 
                  styleClass="OraPromptText"
                  textBinding="ACTIVE_PLAN_PROMPT@rsrcConfigBundle"
                />
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:switcher childNameBinding="hasActivePlan@rsrcConfigBean@servletRequest">
                  <uix:case name="true">
                    <uix:link
                      textBinding="activePlan@rsrcConfigBean@servletRequest"
                      onClick="submitForm('configForm', true, {event:'edit'})"
                    />
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText 
                      styleClass="OraDataText"
                      textBinding="NO_ACTIVE_PLAN@rsrcConfigBundle"
                    />
                  </uix:case>
                </uix:switcher>
              </uix:cellFormat>
              <uix:cellFormat>
              </uix:cellFormat>
            </uix:rowLayout>

            <%-------------  Plans Available for Activation  ---------------%>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                <uix:styledText 
                  labeledNodeId="selectedPlan"
                  styleClass="OraPromptText"
                  textBinding="AVAILABLE_PLANS_PROMPT@rsrcConfigBundle"
                />
              </uix:cellFormat>

              <uix:cellFormat hAlign="left">
                <oem:choice
                  id="selectedPlan"
                  name="selectedPlan"
                  selectedValueBinding="selectedPlan@rsrcConfigBean@servletRequest"
                  optionsBinding="alternativePlans@rsrcConfigBean@servletRequest"
                  >
                </oem:choice>
              </uix:cellFormat>
              <uix:cellFormat>
	      <uix:flowLayout>
                  <uix:submitButton
                    name="event" 
                    textBinding="ACTIVATE@rsrcConfigBundle"
                    shortDescBinding="ACTIVATE@rsrcConfigBundle"
                    value="activate"
                  />
                  <uix:submitButton
                    name="event" 
                    textBinding="VIEW@rsrcConfigBundle"
                    shortDescBinding="VIEW@rsrcConfigBundle"
                    value="view"
                  />
	      </uix:flowLayout>
              </uix:cellFormat>
            </uix:rowLayout> 
	    </uix:tableLayout>
            <%---------------------------
             -   Instruction Text
             ---------------------------%>
            <uix:tableLayout cellSpacing="10">
              <uix:rowLayout> 
                <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="RSRC_CONFIG_INSTR@rsrcConfigBundle"
                  />
              </uix:rowLayout> 
            </uix:tableLayout>
            <uix:spacer height="10"/>


        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

