<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>

<uix:document>

<uix:metaContainer>
  <uix:head titleBinding="RSRC_DIRECTIVE_TITLE@rsrcDirectiveBundle@servletRequest"/>
</uix:metaContainer>

<uix:body>
  <db:form 
    copyParams="target,type,cancelURL,oname,otype"
    name="directiveForm" 
    method="post"
    destinationBinding="defaultControllerURL@rsrcdirBean@servletRequest">

    <uix:pageLayout 
      titleBinding="RSRC_DIRECTIVE_MGMT@rsrcDirectiveBundle@servletRequest"
      >

      <%@ include file="/database/global.jspf" %>

      <uix:formValue name="pageName" value="/database/instance/rsrcdir/rsrcdirGeneral"/>

      <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <%-------------------------
       -  Alligned Name and Description Fields
       ---------------------------%>
      <uix:tableLayout
        cellSpacing="5"
        >

        <%-------  Directive Name  -------%>
        <uix:rowLayout>

          <uix:cellFormat hAlign="right">
            <uix:switcher childNameBinding="creating@rsrcdirBean@servletRequest">
             <uix:case name="true">
              <uix:messagePrompt
                required="yes"
                promptBinding="DIRECTIVE_PROMPT@rsrcDirectiveBundle@servletRequest"/>
             </uix:case>
             <uix:case name="false">
              <uix:styledText
                styleClass="OraPromptText"
                textBinding="DIRECTIVE_PROMPT@rsrcDirectiveBundle@servletRequest"/>
             </uix:case>
            </uix:switcher>
          </uix:cellFormat>

          <uix:cellFormat>
            <uix:switcher childNameBinding="creating@rsrcdirBean@servletRequest">
             <uix:case name="true">
               <uix:textInput 
                 name="directiveName"
                 textBinding="directiveName@rsrcdirDirectiveBean@servletRequest"
                 columns="50"/>
             </uix:case>
             <uix:case name="false">
               <uix:styledText
                 styleClass="OraDataText"
                 textBinding="directiveName@rsrcdirDirectiveBean@servletRequest"/>
             </uix:case>
            </uix:switcher>
          </uix:cellFormat>

        </uix:rowLayout>

        <%-------  Directive Description  -------%>
        <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="DESCRIPTION_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
            <uix:textInput 
              name="description"
              textBinding="description@rsrcdirDirectiveBean@servletRequest"
              columns="50"/>
        </uix:rowLayout>

      </uix:tableLayout>

      <%-------------------------
       -  Midtier Parameters
       ---------------------------%>
      <uix:header
        textBinding="MIDTIER_HDR@rsrcDirectiveBundle@servletRequest"
        >
        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout>

            <%-------  Active Time In Call -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="ACTIVE_TIME_IN_CALL_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:textInput
                columns="10"
                name="activeTimeInCall"
                textBinding="activeTimeInCall@rsrcdirDirectiveBean@servletRequest"/>

            <%-------  Active Time In Call Switch -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                labeledNodeId="activeTimeInCallSwitch"
                textBinding="SWITCH_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <oem:choice 
                id="activeTimeInCallSwitch"
                name="activeTimeInCallSwitch"
                selectedValueBinding="activeTimeInCallSwitch@rsrcdirDirectiveBean@servletRequest"
                optionsBinding="activeTimeInCallOptions@rsrcdirDirectiveBean@servletRequest" >
              </oem:choice>

          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
            </uix:cellFormat>

            <%-------  End Call Switch -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                labeledNodeId="endCallSwitch"
                textBinding="END_CALL_SWITCH_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <oem:choice 
                id="endCallSwitch"
                name="endCallSwitch"
                selectedValueBinding="endCallSwitch@rsrcdirDirectiveBean@servletRequest"
                optionsBinding="endCallOptions@rsrcdirDirectiveBean@servletRequest" >
              </oem:choice>

          </uix:rowLayout>
        </uix:tableLayout>
      </uix:header>

      <%-------------------------
       -  Client-Server Parameters
       ---------------------------%>
      <uix:header
        textBinding="CLIENT_SERVER_HDR@rsrcDirectiveBundle@servletRequest"
        >
        <uix:tableLayout cellSpacing="5">

          <uix:rowLayout>
            <%-------  Active Time In Group -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText styleClass="OraPromptText"
                textBinding="ACTIVE_TIME_IN_GROUP_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:lovField  
                columns="10"
                name="activeTimeInGroup"
                textBinding="activeTimeInGroup@rsrcdirDirectiveBean@servletRequest"
                destinationBinding="activeTimeinGroupDest@rsrcdirDirectiveBean@servletRequest"
              />

            <%-------  Active Time In Group Switch -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText styleClass="OraPromptText"
                labeledNodeId="activeTimeInGroupSwitch"
                textBinding="SWITCH_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <oem:choice 
                id="activeTimeInGroupSwitch"
                name="activeTimeInGroupSwitch"
                selectedValueBinding="activeTimeInGroupSwitch@rsrcdirDirectiveBean@servletRequest"
                optionsBinding="activeTimeInGroupOptions@rsrcdirDirectiveBean@servletRequest" >
              </oem:choice>
          </uix:rowLayout>

          <uix:rowLayout>
            <%-------  Connect Time -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="CONNECT_TIME_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
            <uix:lovField 
              columns="10"
              name="connectTime"
              textBinding="connectTime@rsrcdirDirectiveBean@servletRequest"
              destinationBinding="connectTimeDest@rsrcdirDirectiveBean@servletRequest"
            />

            <%-------  Connect Time Switch -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                labeledNodeId="connectTimeSwitch"
                textBinding="SWITCH_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <oem:choice 
                id="connectTimeSwitch"
                name="connectTimeSwitch"
                selectedValueBinding="connectTimeSwitch@rsrcdirDirectiveBean@servletRequest"
                optionsBinding="connectTimeOptions@rsrcdirDirectiveBean@servletRequest" >
              </oem:choice>
          </uix:rowLayout>

          <uix:rowLayout>
            <%-------  Idle Time In Group -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="IDLE_TIME_IN_GROUP_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:lovField 
                columns="10"
                name="idleTimeInGroup"
                textBinding="idleTimeInGroup@rsrcdirDirectiveBean@servletRequest"
                destinationBinding="idleTimeInGroupDest@rsrcdirDirectiveBean@servletRequest"
              />

            <%-------  Idle Time In Group Switch -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                labeledNodeId="idleTimeInGroupSwitch"
                textBinding="SWITCH_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <oem:choice 
                id="idleTimeInGroupSwitch"
                name="idleTimeInGroupSwitch"
                selectedValueBinding="idleTimeInGroupSwitch@rsrcdirDirectiveBean@servletRequest"
                optionsBinding="idleTimeInGroupOptions@rsrcdirDirectiveBean@servletRequest" >
              </oem:choice>
          </uix:rowLayout>

          <uix:rowLayout>
            <%-------  Idle Blocker Time -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="IDLE_BLOCKER_TIME_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:textInput  
                name="idleBlockerTime"
                textBinding="idleBlockerTime@rsrcdirDirectiveBean@servletRequest"
                columns="10"/>
          </uix:rowLayout>

          <uix:rowLayout>
            <%-------  Group Max Sessions -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="GROUP_MAX_SESSIONS_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:lovField  
                columns="10"
                name="groupMaxSessions"
                textBinding="groupMaxSessions@rsrcdirDirectiveBean@servletRequest"
                destinationBinding="groupMaxSessionsDest@rsrcdirDirectiveBean@servletRequest"
              />
          </uix:rowLayout>

        </uix:tableLayout>
      </uix:header>

      <%-------------------------
       -  Both Midtier and Client-Server Parameters
       ---------------------------%>
      <uix:header
           textBinding="MIDTIER_CLIENT_SERVER_HDR@rsrcDirectiveBundle@servletRequest"
           >
        <uix:tableLayout cellSpacing="5">

          <uix:rowLayout>
            <%-------  Use Active Time Estimate  -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="USE_ACTIVE_TIME_ESTIMATE_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:checkBox
                name="useActiveTimeEstimate" 
                checkedBinding="useActiveTimeEstimate@rsrcdirDirectiveBean@servletRequest"
                />
          </uix:rowLayout>

          <uix:rowLayout>
            <%-------  Parallel Degree Limit  -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="PARALLEL_DEGREE_LIMIT_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:textInput  
                name="parallelDegreeLimit"
                textBinding="parallelDegreeLimit@rsrcdirDirectiveBean@servletRequest"
                columns="10"/>
          </uix:rowLayout>

          <uix:rowLayout>
            <%-------  Private Memory Target  -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="PRIVATE_MEMORY_TARGET_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:textInput  
                name="privateMemoryTarget"
                textBinding="privateMemoryTarget@rsrcdirDirectiveBean@servletRequest"
                columns="10"/>
          </uix:rowLayout>

          <uix:rowLayout>
            <%-------  Undo Quota  -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="UNDO_QUOTA_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:textInput  
                name="undoQuota"
                textBinding="undoQuota@rsrcdirDirectiveBean@servletRequest"
                columns="10"/>
          </uix:rowLayout>

          <uix:rowLayout>
            <%-------  Temp Quota  -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="TEMP_QUOTA_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:textInput  
                name="tempQuota"
                textBinding="tempQuota@rsrcdirDirectiveBean@servletRequest"
                columns="10"/>
          </uix:rowLayout>

          <uix:rowLayout>
            <%-------  Active Session Limit  -------%>
            <uix:cellFormat hAlign="right">
              <uix:styledText 
                styleClass="OraPromptText"
                textBinding="ACTIVE_SESSION_LIMIT_PROMPT@rsrcDirectiveBundle@servletRequest" />
            </uix:cellFormat>
              <uix:textInput  
                name="activeSessionLimit"
                textBinding="activeSessionLimit@rsrcdirDirectiveBean@servletRequest"
                columns="10"/>
          </uix:rowLayout>

        </uix:tableLayout>
      </uix:header>

      <%-------------------------
       -  Page Buttons
       ---------------------------%>
      <uix:pageButtons>
        <uix:pageButtonBar>

          <uix:submitButton
            name="event" 
            textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
            value="showSql"/>

          <uix:switcher childNameBinding="creating@rsrcdirBean@servletRequest">
            <uix:case name="true">
                <uix:submitButton 
                  name="event" 
                  textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                  value="cancel"/>  
            </uix:case>
            <uix:case name="false">
                <uix:submitButton 
                  name="event" 
                  textBinding="REVERT@uixDBObjectBundle@servletRequest"
                  value="revert"/>  
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="creating@rsrcdirBean@servletRequest">
            <uix:case name="true">
                <uix:submitButton
                  name="event" 
                  textBinding="OK@uixDBObjectBundle@servletRequest"
                  value="apply"/>
            </uix:case>
            <uix:case name="false">
                <uix:submitButton
                  name="event" 
                  textBinding="APPLY@uixDBObjectBundle@servletRequest"
                  value="apply"/>
            </uix:case>
          </uix:switcher>

        </uix:pageButtonBar>
      </uix:pageButtons>

    </uix:pageLayout>
  </db:form>
</uix:body>

</uix:document>
