<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-----------------------------------------------------------------------
      ----                 Resource Group Directive View                 ----
      -----------------------------------------------------------------------%>

    <uix:metaContainer>
      <uix:head 
        titleBinding="RSRC_DIRECTIVE_VIEW_TITLE@rsrcDirectiveBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="directiveForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcdirBean@servletRequest">

        <uix:pageLayout 
          titleBinding="RSRC_DIRECTIVE_MGMT@rsrcDirectiveBundle@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <uix:formValue
            name="pageName"
            value="/database/instance/rsrcdir/rsrcdirGeneral"/>

          <uix:tableLayout
            cellSpacing="5">

            <%-------  Directive Name -------%>
            <uix:rowLayout>
              <uix:styledText
                styleClass="OraPromptText"
                textBinding="DIRECTIVE_PROMPT@rsrcDirectiveBundle@servletRequest"
                />
              <uix:styledText
                styleClass="OraDataText"
                textBinding="directiveName@rsrcdirDirectiveBean@servletRequest"
                />
            </uix:rowLayout>

            <%-------  Directive Description  -------%>
            <uix:rowLayout>
              <uix:styledText
                styleClass="OraPromptText"
                textBinding="DESCRIPTION_PROMPT@rsrcDirectiveBundle@servletRequest"
                />
              <uix:styledText
                styleClass="OraDataText"
                textBinding="description@rsrcdirDirectiveBean@servletRequest"
                />
            </uix:rowLayout>

          </uix:tableLayout>

          <%-------------------------
           -  Midtier Parameters
           ---------------------------%>
          <uix:header
            textBinding="MIDTIER_HDR@rsrcDirectiveBundle@servletRequest"
            >

            <uix:tableLayout
              cellSpacing="5">

              <uix:rowLayout>
                <%-------  Active Time In Call -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="ACTIVE_TIME_IN_CALL_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="activeTimeInCall@rsrcdirDirectiveBean@servletRequest"
                    />

                <%-------  Active Time In Call Switch -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="SWITCH_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="activeTimeInCallSwitch@rsrcdirDirectiveBean@servletRequest"
                    />

                <%-------  End Call Switch -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="END_CALL_SWITCH_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="endCallSwitch@rsrcdirDirectiveBean@servletRequest" />
              </uix:rowLayout>

            </uix:tableLayout>

          </uix:header>

          <%-------------------------
           -  Client-Server Parameters
           ---------------------------%>
          <uix:header
            textBinding="CLIENT_SERVER_HDR@rsrcDirectiveBundle@servletRequest"
            >

            <uix:tableLayout
              cellSpacing="5">

              <uix:rowLayout>
                <%-------  Active Time In Group -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="ACTIVE_TIME_IN_GROUP_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText
                    styleClass="OraDataText"
                    textBinding="activeTimeInGroup@rsrcdirDirectiveBean@servletRequest"
                    />

                <%-------  Active Time In Group Switch -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="SWITCH_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="activeTimeInGroupSwitch@rsrcdirDirectiveBean@servletRequest" />
              </uix:rowLayout>

              <uix:rowLayout>
                <%-------  Connect Time -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="CONNECT_TIME_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText
                    styleClass="OraDataText"
                    textBinding="connectTime@rsrcdirDirectiveBean@servletRequest"
                    />

                <%-------  Connect Time Switch -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="SWITCH_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="connectTimeSwitch@rsrcdirDirectiveBean@servletRequest" />
              </uix:rowLayout>

              <uix:rowLayout>
                <%-------  Idle Time In Group -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="IDLE_TIME_IN_GROUP_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText
                    styleClass="OraDataText"
                    textBinding="idleTimeInGroup@rsrcdirDirectiveBean@servletRequest"
                    />

                <%-------  Idle Time In Group Switch -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="SWITCH_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="idleTimeInGroupSwitch@rsrcdirDirectiveBean@servletRequest" />
              </uix:rowLayout>

              <uix:rowLayout>
                <%-------  Idle Blocker Time -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="IDLE_BLOCKER_TIME_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="idleBlockerTime@rsrcdirDirectiveBean@servletRequest"
                    />

              </uix:rowLayout>

              <uix:rowLayout>
                <%-------  Group Max Sessions -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="GROUP_MAX_SESSIONS_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText
                    styleClass="OraDataText"
                    textBinding="groupMaxSessions@rsrcdirDirectiveBean@servletRequest"
                    />
              </uix:rowLayout>

            </uix:tableLayout>

          </uix:header>

          <%-------------------------
           -  Both Midtier and Client-Server Parameters
           ---------------------------%>
          <uix:header
               textBinding="MIDTIER_CLIENT_SERVER_HDR@rsrcDirectiveBundle@servletRequest"
               >
            <uix:tableLayout cellSpacing="5">

              <uix:rowLayout>
                <%-------  Use Active Time Estimate  -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="USE_ACTIVE_TIME_ESTIMATE_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="useTimeInStatementEstimate@rsrcdirDirectiveBean@servletRequest"
                    />
              </uix:rowLayout>

              <uix:rowLayout>
                <%-------  Parallel Degree Limit  -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="PARALLEL_DEGREE_LIMIT_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="parallelDegreeLimit@rsrcdirDirectiveBean@servletRequest"
                    />
              </uix:rowLayout>

              <uix:rowLayout>
                <%-------  Private Memory Target  -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="PRIVATE_MEMORY_TARGET_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="privateMemoryTarget@rsrcdirDirectiveBean@servletRequest"
                    />
              </uix:rowLayout>

              <uix:rowLayout>
                <%-------  Undo Quota  -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="UNDO_QUOTA_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="undoQuota@rsrcdirDirectiveBean@servletRequest"
                    />
              </uix:rowLayout>

              <uix:rowLayout>
                <%-------  Temp Quota  -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="TEMP_QUOTA_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="tempQuota@rsrcdirDirectiveBean@servletRequest"
                    />
              </uix:rowLayout>

              <uix:rowLayout>
                <%-------  Active Session Limit  -------%>
                <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="ACTIVE_SESSION_LIMIT_PROMPT@rsrcDirectiveBundle@servletRequest" />
                </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                    textBinding="activeSessionLimit@rsrcdirDirectiveBean@servletRequest"
                    />
              </uix:rowLayout>

            </uix:tableLayout>

          </uix:header>

          <%--------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <%-------  OK Button to cancel the view -------%>
              <uix:submitButton
                name="event" 
                textBinding="OK@uixDBObjectBundle@servletRequest"
                value="cancel"
                />
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%-----------------------------  End of File  --------------------------------%>
