<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="groupForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcgrpBean@servletRequest">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcgrp/rsrcgrpGeneral"/>

        <uix:pageLayout
          titleBinding="header@rsrcgrpBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

<uix:messages>
<uix:stackLayout>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
</uix:stackLayout>
</uix:messages>

          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                  <uix:link textBinding="GENERAL@rsrcGroupBundle@servletRequest" />
                  <uix:link textBinding="ROLES@rsrcGroupBundle@servletRequest"
                     onClick="submitForm('groupForm', true, {event:'rolesTab'})"/>
              </uix:subTabBar> 
            </uix:subTabs>

            <uix:spacer height="10"/>
                    <uix:styledText
                      styleClass="OraInstructionText"
                      textBinding="RSRC_GROUP_INSTR@rsrcGroupBundle@servletRequest"
                      />
            <uix:spacer height="10"/>

            <%-----------------------------
             -  Labeled Fields
             -----------------------------%>
            <uix:labeledFieldLayout width="75%">
              <%---------------------%>
              <%---  Group Name   ---%>
              <%---------------------%>
              <%---  group name field is *read-only* in edit mode ---%>
              <%---  group name field is editable only during creation ---%>
              <uix:messageTextInput 
                name="groupName" 
                promptBinding="CONSUMER_GROUP_PROMPT@rsrcGroupBundle@servletRequest"
                textBinding="groupName@rsrcgrpGroupBean@servletRequest"
                messageBinding="(CONSUMER_GROUP_PROMPT@rsrcGroupBundle@servletRequest)@errors@servletRequest"
                messageTypeBinding="(CONSUMER_GROUP_PROMPT@rsrcGroupBundle@servletRequest)@messageTypes@servletRequest"
                columns="50"
                contentStyleClassBinding="groupNameStyleClass@rsrcgrpBean@servletRequest"
                requiredBinding="groupNameRequired@rsrcgrpBean@servletRequest"
                readOnlyBinding="notCreating@rsrcgrpBean@servletRequest"
                />

              <%---------------------%>
              <%---  Description  ---%>
              <%---------------------%>

              <uix:messageTextInput 
                name="description" 
                promptBinding="DESCRIPTION_PROMPT@rsrcGroupBundle@servletRequest"
                textBinding="description@rsrcgrpGroupBean@servletRequest"
                columns="50"
                readOnly="false"
                />

            </uix:labeledFieldLayout>

            <%-------------------------
             -  Scheduling Policy
             ---------------------------%>
            <uix:switcher childNameBinding="dbVersionPre10@rsrcgrpBean@servletRequest">
              <uix:case name="false">
                <uix:tableLayout cellSpacing="10">
                  <uix:rowLayout> 
                    <uix:styledText
                      styleClass="OraInstructionText"
                      textBinding="RSRC_GROUP_SCHED_POLICY_INSTR@rsrcGroupBundle@servletRequest"
                      />
                  </uix:rowLayout> 
                </uix:tableLayout>

                <uix:labeledFieldLayout width="75%">
                    <uix:styledText 
                      labeledNodeId="selectedSchedulingPolicy"
                      styleClass="OraPromptText"
                      textBinding="SCHEDULING_POLICY@rsrcGroupBundle@servletRequest"
                    />

                    <oem:choice
                      id="selectedSchedulingPolicy"
                      name="selectedSchedulingPolicy"
                      selectedValueBinding="selectedSchedulingPolicy@rsrcgrpGroupBean@servletRequest"
                      optionsBinding="schedulingPolicies@rsrcgrpGroupBean@servletRequest"
                      >
                    </oem:choice>
                </uix:labeledFieldLayout>
              </uix:case>
            </uix:switcher>

            <%---------------------------
             -   Selected User Table    -
             ---------------------------%>

            <uix:header 
              textBinding="SELECTED_USERS@rsrcGroupBundle@servletRequest"
              >

              <%---  Add Button  ---%>
              <uix:tableLayout width="80%"> 
                <uix:rowLayout hAlign="right"> 
                  <uix:cellFormat> 
                    <uix:contents> 
                      <uix:submitButton 
                        textBinding="ADD@rsrcGroupBundle@servletRequest"
                        name="event"
                        value="addButton" 
                        formName="groupForm"
                      />
                    </uix:contents> 
                  </uix:cellFormat> 
                </uix:rowLayout> 
              </uix:tableLayout> 

              <%--- User Table ---%>
              <oem:table 
                copyParams="target,type,cancelURL,oname,otype"
                summaryBinding="SELECTED_USERS@rsrcGroupBundle@servletRequest"
                width="80%" 
                blockSize="25"
                formSubmitted="true"
                name="userTable" 
                dataSourceProp="userTable"
                beanKey="rsrcgrpSelUsersTableBean"
                alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                >
                <uix:tableSelection>
                  <uix:multipleSelection
                    selectedBinding="selected"
                    shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                    selectionBinding="selection@rsrcgrpSelUsersTableBean@servletRequest"
                    >
                    <uix:submitButton
                      textBinding="REMOVE@rsrcGroupBundle@servletRequest"
                      name="event"
                      value="deleteButton"
                      formName="groupForm"
                    />
                  </uix:multipleSelection>
                </uix:tableSelection>
              </oem:table>

              <uix:switcher
                childNameBinding="hasNonVisSelections@rsrcgrpSelUsersTableBean@servletRequest">
                <uix:case name="true">
                  <uix:tip>
                    <uix:styledText 
                      styleClass="OraTipText"
                      textBinding="selectionTip@rsrcgrpSelUsersTableBean@servletRequest" />
                  </uix:tip>
                </uix:case>
              </uix:switcher>

            </uix:header>

          </uix:subTabLayout>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

