<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="groupForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcgrpBean@servletRequest">

        <uix:pageLayout
          titleBinding="header@rsrcgrpBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <uix:formValue name="pageName" 
                         value="/database/instance/rsrcgrp/rsrcgrpRoles"/>

<uix:messages>
<uix:stackLayout>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
</uix:stackLayout>
</uix:messages>

          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                  <uix:link textBinding="GENERAL@rsrcGroupBundle@servletRequest"
                     onClick="submitForm('groupForm', true, {event:'generalTab'})"/>
                  <uix:link textBinding="ROLES@rsrcGroupBundle@servletRequest" />
              </uix:subTabBar> 
            </uix:subTabs>

            <%-------------------------
             -  Instruction Text
             ---------------------------%>
            <uix:styledText
              styleClass="OraInstructionText"
              textBinding="RSRC_GROUP_ROLES_INSTR@rsrcGroupBundle@servletRequest"
              />

            <%-------------------------
             -  Role Selection Shuttle
             ---------------------------%>
            <oem:shuttle 
              name="Roles" 
              size="15"
              reorderable="false"
              leadingHeaderBinding="AVAILABLE_ROLES@rsrcGroupBundle@servletRequest"
              trailingHeaderBinding="SELECTED_ROLES@rsrcGroupBundle@servletRequest"
              >

              <uix:leading>
                <oem:list
                  name="availRoles"
                  multiple="true"
                  shortDescBinding="AVAILABLE_ROLES@rsrcGroupBundle@servletRequest"
                  optionsBinding="availRoles@rsrcgrpBean@servletRequest"/>
              </uix:leading>

              <uix:trailing>
                <oem:list
                  name="selRoles"
                  multiple="true"
                  shortDescBinding="SELECTED_ROLES@rsrcGroupBundle@servletRequest"
                  optionsBinding="selRoles@rsrcgrpGroupBean@servletRequest"/>
              </uix:trailing>

            </oem:shuttle>

          </uix:subTabLayout>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

