<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="selectUserForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcgrpBean@servletRequest">

        <uix:pageLayout
          titleBinding="header@rsrcgrpBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <uix:formValue 
            name="pageName" 
            value="/database/instance/rsrcgrp/rsrcgrpSelectUser"/>

<uix:messages>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

          <%-------------------------
           -  Search Filter
           ---------------------------%>
          <uix:header
            textBinding="SEARCH@uixDBObjectBundle@servletRequest">

            <uix:rowLayout>

              <%---- Search Filter Instructions ----%>
              <uix:styledText 
                textBinding="ENTER_OBJECT_NAME@uixDBObjectBundle@servletRequest"/>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:tableLayout cellSpacing="2">
              <uix:cellFormat vAlign="top">
                <uix:rowLayout>
                  <uix:stackLayout>

                    <uix:flowLayout>

                      <%---- Search Prompt ----%>
                      <uix:styledText
                        labeledNodeId="searchFilter"
                        textBinding="AVAILABLE_USERS@rsrcGroupBundle@servletRequest"/>

                      <%---- Search Input Field ----%>
                      <uix:textInput
                        id="searchFilter"
                        name="searchFilter"
                        textBinding="searchFilter@rsrcgrpAvailUsersTableBean@servletRequest"/>

                      <%---- GO Button ----%>
                      <uix:submitButton 
                        textBinding="GO@uixDBObjectBundle@servletRequest"
                        onFocus="true"
                        selected="true" name="event" value="search"/>

                    </uix:flowLayout>

                    <%---- Error Message Box ----%>
                    <oem:messageBox 
                      messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText"
                      mainTextKey="mainText"/>

                  </uix:stackLayout>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:tableLayout>
          </uix:header>

          <%-------------------------
           -  Available Users Table
           ---------------------------%>

          <uix:header 
            textBinding="AVAILABLE_USERS@rsrcGroupBundle@servletRequest"
            >

            <oem:table 
              copyParams="target,type,cancelURL,oname,otype"
              summaryBinding="AVAILABLE_USERS@rsrcGroupBundle@servletRequest"
              width="80%" 
              blockSize="25"
              formSubmitted="true"
              name="availUserTable" 
              beanKey="rsrcgrpAvailUsersTableBean"
              dataSourceProp="availUserTable"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
              <uix:tableSelection>
                <uix:multipleSelection 
                  selectedBinding="selected"
                  shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                  selectionBinding="selection@rsrcgrpAvailUsersTableBean@servletRequest"
                  >
                </uix:multipleSelection>
              </uix:tableSelection>
            </oem:table>

            <uix:switcher
              childNameBinding="hasNonVisSelections@rsrcgrpAvailUsersTableBean@servletRequest">
              <uix:case name="true">
                <uix:tip>
                  <uix:styledText 
                    styleClass="OraTipText"
                    textBinding="selectionTip@rsrcgrpAvailUsersTableBean@servletRequest" />
                </uix:tip>
              </uix:case>
            </uix:switcher>

          </uix:header>

          <%-------------------------
           -  PageButtons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:submitButton
                name="event" 
                textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                value="cancelSelect"/>

              <uix:submitButton
                name="event" 
                textBinding="SELECT@uixDBObjectBundle@servletRequest"
                value="selectUsers"/>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

