<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <db:form
        copyParams="target,type,cancelURL,oname,otype"
        name="groupViewForm" 
        method="post"
        destinationBinding="defaultControllerURL@rsrcgrpBean@servletRequest">

        <uix:formValue 
          name="pageName" 
          value="/database/instance/rsrcgrp/rsrcgrpView"/>

        <uix:pageLayout
          titleBinding="header@rsrcgrpBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

<uix:messages>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
</uix:messages>

          <uix:labeledFieldLayout width="75%">
            <%-------------------------
             -  Consumer Group
             ---------------------------%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="CONSUMER_GROUP_PROMPT@rsrcGroupBundle@servletRequest"/>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="groupName@rsrcgrpGroupBean@servletRequest"/>

            <%-------------------------
             -  Description
             ---------------------------%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="DESCRIPTION_PROMPT@rsrcGroupBundle@servletRequest"/>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="description@rsrcgrpGroupBean@servletRequest"/>
          </uix:labeledFieldLayout>

          <%-------------------------
           -  Scheduling Policy
           ---------------------------%>
          <uix:switcher childNameBinding="dbVersionPre10@rsrcgrpBean@servletRequest">
            <uix:case name="false">
              <uix:labeledFieldLayout width="75%">
                <uix:styledText 
                  styleClass="OraPromptText"
                  textBinding="SCHEDULING_POLICY@rsrcGroupBundle@servletRequest"
                />

                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="selectedSchedulingPolicy@rsrcgrpGroupBean@servletRequest"
                />
              </uix:labeledFieldLayout>
            </uix:case>
          </uix:switcher>

          <%-------------------------
           -  Roles List
           ---------------------------%>
          <uix:switcher childNameBinding="hasRoles@rsrcgrpGroupBean@servletRequest">
            <uix:case name="true">
              <uix:labeledFieldLayout width="75%">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="ROLES_PROMPT@rsrcGroupBundle@servletRequest"/>
                <oem:list
                  name="selRoles" 
                  optionsBinding="selRoles@rsrcgrpGroupBean@servletRequest"
                />
              </uix:labeledFieldLayout>
            </uix:case>
          </uix:switcher>

          <%-------------------------
           -  Users Table
           ---------------------------%>
          <uix:header 
            textBinding="SELECTED_USERS@rsrcGroupBundle@servletRequest"
            >
            <oem:table 
              copyParams="target,type,cancelURL,oname,otype"
              summaryBinding="SELECTED_USERS@rsrcGroupBundle@servletRequest"
              width="80%" 
              blockSize="25"
              formSubmitted="true"
              name="userViewTable" 
              dataSourceProp="userViewTable"
              beanKey="rsrcgrpSelUsersTableBean"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>
          </uix:header>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <jsp:include page="/database/storage/storagePageButtonViewInclude.jsp" />
              <uix:ref refID="storagePageButtonViewInclude" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

